/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class NumberCellRenderer
extends DefaultTableCellRenderer {
    private Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _prefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)this._p);
    private NumberFormat _percentageFormat = NumericFormat.getInstance(true, this._prefenceSettings.getPercentagePrecisionLevel(), 0, 0);
    private NumberFormat _numericalFormat = NumericFormat.getInstance(true, this._prefenceSettings.getNumericalPrecisionLevel(), 0, 0);

    public NumberCellRenderer() {
        this._percentageFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
        this._percentageFormat.setMinimumIntegerDigits(1);
        this._numericalFormat.setMaximumFractionDigits(this._prefenceSettings.getPercentagePrecisionLevel());
        this._numericalFormat.setMinimumIntegerDigits(1);
    }

    @Override
    protected void setValue(Object object) {
        if (object != null) {
            String string = null;
            if (object instanceof Double) {
                string = this._percentageFormat.format((Double)object);
            } else if (object instanceof Integer) {
                string = this._numericalFormat.format(((Integer)object).intValue());
            } else if (object instanceof BigDecimal) {
                string = this._numericalFormat.format(((BigDecimal)object).doubleValue());
            }
            super.setValue(string);
        } else {
            super.setValue(object);
        }
    }
}

