/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.text.NumberTextField;

public class NumberCellEditor
extends DefaultCellEditor {
    Class[] argTypes = new Class[]{String.class};
    Constructor constructor;
    Object value;
    private Locale _locale;

    public NumberCellEditor(Locale locale) {
        super((JTextField)new NumberTextField());
        this._locale = locale;
        this.commonConstructor();
    }

    public NumberCellEditor() {
        this((Locale)null);
    }

    public NumberCellEditor(Locale locale, NumberTextField numberTextField) {
        super((JTextField)numberTextField);
        this._locale = locale;
    }

    private void commonConstructor() {
        this.setup();
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object object) {
                Number number = null;
                String string = "";
                if (object instanceof String) {
                    string = (String)object;
                    try {
                        NumberFormat numberFormat = NumberFormat.getInstance();
                        number = numberFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        System.out.println(parseException);
                        number = null;
                    }
                } else if (object instanceof Number) {
                    number = (Number)object;
                }
                if (number != null) {
                    ((NumberTextField)NumberCellEditor.this.editorComponent).setNumber(number);
                } else {
                    ((JTextField)NumberCellEditor.this.editorComponent).setText(string);
                }
            }

            @Override
            public Object getCellEditorValue() {
                return ((NumberTextField)NumberCellEditor.this.editorComponent).getText();
            }
        };
    }

    private void setup() {
        ((NumberTextField)this.editorComponent).setDataType(Double.class);
        ((NumberTextField)this.editorComponent).setSigned(false);
        if (this._locale == null) {
            this._locale = Locale.getDefault();
        }
        ((NumberTextField)this.editorComponent).setLocale(this._locale);
        this.editorComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NumberCellEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public boolean stopCellEditing() {
        String string = (String)super.getCellEditorValue();
        if ("".equals(string)) {
            if (this.constructor.getDeclaringClass() == String.class) {
                this.value = string;
            }
            super.stopCellEditing();
        }
        try {
            this.value = this.constructor.newInstance(string);
        }
        catch (Exception exception) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = null;
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        try {
            Class<Object> clazz = jTable.getColumnClass(n2);
            if (clazz == Object.class) {
                clazz = String.class;
            }
            this.constructor = clazz.getConstructor(this.argTypes);
        }
        catch (Exception exception) {
            return null;
        }
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    @Override
    public Object getCellEditorValue() {
        NumberTextField numberTextField = (NumberTextField)this.getComponent();
        Number number = numberTextField.getNumber();
        BigDecimal bigDecimal = new BigDecimal(number.doubleValue());
        return bigDecimal;
    }
}

