/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.javatools.ui.table.table.GenericBaseTableModel;
import oracle.dmt.javatools.ui.table.table.GenericTable;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class NiceTableWithToolbar {
    private GenericTable _niceTable = new GenericTable();
    private FilterNiceTableModel _niceTableModel = null;
    private ComponentWithTitlebar<JComponent> _compToolbar;
    private SearchField _searchField;
    private Component _findPane;
    private String[] _filterColumns;
    private HashMap<SearchCategory, Integer> _catToIndexMap = new HashMap();

    public NiceTableWithToolbar(ComponentWithTitlebar<JComponent> componentWithTitlebar, ControlBar controlBar, String[] stringArray, GenericBaseTableModel genericBaseTableModel) {
        this(componentWithTitlebar, controlBar, stringArray, null, genericBaseTableModel);
    }

    public NiceTableWithToolbar(ComponentWithTitlebar<JComponent> componentWithTitlebar, ControlBar controlBar, String[] stringArray, String[] stringArray2, GenericBaseTableModel genericBaseTableModel) {
        this._compToolbar = componentWithTitlebar;
        if (stringArray2 == null || stringArray2.length == 0) {
            this._filterColumns = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this._filterColumns, 0, stringArray.length);
        } else {
            this._filterColumns = stringArray2;
        }
        this.setNiceTableModel(stringArray, genericBaseTableModel);
        this._niceTable.setAutoResizeMode(4);
        this._niceTable.getTableHeader().setAutoscrolls(true);
        this._niceTable.setDragEnabled(false);
        JScrollPane jScrollPane = new JScrollPane((Component)this._niceTable);
        this._compToolbar.setComponent((JComponent)jScrollPane);
        this._findPane = this.createFindPane();
        if (controlBar.getComponentCount() > 0) {
            controlBar.addSeparator();
        }
        controlBar.add(this._findPane);
        this._compToolbar.setControlBar(controlBar);
    }

    public GenericTable getNiceTable() {
        return this._niceTable;
    }

    public void resetNiceTableModel(GenericBaseTableModel genericBaseTableModel) {
        Rectangle rectangle = this._niceTable.getVisibleRect();
        this._niceTableModel.setNiceTableModel(genericBaseTableModel);
        this._niceTableModel.setRowCount(genericBaseTableModel.getRowCount());
        this._niceTableModel.fireTableDataChanged();
        this._niceTable.scrollRectToVisible(rectangle);
    }

    public void setNiceTableModel(String[] stringArray, GenericBaseTableModel genericBaseTableModel) {
        this._niceTableModel = new FilterNiceTableModel(stringArray, genericBaseTableModel);
        this._niceTable.setModel((TableModel)((Object)this._niceTableModel));
        this._niceTable.setSorted(true);
        this._niceTable.setUpdateSelectionOnSort(true);
        this._niceTable.getTableHeader().setReorderingAllowed(false);
    }

    public int[] getSelectedRowsInModel() {
        int[] nArray = this._niceTable.getSelectedRowsInModel();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this._niceTableModel.getFilterToModelIdx(nArray[i]);
        }
        return nArray;
    }

    public int convertRowToModelIndex(int n) {
        int n2 = this._niceTable.convertRowIndexToModel(n);
        return this._niceTableModel.getFilterToModelIdx(n2);
    }

    private Dimension derive(Dimension dimension, int n) {
        return new Dimension(n, dimension.height);
    }

    protected Component createFindPane() {
        Box box = new Box(2);
        this._searchField = this.searchField();
        this.initSearchCategory();
        box.setName("Find");
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        box.add((Component)this._searchField);
        Dimension dimension = box.getPreferredSize();
        Dimension dimension2 = this.derive(dimension, 200);
        Dimension dimension3 = this.derive(dimension, 120);
        box.setPreferredSize(dimension2);
        box.setMaximumSize(dimension2);
        box.setMinimumSize(dimension3);
        return box;
    }

    protected void initSearchCategory() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (String object : this.getFilterColumns()) {
            hashMap.put(object, Boolean.TRUE);
        }
        TableColumnModel tableColumnModel = this._niceTable.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            String string = tableColumn.getIdentifier().toString();
            if (hashMap.containsKey(string)) {
                SearchCategory searchCategory = new SearchCategory(string);
                this._searchField.addCategory(searchCategory);
                if (this._searchField.getSelectedCategory() == null) {
                    this._searchField.setSelectedCategory(searchCategory);
                }
                this._catToIndexMap.put(searchCategory, new Integer(n));
            }
            ++n;
        }
    }

    private SearchField searchField() {
        SearchField searchField = new SearchField();
        searchField.setStyle(SearchField.Style.FILTER);
        searchField.setAutoFind(true);
        searchField.setPrompt(InspectorArb.getString((int)34));
        searchField.setNotifyOnEmptySearch(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                NiceTableWithToolbar.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                NiceTableWithToolbar.this.processFilter(string);
            }
        });
        return searchField;
    }

    protected void processFilter(String string) {
        assert (string != null) : "name filter must be non null";
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        ideMainWindow.setCursor(new Cursor(3));
        Integer n = this._catToIndexMap.get(this._searchField.getSelectedCategory());
        int n2 = this._niceTableModel.filter(n, string);
        this._niceTableModel.setRowCount(n2);
        this._niceTableModel.fireTableDataChanged();
        ideMainWindow.setCursor(new Cursor(0));
    }

    public ComponentWithTitlebar getCompToolbar() {
        return this._compToolbar;
    }

    public GenericBaseTableModel getNiceTableModel() {
        return this._niceTableModel.getNiceTableModel();
    }

    public String[] getFilterColumns() {
        return this._filterColumns;
    }

    private class FilterNiceTableModel
    extends GenericBaseTableModel {
        private GenericBaseTableModel _niceTableModel = null;
        private HashMap<Integer, Integer> _filterIndexMap = new HashMap();

        public FilterNiceTableModel(String[] stringArray, GenericBaseTableModel genericBaseTableModel) {
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(genericBaseTableModel.getRowCount());
            this.setColumnCount(genericBaseTableModel.getColumnCount());
            this._niceTableModel = genericBaseTableModel;
            for (int i = 0; i < this._niceTableModel.getRowCount(); ++i) {
                this._filterIndexMap.put(new Integer(i), new Integer(i));
            }
        }

        int getModelToFilterIdx(int n) {
            Set<Integer> set = this._filterIndexMap.keySet();
            for (Integer n2 : set) {
                Integer n3 = this._filterIndexMap.get(n2);
                if (n3 != n) continue;
                return n2;
            }
            return -1;
        }

        int getFilterToModelIdx(int n) {
            Integer n2 = this._filterIndexMap.get(new Integer(n));
            return n2;
        }

        int filter(Integer n, String string) {
            int n2;
            this._filterIndexMap.clear();
            for (n2 = 0; n2 < this._niceTableModel.getRowCount(); ++n2) {
                this._filterIndexMap.put(new Integer(n2), new Integer(n2));
            }
            if (string.length() > 0) {
                this._filterIndexMap.clear();
                n2 = 0;
                for (int i = 0; i < this._niceTableModel.getRowCount(); ++i) {
                    Object object = this._niceTableModel.getValueAt(i, n.intValue());
                    if (object == null || !object.toString().toLowerCase().startsWith(string.toLowerCase())) continue;
                    this._filterIndexMap.put(new Integer(n2++), new Integer(i));
                }
            }
            return this._filterIndexMap.size();
        }

        public boolean isCellEditable(int n, int n2) {
            Integer n3 = this._filterIndexMap.get(n);
            return this._niceTableModel.isCellEditable(n3.intValue(), n2);
        }

        public Class<?> getColumnClass(int n) {
            return this._niceTableModel.getColumnClass(n);
        }

        public Object getValueAt(int n, int n2) {
            Integer n3 = this._filterIndexMap.get(n);
            if (n3 == null) {
                return null;
            }
            return this._niceTableModel.getValueAt(n3.intValue(), n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            Integer n3 = this._filterIndexMap.get(n);
            if (n3 != null) {
                this._niceTableModel.setValueAt(object, n3.intValue(), n2);
            }
        }

        public void setNiceTableModel(GenericBaseTableModel genericBaseTableModel) {
            this._niceTableModel = genericBaseTableModel;
            this.setRowCount(genericBaseTableModel.getRowCount());
            for (int i = 0; i < this._niceTableModel.getRowCount(); ++i) {
                this._filterIndexMap.put(new Integer(i), new Integer(i));
            }
        }

        public GenericBaseTableModel getNiceTableModel() {
            return this._niceTableModel;
        }
    }
}

