/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import oracle.dmt.dataminer.controls.DayComponent;

class MonthComponent
extends JComboBox
implements ItemListener {
    private DayComponent _dp;
    private Calendar _cal;
    private DateFormatSymbols _dfSymbols;

    public MonthComponent(Calendar calendar, DayComponent dayComponent, Locale locale) {
        this._cal = calendar;
        this._dp = dayComponent;
        this._dfSymbols = new DateFormatSymbols(locale);
        Integer[] integerArray = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        this.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        this.setRenderer(new MonthRenderer());
        this.addItemListener(this);
        int n = this._cal.get(2);
        this.setSelectedItem(n);
        this.setBackground(UIManager.getColor("TextArea.background"));
        this.setOpaque(false);
    }

    public void updateDisplay() {
        this.setSelectedIndex(this._cal.get(2));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        this._cal.set(2, (Integer)this.getSelectedItem());
        this._dp.rebuild();
    }

    void cleanUp() {
        this._dp = null;
        this._cal = null;
    }

    private class MonthRenderer
    extends DefaultListCellRenderer {
        private MonthRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Integer) {
                jLabel.setText(MonthComponent.this._dfSymbols.getMonths()[(Integer)object]);
            }
            return jLabel;
        }
    }
}

