/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LabelButtonPane
extends JPanel {
    private String _labelText = null;
    public String _defaultDisplayText = "";
    private int _numberOfSpaces = 0;
    private JButton _jButton;
    private JLabel _jLabel;

    public LabelButtonPane(String string, int n) {
        this._labelText = string;
        this._numberOfSpaces = n;
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this._jLabel = new JLabel();
        this._jButton = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this._jLabel.setBackground(new Color(255, 255, 255));
        this._jLabel.setText("Select Table");
        this._jLabel.setAlignmentY(0.0f);
        this._jLabel.setOpaque(true);
        this._jButton.setBackground(new Color(255, 255, 255));
        this._jButton.setText("...");
        this._jButton.setBorder(BorderFactory.createEtchedBorder());
        this._jButton.setFocusPainted(true);
        this._jButton.setMargin(new Insets(0, 0, 0, 0));
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.add((Component)this._jLabel, "West");
        this.add((Component)this._jButton, "East");
    }

    public void initUI() {
        this.setBackground(new Color(255, 255, 255));
        this.updateText();
    }

    private void updateText() {
        String string = "";
        for (int i = 0; i < this._numberOfSpaces; ++i) {
            string = string + " ";
        }
        string = this._labelText == null ? string + this._defaultDisplayText : string + this._labelText;
        this._jLabel.setText(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this._jLabel.setEnabled(bl);
        this._jButton.setEnabled(bl);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._jLabel != null) {
            this._jLabel.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._jLabel != null) {
            this._jLabel.setForeground(color);
        }
    }

    public void setLabelText(String string) {
        this._labelText = string;
        this.updateText();
    }

    public JButton getButton() {
        return this._jButton;
    }

    public JLabel getLabel() {
        return this._jLabel;
    }

    public void setNumberofSpaces(int n) {
        this._numberOfSpaces = n;
    }

    public void setDefaultDisplayText(String string) {
        this._defaultDisplayText = string;
        this.updateText();
    }
}

