/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class HistogramBarRenderer
extends JComponent
implements TableCellRenderer {
    private Border unselectedBorder = null;
    private Border selectedBorder = null;
    private boolean isBordered = true;
    private boolean showLabel = false;
    private NumberFormat labelFormat;
    private static Color positiveColor = new Color(195, 212, 232);
    private static Color negativeColor = new Color(232, 72, 0);
    private JProgressBar bar;
    private long maximumValue = 100L;

    public HistogramBarRenderer(long l, boolean bl, NumberFormat numberFormat) {
        assert (l > 0L) : "Bar maximum value must be greater than 0";
        assert (numberFormat != null) : "NumberFormat can not be null.";
        this.isBordered = true;
        this.showLabel = bl;
        this.labelFormat = numberFormat;
        this.bar = new JProgressBar();
        this.bar.setMinimum(0);
        this.maximumValue = l;
        this.setLayout(new BorderLayout());
        this.add("Center", this.bar);
        this.bar.setStringPainted(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Number number;
        int n3 = 0;
        String string = "";
        if (object instanceof Number) {
            number = (Number)object;
            Double d = new Double(number.doubleValue() < 0.0 ? number.doubleValue() * -1.0 : number.doubleValue());
            Double d2 = d / (double)this.maximumValue;
            Double d3 = d2 * 100.0;
            n3 = d3.intValue();
            if (this.showLabel) {
                string = this.labelFormat.format(number.doubleValue()) + "";
            }
        } else {
            n3 = 0;
            number = new Double(0.0);
        }
        this.bar.setMaximum(100);
        this.bar.setValue(n3);
        if (this.showLabel) {
            this.bar.setString(string);
            this.bar.setToolTipText(string);
        }
        if (this.isBordered) {
            if (bl) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        this.bar.setBackground(Color.white);
        this.bar.setBorderPainted(false);
        if (bl) {
            this.bar.setBackground(jTable.getSelectionBackground());
        } else {
            this.bar.setBackground(jTable.getBackground());
        }
        if (number.doubleValue() < 0.0) {
            this.bar.setForeground(negativeColor);
        } else {
            this.bar.setForeground(positiveColor);
        }
        return this;
    }

    public String getText() {
        return this.bar.getString();
    }

    public void setIsBordered(boolean bl) {
        this.isBordered = bl;
    }

    public boolean isIsBordered() {
        return this.isBordered;
    }

    public static void setPositiveColor(Color color) {
        assert (color != null) : "Color must not be null";
        if (color == null) {
            return;
        }
        positiveColor = color;
    }

    public static Color getPositiveColor() {
        return positiveColor;
    }

    public static void setNegativeColor(Color color) {
        assert (color != null) : "Color must not be null";
        if (color == null) {
            return;
        }
        negativeColor = color;
    }

    public static Color getNegativeColor() {
        return negativeColor;
    }

    public void setMaximumValue(long l) {
        if (l <= 0L) {
            return;
        }
        this.maximumValue = l;
    }

    public long getMaximumValue() {
        return this.maximumValue;
    }

    public void setShowLabel(boolean bl) {
        assert (bl && this.labelFormat != null) : "Can not set show label to true if NumberFormat is null.";
        if (bl && this.labelFormat == null) {
            return;
        }
        this.showLabel = bl;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setLabelFormat(NumberFormat numberFormat) {
        assert (numberFormat != null) : "NumberFormat must not be null";
        if (numberFormat == null) {
            return;
        }
        this.labelFormat = numberFormat;
    }

    public NumberFormat getLabelFormat() {
        return this.labelFormat;
    }
}

