/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.text.DateFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dmt.dataminer.controls.CalendarDateProvider;
import oracle.dmt.dataminer.controls.Day;

class DayComponent
extends JPanel {
    private boolean _isSelectionAdjusting = false;
    private SpreadTable _dayTable;
    private ArrayTwoDModel _tableModel = new ArrayTwoDModel(7, 6);
    private ArrayOneDModel _headerModel = new ArrayOneDModel(7);
    private static final int _DAYS_IN_WEEK = 7;
    private static final int _WEEKS_IN_MONTH = 6;
    private DateFormatSymbols _dfSymbols;
    private Calendar _cal;
    private boolean _isMultiSelect;
    private SimpleDateFormat _dayFormat = new SimpleDateFormat("d");
    private CalendarDateProvider _dateProvider;
    private Font _boldFont;
    private ImmInsets _cellInsets = new ImmInsets(0, 0, 0, 0);
    private TreeSet<Day> _selectedDays;
    private Day _minDay;
    private Day _maxDay;

    public DayComponent(Calendar calendar, boolean bl, TreeSet<Day> treeSet, Locale locale) {
        this._cal = calendar;
        this._isMultiSelect = bl;
        this._selectedDays = treeSet;
        this._minDay = null;
        this._dfSymbols = new DateFormatSymbols(locale);
        this._buildTableModel();
        this._buildColHeaderModel();
        this._dayTable = new CustomSpreadTable((TwoDModel)this._tableModel, (OneDModel)this._headerModel, null);
        this._customizeDayTable();
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this._dayTable);
    }

    public void rebuild() {
        this._buildTableModel();
        this._dayTable.setModels((TwoDModel)this._tableModel, (OneDModel)this._headerModel, null);
        this._updateSelection();
        this._updateAppearance();
    }

    private void _updateSelection() {
        this._isSelectionAdjusting = true;
        TwoDSelection twoDSelection = new TwoDSelection();
        for (int i = 0; i <= 5; ++i) {
            for (int j = 0; j <= 6; ++j) {
                Date date = this.getDateAt(j, i);
                if (date == null || !this.isInCurrentMonth(date) || !this._dateInRange(date) || !this._selectedDays.contains(new Day(date)) || this._dateProvider != null && !this._dateProvider.isDateValid(date)) continue;
                TwoDSelection twoDSelection2 = new TwoDSelection(j, i);
                twoDSelection = twoDSelection.add(twoDSelection2);
            }
        }
        try {
            this._dayTable.getGrid().setSelection(twoDSelection);
            this._dayTable.getGrid().repaint();
        }
        catch (PropertyVetoException propertyVetoException) {
            System.out.println("ui.calendar.DayPanel._updateSelection: VetoExeception");
        }
        this._isSelectionAdjusting = false;
    }

    private void _updateAppearance() {
        ComplexAppearanceManager complexAppearanceManager = (ComplexAppearanceManager)this._dayTable.getGrid().getAppearanceManager();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                Appearance appearance = complexAppearanceManager.getCellAppearance(j, i);
                Date date = this.getDateAt(j, i);
                if (date == null || !this.isInCurrentMonth(date)) {
                    appearance.setBackground(UIManager.getColor("TextArea.background"));
                    appearance.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                    appearance.setFont(this._boldFont);
                    appearance.setInsets(this._cellInsets);
                } else if (this._dateProvider != null && !this._dateProvider.isDateValid(date)) {
                    appearance.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                    appearance.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                } else if (!this._dateInRange(date)) {
                    appearance.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                    appearance.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                    appearance.setFont(this._boldFont);
                    appearance.setInsets(this._cellInsets);
                } else {
                    appearance.setBackground(UIManager.getColor("Table.background"));
                    appearance.setForeground(UIManager.getColor("TextArea.foreground"));
                    appearance.setFont(this._boldFont);
                    appearance.setInsets(this._cellInsets);
                }
                complexAppearanceManager.setCellAppearance(j, i, appearance);
            }
        }
    }

    public SpreadTable getTable() {
        return this._dayTable;
    }

    public Date getDateAt(int n, int n2) {
        Object object = this._tableModel.getData(n, n2);
        return object == null ? null : (Date)object;
    }

    public boolean isInCurrentMonth(Date date) {
        boolean bl = false;
        int n = this._cal.get(2);
        Date date2 = this._cal.getTime();
        this._cal.setTime(date);
        bl = this._cal.get(2) == n;
        this._cal.setTime(date2);
        return bl;
    }

    public void setMinimumDate(Date date) {
        this._minDay = date == null ? null : new Day(date);
        this._refreshSelectedDates();
        this.rebuild();
    }

    public Date getMinimumDate() {
        return this._minDay.getDate();
    }

    public void setMaximumDate(Date date) {
        this._maxDay = date == null ? null : new Day(date);
        this._refreshSelectedDates();
        this.rebuild();
    }

    public Date getMaximumDate() {
        return this._maxDay.getDate();
    }

    public void setDateProvider(CalendarDateProvider calendarDateProvider) {
        this._dateProvider = calendarDateProvider;
        this._refreshSelectedDates();
        this.rebuild();
    }

    public CalendarDateProvider getDateProvider() {
        return this._dateProvider;
    }

    private boolean _dateInRange(Date date) {
        if (this._minDay == null && this._maxDay == null) {
            return true;
        }
        if (date == null) {
            return false;
        }
        Day day = new Day(date);
        if (this._minDay != null && day.compareTo(this._minDay) < 0) {
            return false;
        }
        return this._maxDay == null || day.compareTo(this._maxDay) <= 0;
    }

    private void _refreshSelectedDates() {
        for (Day day : this._selectedDays.toArray(new Day[0])) {
            if (!this._dateInRange(day.getDate())) {
                this._selectedDays.remove(day);
            }
            if (this._dateProvider == null || this._dateProvider.isDateValid(day.getDate())) continue;
            this._selectedDays.remove(day);
        }
    }

    private void _buildTableModel() {
        Date date = this._cal.getTime();
        int n = this._cal.getFirstDayOfWeek() - 1;
        this._cal.set(5, 1);
        this._cal.add(5, 1 - this._cal.get(7) + n);
        int n2 = this._cal.get(5);
        if (n2 > 1 && n2 < 10) {
            this._cal.add(5, -7);
        }
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                this._tableModel.setData(j, i, (Object)this._cal.getTime());
                this._cal.add(5, 1);
            }
        }
        this._cal.setTime(date);
    }

    private void _buildColHeaderModel() {
        int n;
        int n2;
        this._headerModel = new ArrayOneDModel(7);
        for (n2 = n = this._cal.getFirstDayOfWeek(); n2 <= 7; ++n2) {
            this._headerModel.setData(n2 - n, (Object)this._dfSymbols.getShortWeekdays()[n2]);
        }
        for (n2 = 1; n2 < n; ++n2) {
            this._headerModel.setData(7 - n + n2, (Object)this._dfSymbols.getShortWeekdays()[n2]);
        }
    }

    private void _customizeDayTable() {
        Font font = UIManager.getFont("Label.font");
        this._boldFont = font.deriveFont(1).deriveFont((float)font.getSize() - 1.0f);
        Appearance appearance = this._dayTable.getColumnHeader().getAppearance();
        appearance.setHorizontalJustify(3);
        appearance.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        appearance.setInsets(this._cellInsets);
        Font font2 = font.deriveFont((float)font.getSize() - 1.0f);
        appearance.setFont(font2);
        this._dayTable.getColumnHeader().setAppearance(appearance);
        this._dayTable.setColumnHeaderHeight(16);
        this._dayTable.setFont(this._boldFont);
        NullPainter nullPainter = new NullPainter();
        this._dayTable.getColumnHeader().setFirstItemBorderPainter((BorderPainter)nullPainter);
        this._dayTable.getColumnHeader().setLastItemBorderPainter((BorderPainter)nullPainter);
        this._dayTable.getColumnHeader().setHeaderItemBorderPainter((BorderPainter)nullPainter);
        this._dayTable.getColumnHeader().setFont(this._boldFont);
        ComplexAppearanceManager complexAppearanceManager = new ComplexAppearanceManager();
        this._dayTable.getGrid().setAppearanceManager((AppearanceManager)complexAppearanceManager);
        appearance = complexAppearanceManager.getAppearance();
        appearance.setHorizontalJustify(3);
        appearance.setVerticalJustify(1);
        complexAppearanceManager.setAppearance(appearance);
        if (this._isMultiSelect) {
            this._dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 2));
        } else {
            this._dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 1));
        }
        this._dayTable.setHorizontalSeparatorsVisible(false);
        this._dayTable.setVerticalSeparatorsVisible(false);
        this._dayTable.getColumnHeader().setCanResizeItems(false);
        FormatPainter formatPainter = new FormatPainter((Format)this._dayFormat);
        this._dayTable.getGrid().setColumnPainter(0, (Painter)formatPainter);
        this._dayTable.getGrid().setColumnPainter(1, (Painter)formatPainter);
        this._dayTable.getGrid().setColumnPainter(2, (Painter)formatPainter);
        this._dayTable.getGrid().setColumnPainter(3, (Painter)formatPainter);
        this._dayTable.getGrid().setColumnPainter(4, (Painter)formatPainter);
        this._dayTable.getGrid().setColumnPainter(5, (Painter)formatPainter);
        this._dayTable.getGrid().setColumnPainter(6, (Painter)formatPainter);
        this._autoSetWidth();
    }

    private void _autoSetWidth() {
        int n = this._getMinColSize();
        this._dayTable.getGrid().setColumnWidth(0, n);
        this._dayTable.getGrid().setColumnWidth(1, n);
        this._dayTable.getGrid().setColumnWidth(2, n);
        this._dayTable.getGrid().setColumnWidth(3, n);
        this._dayTable.getGrid().setColumnWidth(4, n);
        this._dayTable.getGrid().setColumnWidth(5, n);
        this._dayTable.getGrid().setColumnWidth(6, n);
        this._dayTable.getColumnHeader().setPreferredHeaderSize(n * 7);
    }

    private int _getMinColSize() {
        int n;
        int n2 = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this._boldFont);
        for (String string : this._dfSymbols.getShortWeekdays()) {
            int n3 = SwingUtilities.computeStringWidth(fontMetrics, string);
            n2 = Math.max(n2, n3 += this._cellInsets.left + this._cellInsets.right);
        }
        for (n = 1; n <= 31; ++n) {
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, new Integer(n).toString());
            n2 = Math.max(n2, n4);
        }
        n = this._dayTable.getColumnGeometryManager().getSeparatorSize();
        return n2 += n;
    }

    void cleanUp() {
        this._dayTable = null;
        this._tableModel = null;
        this._headerModel = null;
        this._cal = null;
        if (this._selectedDays != null) {
            this._selectedDays.clear();
        }
        this._selectedDays = null;
        this._dateProvider = null;
    }

    private class DayGridSelectionManager
    extends GeneralGridSelectionManager {
        public DayGridSelectionManager(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public TwoDSelection modifySelection(TwoDSelection twoDSelection, TwoDSelection twoDSelection2, int n) {
            if (!DayComponent.this._isSelectionAdjusting) {
                switch (n) {
                    case 0: {
                        DayComponent.this._selectedDays.clear();
                        break;
                    }
                    case 2: {
                        twoDSelection2 = !DayComponent.this._isMultiSelect ? this._addSingleSelection(twoDSelection2) : this._addMultiSelection(twoDSelection2);
                        break;
                    }
                    case 1: {
                        this._removeSelection(twoDSelection2);
                    }
                }
            }
            if (twoDSelection2 == null) {
                DayComponent.this._updateSelection();
                twoDSelection2 = this.getSelection();
                n = 0;
            }
            return super.modifySelection(twoDSelection, twoDSelection2, n);
        }

        private boolean _isDateInCurrentMonth(Date date) {
            Date date2 = DayComponent.this._cal.getTime();
            int n = DayComponent.this._cal.get(2);
            DayComponent.this._cal.setTime(date);
            int n2 = DayComponent.this._cal.get(2);
            DayComponent.this._cal.setTime(date2);
            return n == n2;
        }

        private TwoDSelection _addSingleSelection(TwoDSelection twoDSelection) {
            DayComponent.this._selectedDays.clear();
            CellRange[] cellRangeArray = twoDSelection.getCellRanges();
            if (cellRangeArray != null) {
                Date date = DayComponent.this.getDateAt(twoDSelection.getSingleCell().column, twoDSelection.getSingleCell().row);
                if (date != null && this._isDateInCurrentMonth(date) && (DayComponent.this._dateProvider == null || DayComponent.this._dateProvider.isDateValid(date)) && DayComponent.this._dateInRange(date)) {
                    DayComponent.this._selectedDays.add(new Day(date));
                } else {
                    twoDSelection = twoDSelection.subtract(twoDSelection);
                }
            }
            return twoDSelection;
        }

        private TwoDSelection _addMultiSelection(TwoDSelection twoDSelection) {
            CellRange[] cellRangeArray = twoDSelection.getCellRanges();
            if (cellRangeArray != null) {
                for (int i = 0; i < cellRangeArray.length; ++i) {
                    CellRange cellRange = cellRangeArray[i];
                    for (int j = cellRange.getLowerLimit().column; j <= cellRange.getUpperLimit().column; ++j) {
                        for (int k = cellRange.getLowerLimit().row; k <= cellRange.getUpperLimit().row; ++k) {
                            Date date = DayComponent.this.getDateAt(j, k);
                            if (date != null && this._isDateInCurrentMonth(date) && (DayComponent.this._dateProvider == null || DayComponent.this._dateProvider.isDateValid(date)) && DayComponent.this._dateInRange(date)) {
                                DayComponent.this._selectedDays.add(new Day(date));
                                continue;
                            }
                            TwoDSelection twoDSelection2 = new TwoDSelection(new Cell(j, k));
                            twoDSelection = twoDSelection.subtract(twoDSelection2);
                        }
                    }
                }
            }
            return twoDSelection;
        }

        private void _removeSelection(TwoDSelection twoDSelection) {
            CellRange[] cellRangeArray = twoDSelection.getCellRanges();
            if (cellRangeArray != null) {
                for (int i = 0; i < cellRangeArray.length; ++i) {
                    CellRange cellRange = cellRangeArray[i];
                    for (int j = cellRange.getLowerLimit().column; j <= cellRange.getUpperLimit().column; ++j) {
                        for (int k = cellRange.getLowerLimit().row; k <= cellRange.getUpperLimit().row; ++k) {
                            Date date = DayComponent.this.getDateAt(j, k);
                            if (date == null || !this._isDateInCurrentMonth(date)) continue;
                            DayComponent.this._selectedDays.remove(new Day(date));
                        }
                    }
                }
            }
        }
    }

    private class CustomSpreadTable
    extends SpreadTable {
        public CustomSpreadTable(TwoDModel twoDModel, OneDModel oneDModel, OneDModel oneDModel2) {
            super(twoDModel, oneDModel, oneDModel2);
            this.setBorder(null);
        }

        protected Grid createGrid(TwoDModel twoDModel) {
            return new CustomGrid(twoDModel);
        }

        protected Header createColumnHeader(OneDModel oneDModel) {
            return new CustomColumnHeader(oneDModel);
        }

        private class CustomKeyHandler
        extends StandardGridKeyHandler {
            private CustomKeyHandler() {
            }

            protected Cell enter(Grid grid, Cell cell, KeyEvent keyEvent, boolean bl) {
                return cell;
            }
        }

        private class CustomColumnHeader
        extends Header {
            public CustomColumnHeader(OneDModel oneDModel) {
                super(oneDModel);
            }

            public boolean isFocusable() {
                return false;
            }

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
            }

            public Header.AccessibleHeader createAccessibleHeader() {
                return new AccessibleDayHeader();
            }

            private class AccessibleDayHeader
            extends Header.AccessibleHeader {
                private AccessibleDayHeader() {
                    super((Header)CustomColumnHeader.this);
                }

                public String getAccessibleName(int n) {
                    int n2 = DayComponent.this._cal.getFirstDayOfWeek();
                    int n3 = n2 + n;
                    n3 = n3 > 7 ? n3 - 7 : n3;
                    return DayComponent.this._dfSymbols.getWeekdays()[n3];
                }
            }
        }

        private class CustomGrid
        extends Grid {
            public CustomGrid(TwoDModel twoDModel) {
                super(twoDModel);
                this.setGridKeyHandler((GridKeyHandler)new CustomKeyHandler());
            }
        }
    }
}

