/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.dmt.dataminer.controls.PeerTreeSelectionModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.TreeTableModel;
import oracle.javatools.ui.checktree.TriStateNode;

public class BaseTreeTable
extends JFastTreeTable
implements ActionListener {
    private boolean _bPeerSelection = false;
    private boolean _checkBoxesEnabled = false;
    private boolean _showGrid = false;
    protected JPopupMenu _popup = null;

    public BaseTreeTable(TreeTableModel treeTableModel) {
        super(treeTableModel);
    }

    public void setShowGrid(boolean bl) {
        this._showGrid = bl;
        super.setShowGrid(bl);
    }

    public BaseTreeTable(TreeTableModel treeTableModel, boolean bl) {
        this(treeTableModel);
        this._bPeerSelection = bl;
        if (bl) {
            this.setPeerTreeSelectionMode();
        }
    }

    public void setCustomPeerSelectionModel(PeerTreeSelectionModel peerTreeSelectionModel) {
        this._bPeerSelection = true;
        this.tree.setSelectionModel((TreeSelectionModel)peerTreeSelectionModel);
        this.setSelectionModel(peerTreeSelectionModel.getListSelectionModel());
    }

    private void setPeerTreeSelectionMode() {
        PeerTreeSelectionModel peerTreeSelectionModel = new PeerTreeSelectionModel((JTree)this.tree);
        this.tree.setSelectionModel((TreeSelectionModel)peerTreeSelectionModel);
        this.setSelectionModel(peerTreeSelectionModel.getListSelectionModel());
    }

    public void setSingleSelectionMode() {
        this.getTree().getSelectionModel().setSelectionMode(1);
        this.setSelectionMode(0);
    }

    public void expandAll(boolean bl) {
        JTree jTree = this.getTree();
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        this.expandAll(jTree, new TreePath(treeNode), bl);
    }

    public ArrayList getLeafNodes() {
        return this.getNodes(true);
    }

    public ArrayList getAllNodes() {
        return this.getNodes(false);
    }

    private ArrayList getNodes(boolean bl) {
        ArrayList arrayList = null;
        TreeModel treeModel = this.tree.getModel();
        if (treeModel != null) {
            Object object = treeModel.getRoot();
            arrayList = new ArrayList();
            this.getChildren(treeModel, object, arrayList, bl);
        }
        return arrayList;
    }

    protected void getChildren(TreeModel treeModel, Object object, ArrayList arrayList, boolean bl) {
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = treeModel.getChild(object, i);
            if (treeModel.isLeaf(object2)) {
                arrayList.add(object2);
                continue;
            }
            if (!bl) {
                arrayList.add(object2);
            }
            this.getChildren(treeModel, object2, arrayList, bl);
        }
    }

    private void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public void setRootInvisible() {
        this.getTree().setRootVisible(false);
        this.getTree().setShowsRootHandles(true);
        this.addMouseListener(new TreeMouseAdapter());
    }

    public void createPopupMenu() {
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this._popup = jPopupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void enableCheckBoxes() {
        assert (!this._bPeerSelection) : "Conflicting selection models.";
        this._checkBoxesEnabled = true;
        this.getTree().setCellRenderer(new CheckboxCellRenderer());
        this.getTree().setCellEditor(new CheckboxCellEditor());
        this.getTree().getSelectionModel().setSelectionMode(1);
        this.getTree().setEditable(true);
        this.setSelectionMode(0);
    }

    public void paint(Graphics graphics) {
        if (this._checkBoxesEnabled || this._showGrid) {
            super.paintUnoptimized(graphics);
        } else {
            super.paint(graphics);
        }
    }

    protected boolean processTreeKey(KeyEvent keyEvent) {
        if (!this._checkBoxesEnabled) {
            return super.processTreeKey(keyEvent);
        }
        TreePath treePath = this.getTree().getSelectionPath();
        if (treePath != null && !this.isEditing()) {
            int n;
            this.getTree().startEditingAtPath(treePath);
            if (!keyEvent.isConsumed() && (keyEvent.getID() == 401 || keyEvent.getID() == 402) && this.isVisible() && (n = keyEvent.getKeyCode()) == 32) {
                CheckboxCellEditor checkboxCellEditor = (CheckboxCellEditor)this.getTree().getCellEditor();
                if (keyEvent.getID() == 401) {
                    checkboxCellEditor.setPressed(true);
                } else if (keyEvent.getID() == 402) {
                    checkboxCellEditor.setReleased();
                    checkboxCellEditor.changeNodeState();
                }
                keyEvent.consume();
                return true;
            }
        }
        return super.processTreeKey(keyEvent);
    }

    private boolean isTheTreeColumn(int n) {
        boolean bl;
        if (n < 0) {
            return false;
        }
        boolean bl2 = bl = this.getColumnModel().getColumn(n).getModelIndex() == this.treeColumnModelIndex;
        assert (bl == (this.getColumnClass(n) == TreeTableModel.class));
        return bl;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        if (!(container instanceof JViewport)) {
            return false;
        }
        return this.getPreferredSize().height < container.getHeight();
    }

    protected void enablePopupItems() {
    }

    class TriStateButtonModel
    extends JToggleButton.ToggleButtonModel {
        private TriStateNode _node;

        TriStateButtonModel(TriStateNode triStateNode) {
            this._node = triStateNode;
        }

        @Override
        public boolean isArmed() {
            return this._node.getNodeState() == TriStateNode.NodeState.PARTIAL;
        }

        @Override
        public boolean isRollover() {
            return this._node.getNodeState() == TriStateNode.NodeState.PARTIAL;
        }

        @Override
        public boolean isSelected() {
            return this._node.getNodeState() != TriStateNode.NodeState.NO;
        }

        public void changeNodeState() {
            switch (this._node.getNodeState()) {
                case NO: {
                    this._node.setNodeState(TriStateNode.NodeState.YES);
                    break;
                }
                case PARTIAL: {
                    this._node.setNodeState(TriStateNode.NodeState.YES);
                    break;
                }
                case YES: {
                    this._node.setNodeState(TriStateNode.NodeState.NO);
                }
            }
            this.fireStateChanged();
        }

        public void setPressedMultiple(TriStateNode[] triStateNodeArray) {
            block5: for (int i = 0; i < triStateNodeArray.length; ++i) {
                switch (triStateNodeArray[i].getNodeState()) {
                    case NO: {
                        triStateNodeArray[i].setNodeState(TriStateNode.NodeState.YES);
                        continue block5;
                    }
                    case PARTIAL: {
                        triStateNodeArray[i].setNodeState(TriStateNode.NodeState.YES);
                        continue block5;
                    }
                    case YES: {
                        triStateNodeArray[i].setNodeState(TriStateNode.NodeState.NO);
                    }
                }
            }
            this.fireStateChanged();
        }

        @Override
        public void setSelected(boolean bl) {
        }
    }

    private class CheckboxCellEditor
    extends CheckboxIconLabel
    implements TreeCellEditor {
        public CheckboxCellEditor() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            this.setFont(UIManager.getFont("Tree.font"));
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            if (object instanceof TriStateNode) {
                TriStateNode triStateNode = (TriStateNode)object;
                this.checkbox.setModel(new TriStateButtonModel(triStateNode));
                this.label.setText(triStateNode.getLabel());
                this.label.setIcon(triStateNode.getIcon());
                this.label.isSelected = true;
            }
            return this;
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkbox.isSelected();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }

        public void changeNodeState() {
            TriStateButtonModel triStateButtonModel = (TriStateButtonModel)this.checkbox.getModel();
            triStateButtonModel.changeNodeState();
        }

        public void setPressed(boolean bl) {
            ButtonModel buttonModel = this.checkbox.getModel();
            if (!buttonModel.isEnabled()) {
                return;
            }
            if (!buttonModel.isArmed()) {
                buttonModel.setArmed(true);
            }
            buttonModel.setPressed(true);
            if (!this.checkbox.hasFocus() && this.checkbox.isRequestFocusEnabled()) {
                this.checkbox.requestFocusInWindow();
            }
        }

        public void setReleased() {
            ButtonModel buttonModel = this.checkbox.getModel();
            buttonModel.setPressed(false);
            buttonModel.setArmed(false);
        }
    }

    private class CheckboxIconLabel
    extends JPanel {
        protected JCheckBox checkbox = new JCheckBox();
        protected SelectableLabel label = new SelectableLabel();

        CheckboxIconLabel() {
            this.setLayout(new BorderLayout(2, 0));
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.label, "Center");
        }

        private class SelectableLabel
        extends JLabel {
            protected boolean isSelected = false;

            private SelectableLabel() {
            }

            @Override
            public void paintComponent(Graphics graphics) {
                if (this.isSelected) {
                    this.setOpaque(false);
                    this.setForeground(UIManager.getColor("Tree.selectionForeground"));
                    graphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                    Insets insets = this.getInsets();
                    Icon icon = this.getIcon();
                    int n = insets.left + (icon != null ? this.getIcon().getIconWidth() : 0) + (icon != null ? this.getIconTextGap() : 0) - 1;
                    graphics.fillRect(n, insets.top, this.getWidth() - n - insets.right + 2, this.getHeight() - insets.top - insets.bottom);
                } else {
                    this.setForeground(UIManager.getColor("Tree.foreground"));
                }
                super.paintComponent(graphics);
            }
        }
    }

    private class CheckboxCellRenderer
    extends CheckboxIconLabel
    implements TreeCellRenderer {
        public CheckboxCellRenderer() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            this.setFont(UIManager.getFont("Tree.font"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object instanceof TriStateNode) {
                TriStateNode triStateNode = (TriStateNode)object;
                this.checkbox.setModel(new TriStateButtonModel(triStateNode));
                this.label.setText(triStateNode.getLabel());
                this.label.setIcon(triStateNode.getIcon());
                this.label.isSelected = bl;
            }
            return this;
        }
    }

    private class TreeMouseAdapter
    extends MouseAdapter {
        private Component _activeComponent = null;

        private TreeMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath;
            boolean bl;
            this.maybeShowPopup(mouseEvent);
            if (!BaseTreeTable.this._checkBoxesEnabled) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = BaseTreeTable.this.getSelectedColumn();
            boolean bl2 = bl = (mouseEvent.getModifiers() & 0xB) == 0;
            if (BaseTreeTable.this.isTheTreeColumn(n) && bl && (treePath = BaseTreeTable.this.getTree().getSelectionPath()) != null && !BaseTreeTable.this.isEditing()) {
                BaseTreeTable.this.getTree().startEditingAtPath(treePath);
                CheckboxCellEditor checkboxCellEditor = (CheckboxCellEditor)BaseTreeTable.this.getTree().getCellEditor();
                Point point = SwingUtilities.convertPoint(BaseTreeTable.this.getTree(), mouseEvent.getPoint(), checkboxCellEditor);
                this._activeComponent = SwingUtilities.getDeepestComponentAt(checkboxCellEditor, point.x, point.y);
                if (this._activeComponent != null && this._activeComponent instanceof JCheckBox) {
                    checkboxCellEditor.setPressed(true);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
            if (!BaseTreeTable.this._checkBoxesEnabled) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = BaseTreeTable.this.getSelectedColumn();
            if (!BaseTreeTable.this.isTheTreeColumn(n)) {
                return;
            }
            TreePath treePath = BaseTreeTable.this.getTree().getSelectionPath();
            if (treePath != null && !BaseTreeTable.this.isEditing()) {
                BaseTreeTable.this.getTree().startEditingAtPath(treePath);
                CheckboxCellEditor checkboxCellEditor = (CheckboxCellEditor)BaseTreeTable.this.getTree().getCellEditor();
                Point point = SwingUtilities.convertPoint(BaseTreeTable.this.getTree(), mouseEvent.getPoint(), checkboxCellEditor);
                Component component = SwingUtilities.getDeepestComponentAt(checkboxCellEditor, point.x, point.y);
                if (component != null && component instanceof JCheckBox) {
                    checkboxCellEditor.setReleased();
                    if (this._activeComponent != null && this._activeComponent.equals(component)) {
                        checkboxCellEditor.changeNodeState();
                    }
                }
            }
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (BaseTreeTable.this._popup == null) {
                return;
            }
            BaseTreeTable.this.enablePopupItems();
            if (mouseEvent.isPopupTrigger()) {
                BaseTreeTable.this._popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

