/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.aeditor.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.aeditor.dialog.DialogState;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public abstract class BaseDialogPanel
extends JPanel {
    private JDialog _parentDlg;
    private TraversableContext _trvContext;

    public abstract void processInput();

    public void getIgnoredSettingsList() {
    }

    public BaseDialogPanel(TraversableContext traversableContext) {
        this._trvContext = traversableContext;
    }

    protected TraversableContext getTraversableContext() {
        return this._trvContext;
    }

    protected DialogState getState() {
        if (this._trvContext == null) {
            return null;
        }
        return (DialogState)this._trvContext.get("dialogBoxState");
    }

    protected final void setLoaded(boolean bl) {
        if (this._trvContext == null) {
            return;
        }
        this._trvContext.put("dialogStateLoaded", (Object)bl);
    }

    public boolean isLoaded() {
        if (this._trvContext == null) {
            return false;
        }
        Boolean bl = (Boolean)this._trvContext.get("dialogStateLoaded");
        return bl;
    }

    public void initializeFromState(DialogState dialogState) {
    }

    public void tabSelected() {
    }

    protected boolean isNewDataInput(boolean bl) throws ValidationException {
        return false;
    }

    protected LoadingStatusPanel createLoadingStatusPanel() {
        return new LoadingStatusPanel();
    }

    public void setParentDlg(JDialog jDialog) {
        this._parentDlg = jDialog;
    }

    public JDialog getParentDlg() {
        return this._parentDlg;
    }

    protected class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        private String _errorLoadingTitle;
        private String _errorLoadingMsg;

        public LoadUI(String string, String string2) {
            this._errorLoadingTitle = string;
            this._errorLoadingMsg = string2;
        }

        public Object construct() {
            DialogState dialogState = BaseDialogPanel.this.getState();
            try {
                dialogState.load();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return dialogState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            block6: {
                try {
                    if (this._success && this._ex == null) {
                        BaseDialogPanel.this.initializeFromState(BaseDialogPanel.this.getState());
                        BaseDialogPanel.this.setLoaded(true);
                        break block6;
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)this._errorLoadingTitle, (String)this._errorLoadingMsg, null);
                        break block6;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), null, (String)this._errorLoadingTitle, (String)this._errorLoadingMsg);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)this._errorLoadingTitle, (String)this._errorLoadingMsg, null);
                }
            }
        }
    }

    protected class LoadingStatusPanel
    extends JPanel {
        JLabel jLblLoading = new JLabel();

        private LoadingStatusPanel() {
            this.jLblLoading.setHorizontalAlignment(0);
            this.jLblLoading.setText(DialogsLrb.get("LOADING_STATUS"));
            this.setLayout(new BorderLayout());
            this.add((Component)this.jLblLoading, "Center");
        }
    }
}

