/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer;

import java.io.IOException;
import java.util.Collections;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.DataMinerViewStatus;
import oracle.dmt.dataminer.EditorContextMenuProvider;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public abstract class DataMinerEditor
extends Editor
implements EditorContextMenuProvider {
    protected DataMinerViewGUI _gui = null;

    public abstract void refresh();

    public void closeEditor() {
        final DataMinerEditor dataMinerEditor = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(dataMinerEditor));
            }
        });
    }

    public View getConsumerView() {
        return this.getViewWithoutDecoration();
    }

    public DataMinerViewStatus getViewStatus() {
        if (this._gui == null) {
            this.getGUI();
        }
        return this._gui.getViewStatus();
    }

    public boolean isLoaded() {
        if (this._gui == null) {
            this.getGUI();
        }
        return this._gui.isLoaded();
    }

    protected void abortOpen(Node node, String string) throws OpenAbortedException {
        this.abortOpen(node, string, null);
    }

    protected void abortOpen(Node node, Exception exception) throws OpenAbortedException {
        this.abortOpen(node, null, exception);
    }

    private void abortOpen(Node node, String string, Exception exception) throws OpenAbortedException {
        try {
            node.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (exception != null) {
            throw new OpenAbortedException(exception.getMessage(), exception.getCause());
        }
        if (string != null) {
            throw new OpenAbortedException(string);
        }
    }
}

