/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.framework.editor.IdeDiagramEditor;
import oracle.dmt.dataminer.EditorContextMenuProvider;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;

public abstract class DataMinerDiagramEditor
extends IdeDiagramEditor
implements EditorContextMenuProvider {
    private BaseTreeNode _projectFolder = null;
    private BaseTreeNode _connectionFolder = null;
    private BaseTreeNode _connectionsFolder = null;
    private WorkflowNode _wfNode = null;
    private BaseTreeNode _selfNode = null;

    public DataMinerDiagramEditor(Diagram diagram) {
        super(diagram);
    }

    public void close() {
        super.close();
        this.attach(false);
    }

    public void open() throws OpenAbortedException {
        super.open();
        this.attach(true);
    }

    private void attach(boolean bl) {
        Context context = this.getContext();
        if (bl) {
            this._selfNode = (BaseTreeNode)context.getNode();
            TNode tNode = this._selfNode.getParent();
            this._wfNode = (WorkflowNode)tNode.getAncestor(WorkflowNode.class);
            this._projectFolder = (BaseTreeNode)tNode.getAncestor(ProjectFolder.class, true);
            this._connectionFolder = (BaseTreeNode)tNode.getAncestor(ConnectionFolder.class, true);
            this._connectionsFolder = (BaseTreeNode)tNode.getAncestor(Connections.class, true);
            this._selfNode.attach((Observer)this);
            if (this._wfNode != null) {
                this._wfNode.attach((Observer)this);
            }
            this._projectFolder.attach((Observer)this);
            this._connectionFolder.attach((Observer)this);
            this._connectionsFolder.attach((Observer)this);
        } else {
            if (this._selfNode != null) {
                this._selfNode.detach((Observer)this);
                this._selfNode = null;
            }
            if (this._wfNode != null) {
                this._wfNode.detach((Observer)this);
                this._wfNode = null;
            }
            if (this._projectFolder != null) {
                this._projectFolder.detach((Observer)this);
                this._projectFolder = null;
            }
            if (this._connectionFolder != null) {
                this._connectionFolder.detach((Observer)this);
                this._connectionFolder = null;
            }
            if (this._connectionsFolder != null) {
                this._connectionsFolder.detach((Observer)this);
                this._connectionsFolder = null;
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        Context context = this.getContext();
        if (updateMessage.getMessageID() == UpdateMessage.CHILD_REMOVED) {
            List list = updateMessage.getRemoveObjects();
            if (list.contains(this._wfNode) || list.contains(this._selfNode) || list.contains(this._connectionFolder) || list.contains(this._projectFolder) || list.contains(this._connectionsFolder)) {
                this.closeEditor();
            }
        } else if (updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSED) {
            if (object == this._connectionFolder) {
                this.closeEditor();
            }
        } else if (updateMessage.getMessageID() == UpdateMessage.CONTENT_MODIFIED) {
            if (object != context.getNode()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataMinerDiagramEditor.this.refresh();
                }
            });
        }
    }

    public abstract void refresh();

    public void closeEditor() {
        DataMinerDiagramEditor dataMinerDiagramEditor = this;
        SwingUtilities.invokeLater(new Runnable((Editor)dataMinerDiagramEditor){
            final /* synthetic */ Editor val$thisEditor;
            {
                this.val$thisEditor = editor;
            }

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(this.val$thisEditor));
            }
        });
    }

    protected void abortOpen(Node node, String string) {
        this.abortOpen(node, string, null);
    }

    protected void abortOpen(Node node, Exception exception) {
        this.abortOpen(node, null, exception);
    }

    protected void abortOpen(Node node) {
        this.abortOpen(node, null, null);
    }

    private void abortOpen(Node node, String string, Exception exception) throws OpenAbortedException {
        try {
            node.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (exception != null) {
            throw new OpenAbortedException(exception.getMessage(), exception.getCause());
        }
        if (string != null) {
            throw new OpenAbortedException(string);
        }
        throw new OpenAbortedException();
    }
}

