/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.lexer;

import oracle.bali.xml.dom.buffer.lexer.XMLLexer;
import oracle.bali.xml.dom.buffer.lexer.XMLTokens;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.jdevimpl.xml.xquery.lexer.XQueryTokens;

public class XQueryXMLLexer
extends AbstractLexer
implements XQueryTokens,
XMLTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private XMLLexer xmlLexer = new XMLLexer();
    private boolean useLastToken;

    public void setPosition(int offset) {
        super.setPosition(offset);
        this.useLastToken = false;
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setTextBuffer(ReadTextBuffer buffer) {
        super.setTextBuffer(buffer);
        this.xmlLexer.setTextBuffer(buffer);
    }

    public int lex(LexerToken lexedToken) {
        int endTextOffset;
        block19: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            int startTextOffset = -1;
            endTextOffset = -1;
            this.lastToken = 0;
            try {
                block9: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            if (startTextOffset == -1) {
                                startTextOffset = this.currentPos - 1;
                            }
                            endTextOffset = this.currentPos;
                            continue block9;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '{': {
                            if (startTextOffset != -1) {
                                this.lastToken = 16;
                                --this.currentPos;
                                this.startOffset = startTextOffset;
                            } else {
                                c = this.textBuffer.getChar(this.currentPos);
                                if (c == '{') {
                                    ++this.currentPos;
                                } else {
                                    this.lastToken = 29;
                                    this.skipXQuery();
                                }
                            }
                            break block19;
                        }
                        case '<': {
                            if (startTextOffset != -1) {
                                this.lastToken = 16;
                                --this.currentPos;
                                this.startOffset = startTextOffset;
                                break block19;
                            }
                            this.xmlLexer.setPosition(this.currentPos - 1);
                            this.lastToken = this.xmlLexer.lex(lexedToken);
                            this.currentPos = lexedToken.getEndOffset() + 1;
                            return this.lastToken;
                        }
                        default: {
                            if (startTextOffset == -1) {
                                startTextOffset = this.currentPos - 1;
                            }
                            endTextOffset = this.currentPos;
                            break;
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block19;
                if (startTextOffset != -1) {
                    this.lastToken = 16;
                    this.startOffset = startTextOffset;
                }
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = endTextOffset == -1 ? this.currentPos : endTextOffset;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    private int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    private void skipXQuery() {
        int count = 1;
        while (true) {
            char c;
            if ((c = this.textBuffer.getChar(this.currentPos++)) == '{') {
                c = this.textBuffer.getChar(this.currentPos);
                if (c == '{') {
                    ++this.currentPos;
                } else {
                    ++count;
                }
            }
            if (c != '}') continue;
            c = this.textBuffer.getChar(this.currentPos);
            if (c == '}') {
                ++this.currentPos;
                continue;
            }
            if (--count == 0) break;
        }
    }
}

