/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.lexer;

import oracle.bali.xml.dom.buffer.lexer.XMLLexer;
import oracle.bali.xml.dom.buffer.lexer.XMLTokens;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.util.KeywordTable;
import oracle.jdevimpl.xml.xquery.lexer.XQueryTokens;

public class XQueryLexer
extends AbstractLexer
implements XQueryTokens,
XMLTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken;
    private XMLLexer xmlLexer = new XMLLexer();
    private static boolean[] NCNAME_CHARS;
    private static KeywordTable keywordTable;

    public void setTextBuffer(ReadTextBuffer buffer) {
        super.setTextBuffer(buffer);
        this.xmlLexer.setTextBuffer(buffer);
    }

    public void setPosition(int offset) {
        super.setPosition(offset);
        this.useLastToken = false;
    }

    public void backup() {
        this.useLastToken = true;
    }

    public int lex(LexerToken lexedToken) {
        block44: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            this.lastToken = 0;
            try {
                block28: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            continue block28;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '(': {
                            if (this.textBuffer.getChar(this.currentPos) == ':') {
                                ++this.currentPos;
                                this.lastToken = 40;
                                this.skipComment();
                                break block28;
                            }
                            this.lastToken = 57;
                            break block28;
                        }
                        case '$': {
                            if (XQueryLexer.isNCNameStart(this.textBuffer.getChar(this.currentPos))) {
                                this.lastToken = 41;
                                this.skipQName();
                                break block28;
                            }
                            break block44;
                        }
                        case '\"': {
                            this.lastToken = 30;
                            this.skipStringLiteralQuote();
                            break block28;
                        }
                        case '\'': {
                            this.lastToken = 30;
                            this.skipStringLiteralApostrophe();
                            break block28;
                        }
                        case ':': {
                            if (this.textBuffer.getChar(this.currentPos) == '=') {
                                ++this.currentPos;
                                this.lastToken = 45;
                                break block28;
                            }
                            break block44;
                        }
                        case ',': {
                            this.lastToken = 46;
                            break block28;
                        }
                        case '=': {
                            this.lastToken = 48;
                            break block28;
                        }
                        case '>': {
                            if (this.textBuffer.getChar(this.currentPos) == '>') {
                                ++this.currentPos;
                                this.lastToken = 49;
                                break block28;
                            }
                            this.lastToken = 52;
                            break block28;
                        }
                        case '@': {
                            this.lastToken = 50;
                            break block28;
                        }
                        case '{': {
                            this.lastToken = 53;
                            break block28;
                        }
                        case '[': {
                            this.lastToken = 54;
                            break block28;
                        }
                        case '-': {
                            this.lastToken = 58;
                            break block28;
                        }
                        case '+': {
                            this.lastToken = 61;
                            break block28;
                        }
                        case '}': {
                            this.lastToken = 63;
                            break block28;
                        }
                        case ']': {
                            this.lastToken = 64;
                            break block28;
                        }
                        case ')': {
                            this.lastToken = 66;
                            break block28;
                        }
                        case '|': {
                            this.lastToken = 68;
                            break block28;
                        }
                        case ';': {
                            this.lastToken = 67;
                            break block28;
                        }
                        case '.': {
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '.') {
                                ++this.currentPos;
                                this.lastToken = 65;
                                break block28;
                            }
                            if (XQueryLexer.isDigit(c)) {
                                this.handleNumericLiteral();
                                break block28;
                            }
                            this.lastToken = 42;
                            break block28;
                        }
                        case '/': {
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '/') {
                                ++this.currentPos;
                                this.lastToken = 47;
                                break block28;
                            }
                            this.lastToken = 60;
                            break block28;
                        }
                        case '<': {
                            c = this.textBuffer.getChar(this.currentPos);
                            if (c == '=') {
                                this.lastToken = 55;
                                ++this.currentPos;
                                break block28;
                            }
                            if (c == '<') {
                                this.lastToken = 49;
                                break block28;
                            }
                            if (Character.isWhitespace(c)) {
                                this.lastToken = 56;
                                break block28;
                            }
                            this.lastToken = 28;
                            this.skipXml();
                            break block28;
                        }
                        default: {
                            if (XQueryLexer.isDigit(c)) {
                                this.handleNumericLiteral();
                                break block28;
                            }
                            if (XQueryLexer.isNCNameStart(c)) {
                                this.lastToken = 43;
                                int hash = KeywordTable.computeInsensitivePartialHash((char)c, (int)0);
                                while (XQueryLexer.isQNamePart(c = this.textBuffer.getChar(this.currentPos))) {
                                    hash = KeywordTable.computeInsensitivePartialHash((char)c, (int)hash);
                                    ++this.currentPos;
                                }
                                int keyword = keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, hash);
                                if (keyword != -1) {
                                    this.lastToken = keyword;
                                    break block28;
                                }
                                break block44;
                            }
                            this.lastToken = 0;
                            continue block28;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken != 0) break block44;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    private int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    private void skipComment() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != ':' || this.textBuffer.getChar(this.currentPos) != ')') {
        }
        ++this.currentPos;
    }

    private void skipQName() {
        this.skipNCName();
        if (this.textBuffer.getChar(this.currentPos) == ':') {
            this.skipNCName();
        }
    }

    private void skipNCName() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos)) < '\u0100' && NCNAME_CHARS[c]) {
            ++this.currentPos;
        }
        if (c > '\u0100') {
            while (XQueryLexer.isNCNamePart(c = this.textBuffer.getChar(this.currentPos))) {
                ++this.currentPos;
            }
        }
    }

    private void skipStringLiteralQuote() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\"': {
                    if (this.textBuffer.getChar(this.currentPos) == '\"') {
                        ++this.currentPos;
                        break;
                    }
                    return;
                }
            }
        }
    }

    private void skipStringLiteralApostrophe() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\'': {
                    if (this.textBuffer.getChar(this.currentPos) == '\'') {
                        ++this.currentPos;
                        break;
                    }
                    return;
                }
            }
        }
    }

    private void handleNumericLiteral() {
        this.lastToken = 31;
        block4: while (true) {
            this.skipDigits();
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '.': {
                    this.lastToken = 32;
                    ++this.currentPos;
                    continue block4;
                }
                case 'E': 
                case 'e': {
                    this.lastToken = 33;
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '+' && c != '-') continue block4;
                    ++this.currentPos;
                    continue block4;
                }
            }
            break;
        }
    }

    private void skipDigits() {
        char c;
        while (XQueryLexer.isDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private void skipXml() {
        char c = this.textBuffer.getChar(this.currentPos);
        if (c == '!') {
            if (this.textBuffer.getChar(this.currentPos + 1) == '-' && this.textBuffer.getChar(this.currentPos + 2) == '-') {
                this.currentPos += 3;
                this.skipXmlComment();
            } else if (this.textBuffer.getChar(this.currentPos + 1) == '[' && this.textBuffer.getChar(this.currentPos + 2) == 'C' && this.textBuffer.getChar(this.currentPos + 3) == 'D' && this.textBuffer.getChar(this.currentPos + 4) == 'A' && this.textBuffer.getChar(this.currentPos + 5) == 'T' && this.textBuffer.getChar(this.currentPos + 6) == 'A' && this.textBuffer.getChar(this.currentPos + 7) == '[') {
                this.currentPos += 8;
                this.skipCDATASection();
            }
        } else if (c == '?') {
            ++this.currentPos;
            this.skipProcessingInstruction();
        } else {
            this.skipXmlElement();
        }
    }

    private void skipXmlComment() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '-' || this.textBuffer.getChar(this.currentPos) != '-' || this.textBuffer.getChar(this.currentPos + 1) != '>') {
        }
        this.currentPos += 2;
    }

    private void skipCDATASection() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != ']' || this.textBuffer.getChar(this.currentPos) != ']' || this.textBuffer.getChar(this.currentPos + 1) != '>') {
        }
        this.currentPos += 2;
    }

    private void skipProcessingInstruction() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '?' || this.textBuffer.getChar(this.currentPos) != '>') {
        }
        ++this.currentPos;
    }

    private void skipXmlElement() {
        String name = this.skipXmlElementName();
        this.skipToXmlEndTag(name);
    }

    private String skipXmlElementName() {
        char quote = '\u0000';
        StringBuffer buffer = new StringBuffer();
        block5: while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '/': 
                case '=': 
                case '>': 
                case '?': {
                    if (quote != '\u0000') continue block5;
                    --this.currentPos;
                    return buffer.toString();
                }
                case '<': {
                    --this.currentPos;
                    return buffer.toString();
                }
                case '\"': 
                case '\'': {
                    if (quote == '\u0000') {
                        quote = c;
                        continue block5;
                    }
                    if (quote != c) continue block5;
                    quote = '\u0000';
                    continue block5;
                }
            }
            buffer.append(c);
        }
    }

    private void skipToXmlEndTag(String name) {
        boolean isEmptyTag = true;
        char quote = '\u0000';
        boolean tagComplete = false;
        block6: while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '/': {
                    if (quote != '\u0000' || !isEmptyTag || (c = this.textBuffer.getChar(this.currentPos)) != '>') continue block6;
                    ++this.currentPos;
                    return;
                }
                case '>': {
                    if (quote != '\u0000') continue block6;
                    if (isEmptyTag) {
                        isEmptyTag = false;
                    }
                    if (!tagComplete) continue block6;
                    return;
                }
                case '<': {
                    if (quote != '\u0000' || (c = this.textBuffer.getChar(this.currentPos)) != '/') continue block6;
                    ++this.currentPos;
                    String endName = this.skipXmlElementName();
                    if (!endName.equals(name)) continue block6;
                    tagComplete = true;
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    if (quote == '\u0000') {
                        quote = c;
                        continue block6;
                    }
                    if (quote != c) continue block6;
                    quote = '\u0000';
                    continue block6;
                }
            }
        }
    }

    private static void initialize() {
        NCNAME_CHARS = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            XQueryLexer.NCNAME_CHARS[i] = XQueryLexer.isNCNamePart((char)i);
        }
        keywordTable = new KeywordTable(83);
        keywordTable.addKeyword("ancestor-or-self", 70);
        keywordTable.addKeyword("ancestor", 71);
        keywordTable.addKeyword("and", 72);
        keywordTable.addKeyword("as", 73);
        keywordTable.addKeyword("ascending", 74);
        keywordTable.addKeyword("at", 75);
        keywordTable.addKeyword("attribute", 76);
        keywordTable.addKeyword("base-uri", 77);
        keywordTable.addKeyword("by", 78);
        keywordTable.addKeyword("case", 79);
        keywordTable.addKeyword("cast", 80);
        keywordTable.addKeyword("castable", 81);
        keywordTable.addKeyword("child", 82);
        keywordTable.addKeyword("collation", 83);
        keywordTable.addKeyword("comment", 84);
        keywordTable.addKeyword("declare", 85);
        keywordTable.addKeyword("default", 86);
        keywordTable.addKeyword("descendant-or-self", 87);
        keywordTable.addKeyword("descendant", 88);
        keywordTable.addKeyword("descending", 89);
        keywordTable.addKeyword("div", 90);
        keywordTable.addKeyword("document-node", 91);
        keywordTable.addKeyword("document", 92);
        keywordTable.addKeyword("element", 93);
        keywordTable.addKeyword("else", 94);
        keywordTable.addKeyword("empty", 95);
        keywordTable.addKeyword("encoding", 96);
        keywordTable.addKeyword("eq", 97);
        keywordTable.addKeyword("every", 98);
        keywordTable.addKeyword("except", 99);
        keywordTable.addKeyword("external", 100);
        keywordTable.addKeyword("following-sibling", 101);
        keywordTable.addKeyword("following", 102);
        keywordTable.addKeyword("for", 103);
        keywordTable.addKeyword("function", 104);
        keywordTable.addKeyword("ge", 105);
        keywordTable.addKeyword("greatest", 106);
        keywordTable.addKeyword("gt", 107);
        keywordTable.addKeyword("idiv", 108);
        keywordTable.addKeyword("if", 109);
        keywordTable.addKeyword("import", 110);
        keywordTable.addKeyword("in", 111);
        keywordTable.addKeyword("instance", 112);
        keywordTable.addKeyword("intersect", 113);
        keywordTable.addKeyword("item", 114);
        keywordTable.addKeyword("lax", 115);
        keywordTable.addKeyword("le", 116);
        keywordTable.addKeyword("least", 117);
        keywordTable.addKeyword("let", 118);
        keywordTable.addKeyword("lt", 119);
        keywordTable.addKeyword("mod", 120);
        keywordTable.addKeyword("module", 121);
        keywordTable.addKeyword("namespace", 122);
        keywordTable.addKeyword("ne", 123);
        keywordTable.addKeyword("node", 124);
        keywordTable.addKeyword("of", 125);
        keywordTable.addKeyword("order", 126);
        keywordTable.addKeyword("ordered", 127);
        keywordTable.addKeyword("ordering", 128);
        keywordTable.addKeyword("parent", 129);
        keywordTable.addKeyword("preceding-sibling", 130);
        keywordTable.addKeyword("preceding", 131);
        keywordTable.addKeyword("processing-instruction", 132);
        keywordTable.addKeyword("return", 133);
        keywordTable.addKeyword("satisfies", 134);
        keywordTable.addKeyword("schema-attribute", 135);
        keywordTable.addKeyword("schema-element", 136);
        keywordTable.addKeyword("self", 137);
        keywordTable.addKeyword("some", 138);
        keywordTable.addKeyword("stable", 139);
        keywordTable.addKeyword("strict", 140);
        keywordTable.addKeyword("strip", 141);
        keywordTable.addKeyword("text", 142);
        keywordTable.addKeyword("then", 143);
        keywordTable.addKeyword("to", 144);
        keywordTable.addKeyword("typeswitch", 145);
        keywordTable.addKeyword("union", 146);
        keywordTable.addKeyword("unordered", 147);
        keywordTable.addKeyword("validate", 148);
        keywordTable.addKeyword("version", 149);
        keywordTable.addKeyword("where", 150);
        keywordTable.addKeyword("xmlspace", 151);
        keywordTable.addKeyword("xquery", 152);
    }

    private static boolean isNCNameStart(char ch) {
        return Character.isLetter(ch) || ch == '_';
    }

    private static boolean isNCNamePart(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_';
    }

    private static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private static boolean isQNamePart(char ch) {
        return ch == ':' || XQueryLexer.isNCNamePart(ch);
    }

    static {
        XQueryLexer.initialize();
    }
}

