/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.ide.Context;
import oracle.ide.component.NewFilePanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ComponentArb;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.resource.WizardsArb;

public class NewProjectPanel
extends NewFilePanel {
    private Workspace _wksp;
    private static final String HELP_TOPIC = "f1_idednewproject_html";

    public NewProjectPanel() {
        this.setFileExtension(".jpr");
        this.setFileType(WizardsArb.getString(5));
        this.setFilePrompt(ComponentArb.getString((int)23));
        this.setShowExtension(false);
    }

    protected final DialogHeader createDialogHeader() {
        DialogHeader h = new DialogHeader();
        h.setHeaderDescription(WizardsArb.getString(486));
        h.setHeaderImage(OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/project.png")));
        return h;
    }

    public static URL getProjectURL(Context ctx) {
        NewProjectPanel panel = new NewProjectPanel();
        panel.setContext(ctx);
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)panel), HELP_TOPIC);
        return panel.runDialog(WizardsArb.getString(0));
    }

    public URL getProjectURL(Runnable runnable) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), HELP_TOPIC);
        return this.runDialog(WizardsArb.getString(0), runnable);
    }

    public void setContext(Context ctx) {
        this._wksp = ctx.getWorkspace();
        DefaultNameGenerator nameGen = new DefaultNameGenerator(Project.getDefaultName(), null, 1);
        URL wkspURL = this._wksp.getURL();
        URL dirURL = URLFileSystem.getParent((URL)wkspURL);
        URL projDir = URLFactory.newUniqueURL((URL)dirURL, (NameGenerator)nameGen);
        if (!URLFileSystem.isDirectoryPath((URL)projDir)) {
            projDir = URLFactory.newDirURL((URL)URLFileSystem.getParent((URL)projDir), (String)URLFileSystem.getFileName((URL)projDir));
        }
        this.setDirectoryURL(projDir);
        String name = URLFileSystem.getFileName((URL)projDir);
        this.setFileName(name + ".jpr");
    }
}

