/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.config.Preferences;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.CodingStyleProfiles;

public class ProfileRepository {
    private static final String DEFAULT_PROFILES_FILE = "default_profiles.xml";
    private static final String DEFAULT_PROFILES_NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"default-coding-style-profiles");
    private static final String DEFAULT_PROFILES_ROOT_TAG = "profiles";
    private static final String DEFAULT_PROFILE_NAME = "Java Code Conventions";
    private static ProfileRepository instance;
    private static Object lock;
    private CodingStyleProfiles profiles;
    private Map defaultProfileMap;

    private ProfileRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfileRepository getProfileRepository() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new ProfileRepository();
                }
            }
        }
        return instance;
    }

    public CodingStyleProfile getProfile(String name) {
        this.loadProfiles();
        return this.profiles.getProfile(name);
    }

    public boolean contains(String name) {
        this.loadProfiles();
        return this.profiles.containsKey(name);
    }

    public List getProfiles() {
        this.loadProfiles();
        return Collections.unmodifiableList(new ArrayList(this.profiles.getProfileMap().values()));
    }

    public void addProfile(CodingStyleProfile profile) {
        String name = profile.getName();
        if (this.profiles.containsKey(name)) {
            CodingStyleProfile existing = this.profiles.getProfile(name);
            profile.copyTo((Object)existing);
        } else {
            this.profiles.putProfile(name, profile);
        }
    }

    public void removeProfile(CodingStyleProfile profile) {
        this.profiles.removeProfile(profile.getName());
    }

    public CodingStyleProfile getDefaultProfile(String name) {
        this.loadProfiles();
        return (CodingStyleProfile)((Object)this.defaultProfileMap.get(name));
    }

    public CodingStyleProfile getDefaultProfile() {
        return this.getDefaultProfile(DEFAULT_PROFILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProfiles() {
        if (this.profiles == null) {
            Object object = lock;
            synchronized (object) {
                if (this.profiles == null) {
                    CodingStyleProfiles defaultProfiles = this.loadDefaultProfiles();
                    this.defaultProfileMap = defaultProfiles.getProfileMap();
                    Preferences prefs = Preferences.getPreferences();
                    boolean isInitialized = prefs.getProperties().containsKey("CodingStyleProfiles");
                    this.profiles = CodingStyleProfiles.getInstance((PropertyStorage)prefs);
                    DTCache dtCache = Ide.getDTCache();
                    CodingStyleProfiles oldProfiles = (CodingStyleProfiles)((Object)dtCache.getData("CodingStyleProfiles"));
                    if (oldProfiles != null) {
                        dtCache.remove("CodingStyleProfiles");
                        oldProfiles.copyTo((Object)this.profiles);
                    } else if (!isInitialized) {
                        defaultProfiles.copyTo((Object)this.profiles);
                    }
                }
            }
        }
    }

    private CodingStyleProfiles loadDefaultProfiles() {
        CodingStyleProfiles profiles = new CodingStyleProfiles();
        try {
            InputStream stream = ProfileRepository.class.getResourceAsStream(DEFAULT_PROFILES_FILE);
            Object2Dom o2d = Object2Dom.newInstance();
            CodingStyleProfiles defaultProfiles = (CodingStyleProfiles)((Object)o2d.toObject(stream, CodingStyleProfiles.class));
            defaultProfiles.copyTo((Object)profiles);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return profiles;
    }

    public static void saveDefaultProfiles(CodingStyleProfiles profiles) {
        try {
            File dest = new File(DEFAULT_PROFILES_FILE);
            URL url = URLFactory.newFileURL((File)dest);
            Object2Dom o2d = Object2Dom.newInstance();
            o2d.setNamespaceURI(DEFAULT_PROFILES_NAMESPACE_URI);
            o2d.toDocument((Object)profiles, DEFAULT_PROFILES_ROOT_TAG, url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        lock = new Object();
    }
}

