/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.EditorProperties;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.style.CodingStyleOptionsListener;
import oracle.jdevimpl.style.preferences.CodingStylePreferences;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.profile.ProfileRepository;

public class CodingStyleManagerImpl
extends CodingStyleManager {
    private CodingStyleProfile profile;
    private CodingStyleProfile localProfile = new CodingStyleProfile();
    private CodingStyleOptionsListener profileListener = new ProfileListener();

    public CodingStyleManagerImpl() {
        CodingStylePreferences preferences = this.getCodingStylePreferences();
        preferences.addPropertyChangeListener(new PreferencesListener());
        this.updateProfile();
    }

    public CodingStyleOptions getCodingStyleOptions() {
        return this.localProfile;
    }

    public CodingStyleOptions getCodingStyleOptions(Context context) {
        return this.getCodingStyleOptions();
    }

    private void updateProfile() {
        if (this.profile != null) {
            this.profile.removeCodingStyleOptionsListener(this.profileListener);
        }
        CodingStylePreferences preferences = this.getCodingStylePreferences();
        String name = preferences.getActiveProfile();
        ProfileRepository repository = ProfileRepository.getProfileRepository();
        if (name != null) {
            this.profile = repository.getProfile(name);
        }
        if (this.profile == null) {
            this.profile = repository.getDefaultProfile();
        }
        if (this.profile != null) {
            this.profile.copyTo((Object)this.localProfile);
            this.profile.addCodingStyleOptionsListener(this.profileListener);
        }
        EditorProperties properties = EditorProperties.getProperties();
        properties.putIntegerProperty("indent-size", this.profile.getIndentSize());
        properties.putBooleanProperty("use-tabs", this.profile.getIndentReplaceWithTabs());
        properties.putIntegerProperty("tab-size", this.profile.getTabSize());
        properties.putBooleanProperty("java-open-brace-same-line", this.profile.getClassBracePosition() == 0);
    }

    private CodingStylePreferences getCodingStylePreferences() {
        return CodingStylePreferences.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private class ProfileListener
    implements CodingStyleOptionsListener {
        private ProfileListener() {
        }

        public void optionsChanged(CodingStyleOptions options) {
            CodingStyleManagerImpl.this.updateProfile();
        }
    }

    private class PreferencesListener
    implements PropertyChangeListener {
        private PreferencesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CodingStyleManagerImpl.this.updateProfile();
        }
    }
}

