/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.TabbedPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.RichHintLabel;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.model.NewWorkingSetPanel;
import oracle.jdevimpl.model.PatternFiltersPanel;
import oracle.jdevimpl.model.PatternFiltersTreePanel;
import oracle.jdevimpl.model.WorkingSetsEditor;
import oracle.jdevimpl.navigator.Res;
import oracle.jdevimpl.navigator.WorkingSetProjectsPanel;

final class WorkingSetsPanel
extends DefaultTraversablePanel
implements ItemListener,
ActionListener,
TreeSelectionListener {
    private final JComboBox _comboBox;
    private final JButton _btnSaveAs;
    private final JButton _btnDelete;
    private Workspace _workspace;
    private WorkingSets _workingSetsSnapshot;
    private TraversableContext _tc;
    private final WorkingSetProjectsPanel _projectListMasterPanel;
    private final TabbedPanel _patternFiltersTabbedPanel;
    private static final String HELP_TOPIC_ID = "f1_idedworkingsets_html";

    public WorkingSetsPanel() {
        this.setLayout(new GridBagLayout());
        RichHintLabel prompt = new RichHintLabel();
        prompt.setHtmlText(Res.getString(26));
        prompt.registerAction("help", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpSystem.getHelpSystem().goTo("f1_idedworkingsets_subsets");
            }
        });
        this.add((Component)prompt, this.gbc(0, 0, 4, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 10, 0)));
        JLabel comboLabel = new JLabel();
        this._comboBox = new JComboBox();
        this._comboBox.setModel(new NonNullableComboBoxModel());
        ResourceUtils.resLabel((JLabel)comboLabel, (Component)this._comboBox, (String)Res.getString(27));
        this._btnSaveAs = new JButton();
        ResourceUtils.resButton((AbstractButton)this._btnSaveAs, (String)Res.getString(28));
        this._btnSaveAs.addActionListener(this);
        this._btnDelete = new JButton();
        ResourceUtils.resButton((AbstractButton)this._btnDelete, (String)Res.getString(29));
        this._btnDelete.addActionListener(this);
        this.add(comboLabel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5)));
        this.add(this._comboBox, this.gbc(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 20, 0));
        this.add(this._btnSaveAs, this.gbc(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5)));
        this.add(this._btnDelete, this.gbc(3, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0)));
        this._projectListMasterPanel = new WorkingSetProjectsPanel();
        this._projectListMasterPanel.addTreeSelectionListener(this);
        this._patternFiltersTabbedPanel = new TabbedPanel(new Navigable[]{new Navigable(ModelArb.getString((int)57), PatternFiltersTreePanel.class), new Navigable(ModelArb.getString((int)58), PatternFiltersPanel.class)});
        JSplitPane splitPane = new JSplitPane(1, (Component)((Object)this._projectListMasterPanel), (Component)this._patternFiltersTabbedPanel);
        splitPane.setBorder(null);
        splitPane.setDividerSize(5);
        splitPane.setDividerLocation(250);
        this.add(splitPane, this.gbc(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0)));
    }

    public void onEntry(TraversableContext tc) {
        this._workspace = (Workspace)tc.find("Application");
        WorkingSets workingSets = WorkingSets.getInstance((Workspace)this._workspace);
        this._workingSetsSnapshot = (WorkingSets)workingSets.copyTo(null);
        this._comboBox.removeAllItems();
        WS activeItem = null;
        String currentWorkingSetName = workingSets.getCurrentWorkingSetName();
        if (WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(currentWorkingSetName)) {
            currentWorkingSetName = null;
        }
        List workingSetNames = workingSets.getWorkingSetNames();
        for (Object nextName : workingSetNames) {
            if (WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(nextName)) continue;
            String name = nextName.toString();
            if (currentWorkingSetName == null) {
                currentWorkingSetName = name;
                workingSets.setCurrentWorkingSetName(name);
            }
            WS wsItem = new WS(name);
            this._comboBox.addItem(wsItem);
            if (activeItem != null || !currentWorkingSetName.equals(name)) continue;
            activeItem = wsItem;
        }
        this._comboBox.setSelectedItem(activeItem);
        this._comboBox.addItemListener(this);
        this._tc = tc;
        this.enterSubPanels();
        this.updateEnabledStates();
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.exitSubPanels(tc);
        this._comboBox.removeItemListener(this);
    }

    public String getHelpID() {
        return HELP_TOPIC_ID;
    }

    private void enterSubPanels() {
        this._projectListMasterPanel.onEntry(this._tc);
        this._patternFiltersTabbedPanel.onEntry(this._tc);
    }

    private void exitSubPanels(TraversableContext tc) throws TraversalException {
        this._projectListMasterPanel.onExit(tc);
        this._patternFiltersTabbedPanel.onExit(tc);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int stateChange = e.getStateChange();
        if (stateChange == 2) {
            try {
                this.exitSubPanels(this._tc);
            }
            catch (TraversalException ex) {
                ex.printStackTrace();
            }
        } else if (stateChange == 1) {
            String newWorkingSetName = ((WS)this._comboBox.getSelectedItem()).getName();
            WorkingSets workingSets = WorkingSets.getInstance((Workspace)this._workspace);
            workingSets.setCurrentWorkingSetName(newWorkingSetName);
            this.enterSubPanels();
            this.updateEnabledStates();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._btnSaveAs) {
            NewWorkingSetPanel details = new NewWorkingSetPanel();
            details.setHelpID("f1_idedsaveas_html");
            Namespace data = new Namespace();
            data.put("existing.names", (Object)WorkingSets.getInstance((Workspace)this._workspace).getWorkingSetNames());
            TDialogLauncher launcher = details.getTDialogLauncher((Component)((Object)this), data);
            JEWTDialog dlg = launcher.initDialog();
            boolean response = dlg.runDialog();
            if (response) {
                try {
                    this.exitSubPanels(this._tc);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                WS activeWS = (WS)this._comboBox.getSelectedItem();
                WorkingSets appWorkingSets = WorkingSets.getInstance((Workspace)this._workspace);
                String nameOfActiveWorkingSet = activeWS.getName();
                WorkingSet srcAppWorkingSet = appWorkingSets.getWorkingSet(nameOfActiveWorkingSet);
                String name = data.find("name").toString();
                if (appWorkingSets.getWorkingSetNames().contains(name)) {
                    if (!name.equals(nameOfActiveWorkingSet)) {
                        this.copyWorkingSet(appWorkingSets, nameOfActiveWorkingSet, name);
                    }
                    for (int i = 0; i < this._comboBox.getItemCount(); ++i) {
                        WS wsItem = (WS)this._comboBox.getItemAt(i);
                        if (!name.equals(wsItem.getName())) continue;
                        this._comboBox.setSelectedIndex(i);
                        break;
                    }
                } else {
                    this.copyWorkingSet(appWorkingSets, nameOfActiveWorkingSet, name);
                    WS newItem = new WS(name);
                    this._comboBox.addItem(newItem);
                    this._comboBox.setSelectedItem(newItem);
                }
                this.refreshFromState(srcAppWorkingSet);
                activeWS.setModified(false);
                this._comboBox.repaint();
            }
        } else if (source == this._btnDelete) {
            WorkingSets workingSets = WorkingSets.getInstance((Workspace)this._workspace);
            String name = workingSets.getCurrentWorkingSetName();
            int i = this._comboBox.getSelectedIndex();
            this._comboBox.removeItemAt(i);
            int n = this._comboBox.getItemCount() - 1;
            if (n < 0) {
                this._comboBox.setSelectedItem(null);
            } else {
                this._comboBox.setSelectedIndex(i <= n ? i : n);
            }
            workingSets.deleteWorkingSet(name);
        }
        this.updateEnabledStates();
    }

    private void copyWorkingSet(WorkingSets appLevelWorkingSets, String originalName, String newName) {
        WorkingSet targetAppWorkingSet = appLevelWorkingSets.getWorkingSet(newName);
        WorkingSet srcAppWorkingSet = appLevelWorkingSets.getWorkingSet(originalName);
        srcAppWorkingSet.copyTo((Object)targetAppWorkingSet);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        JMutableTreeNode treeNode;
        JTreeCellData cell;
        Object userObj;
        TreePath treePath = e.getOldLeadSelectionPath();
        if (treePath != null && (userObj = (cell = (JTreeCellData)(treeNode = (JMutableTreeNode)treePath.getLastPathComponent()).getUserObject()).getUserObject()) instanceof Project) {
            this.exitTreePanel((Project)userObj);
        }
        if ((treePath = e.getNewLeadSelectionPath()) != null && (userObj = (cell = (JTreeCellData)(treeNode = (JMutableTreeNode)treePath.getLastPathComponent()).getUserObject()).getUserObject()) instanceof Project) {
            this.enterTreePanel((Project)userObj);
        } else {
            this.enterTreePanel(null);
        }
    }

    private void enterTreePanel(Project project) {
        this.enterExitTreePanelImpl(project, true);
    }

    private void exitTreePanel(Project project) {
        this.enterExitTreePanelImpl(project, false);
    }

    private void enterExitTreePanelImpl(Project project, boolean enter) {
        this._tc.put("Project", (Object)project);
        if (project != null) {
            WorkingSet workingSet = WorkingSets.getInstance((Workspace)this._workspace).getCurrentWorkingSet();
            WorkingSetsEditor.setPatternFilters((Namespace)this._tc, workingSet.getOrCreatePatternFilters(project));
        } else {
            WorkingSetsEditor.setPatternFilters((Namespace)this._tc, null);
        }
        if (enter) {
            this._patternFiltersTabbedPanel.onEntry(this._tc);
        } else {
            try {
                this._patternFiltersTabbedPanel.onExit(this._tc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateEnabledStates() {
        Object item = this._comboBox.getSelectedItem();
        boolean enable = item != null;
        this._btnDelete.setEnabled(enable && this._comboBox.getItemCount() > 1);
        if (item == null) {
            // empty if block
        }
    }

    private void refreshFromState(WorkingSet ws) {
        this._workingSetsSnapshot.getWorkingSet(ws.getName()).copyTo((Object)ws);
    }

    private static class WS {
        String _name;
        boolean _modified;
        final String MODIFIED = " " + ModelArb.getString((int)63);

        WS(String name) {
            this._name = name;
        }

        void setModified(boolean modified) {
            this._modified = modified;
        }

        String getName() {
            return this._name;
        }

        public String toString() {
            if (this._modified) {
                return this._name + this.MODIFIED;
            }
            return this._name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WS)) {
                return false;
            }
            WS other = (WS)obj;
            return this._name.equals(other._name) && this._modified == other._modified;
        }
    }
}

