/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.navigator.ContentSetSupport;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.navigator.LibraryFolder;
import oracle.jdevimpl.navigator.Res;

final class LibrarySupport
extends NavigatorInit
implements Controller {
    private static final String TOGGLE_LIBS_CMD = "SystemNavigator.toggleLibs";
    static final int TOGGLE_LIBS_CMD_ID = Ide.findOrCreateCmdID((String)"SystemNavigator.toggleLibs");
    private static IdeAction _toggleLibsAction;
    static final String SHOW_LIBS = "show-libs";
    private static final boolean DEFAULT_SHOW_LIBS = false;
    private boolean _showLibs = false;
    private Controller _controller;
    private final JarInfoCache jarInfoCache = new JarInfoCache();

    static void init(ProjectNavigatorManager nav) {
        if (_toggleLibsAction == null) {
            _toggleLibsAction = LibrarySupport.newToggleLibsAction();
        }
        nav.addNavigatorInit(new NavigatorInitFactory(LibrarySupport.class));
    }

    LibrarySupport(NavigatorWindow navWin, Context context) {
        super(navWin, context);
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    if (action.getCommandId() == 51) {
                        LibrarySupport.this.updateDependencies(context.getProject());
                    }
                    return false;
                }

                public boolean update(IdeAction action, Context context) {
                    Element[] elems;
                    int cmdId = action.getCommandId();
                    if (cmdId == 20 && (elems = context.getSelection()) != null && elems.length > 0) {
                        TNode tnode;
                        Element libFolder;
                        Element elem = elems[0];
                        if (elem instanceof LibraryFolder) {
                            action.setEnabled(false);
                            return true;
                        }
                        TNode[] tnodes = ExplorerContext.getTNodes((Context)context);
                        if (tnodes != null && tnodes.length > 0 && (libFolder = (tnode = tnodes[0]).getAncestor(LibraryFolder.class)) != null) {
                            action.setEnabled(false);
                            return true;
                        }
                    }
                    return false;
                }
            };
        }
        return this._controller;
    }

    public void loadPreferences(PropertyAccess prefs) {
        this._showLibs = LibrarySupport.str2Boolean((PropertyAccess)prefs, (String)SHOW_LIBS, (boolean)false);
    }

    public void savePreferences(PropertyAccess prefs) {
        LibrarySupport.boolean2Str((PropertyAccess)prefs, (String)SHOW_LIBS, (boolean)this._showLibs);
    }

    public void copyPreferencesTo(Context context) {
        context.setBoolean(SHOW_LIBS, this._showLibs);
    }

    public void initToolbar(Toolbar toolbar) {
        MenuToolButton menuToolButton = ContentSetSupport.findDisplayOptionsMenu((Toolbar)toolbar);
        if (toolbar != null) {
            IdeAction localAction = _toggleLibsAction.newLocalAction((View)this.getNavigatorWindow());
            localAction.addController((Controller)this);
            menuToolButton.addPopupItem((ToggleAction)localAction);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOGGLE_LIBS_CMD_ID) {
            this._showLibs = !this._showLibs;
            action.setState(this._showLibs);
            ProjectNavigatorManager.refreshAllProjectsInNavigator((Context)context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOGGLE_LIBS_CMD_ID) {
            action.setEnabled(true);
            action.setState(this._showLibs);
            return true;
        }
        return false;
    }

    private static IdeAction newToggleLibsAction() {
        IdeAction action = IdeAction.get((int)TOGGLE_LIBS_CMD_ID, (String)Res.getString(4), (Integer)Res.getInteger(5));
        action.setEnabled(true);
        action.putValue("Check", (Object)Boolean.TRUE);
        return action;
    }

    private void updateDependencies(Project project) {
        JLibrary[] allProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project).getLibraries();
        CopyOnWriteArraySet<URL> modifiedJars = new CopyOnWriteArraySet<URL>();
        for (JLibrary library : allProjectLibraries) {
            URL[] allJarUrls;
            Date libraryLastModifiedDate = this.jarInfoCache.getLastModified(library);
            long newLastModified = libraryLastModifiedDate.getTime();
            for (URL jarUrl : allJarUrls = library.getClassPath().getEntries()) {
                try {
                    JarIndex index = JarUtil.getJarIndex((URL)jarUrl);
                    long jarTimestamp = index.getTimestamp();
                    if (!libraryLastModifiedDate.before(new Date(jarTimestamp))) continue;
                    if (!modifiedJars.contains(jarUrl)) {
                        modifiedJars.add(jarUrl);
                    }
                    newLastModified = Math.max(newLastModified, jarTimestamp);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.jarInfoCache.setLastModified(library, new Date(newLastModified));
        }
        if (modifiedJars.size() > 0) {
            JLibraryManager.getInstance().projectLibrariesChanged(project, modifiedJars, new HashSet(), new HashSet());
        }
    }

    private class JarInfoCache {
        final HashMap<JLibrary, Date> jlibrary2lastModified = new HashMap();

        public void setLastModified(JLibrary library, Date lastModifiedDate) {
            JLibrary libraryToBeRemoved = null;
            for (JLibrary jlibrary : this.jlibrary2lastModified.keySet()) {
                if (!jlibrary.equivalent((Library)library)) continue;
                libraryToBeRemoved = jlibrary;
                break;
            }
            if (libraryToBeRemoved != null) {
                this.jlibrary2lastModified.remove(libraryToBeRemoved);
            }
            this.jlibrary2lastModified.put(library, lastModifiedDate);
        }

        public Date getLastModified(JLibrary library) {
            Boolean contained = false;
            Iterator<JLibrary> librariesIterator = this.jlibrary2lastModified.keySet().iterator();
            while (!contained.booleanValue() && librariesIterator.hasNext()) {
                JLibrary jlibrary = librariesIterator.next();
                if (!jlibrary.equivalent((Library)library)) continue;
                return this.jlibrary2lastModified.get(jlibrary);
            }
            return new Date(0L);
        }
    }
}

