/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.navigator.ContentSetSupport;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.resource.NavigatorArb;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;

final class CategorySupport
extends NavigatorInit
implements Controller {
    private static final String TOGGLE_CATEGORIES_CMD = "CategorySupport.toggleCategories";
    private static final int TOGGLE_CATEGORIES_CMD_ID = Ide.findOrCreateCmdID((String)"CategorySupport.toggleCategories");
    private static IdeAction _toggleCategoriesAction;
    private boolean _showCategories = true;
    static final String SHOW_CATEGORIES = "show-categories";
    private static final boolean DEFAULT_SHOW_CATEGORIES = true;
    private Controller _controller;

    static void init(ProjectNavigatorManager nav) {
        CategorySupport.maybeInitToggleCategoriesAction();
        nav.addNavigatorInit(new NavigatorInitFactory(CategorySupport.class));
    }

    CategorySupport(NavigatorWindow navWin, Context context) {
        super(navWin, context);
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    return false;
                }

                public boolean update(IdeAction action, Context context) {
                    return false;
                }
            };
        }
        return this._controller;
    }

    public void loadPreferences(PropertyAccess prefs) {
        this._showCategories = CategorySupport.str2Boolean((PropertyAccess)prefs, (String)SHOW_CATEGORIES, (boolean)true);
    }

    public void savePreferences(PropertyAccess prefs) {
        CategorySupport.boolean2Str((PropertyAccess)prefs, (String)SHOW_CATEGORIES, (boolean)this._showCategories);
    }

    public void copyPreferencesTo(Context context) {
        context.setBoolean("show-content-set-names", this._showCategories);
    }

    public void initToolbar(Toolbar toolbar) {
        MenuToolButton menuToolButton = ContentSetSupport.findDisplayOptionsMenu((Toolbar)toolbar);
        if (toolbar != null) {
            IdeAction localAction = _toggleCategoriesAction.newLocalAction((View)this.getNavigatorWindow());
            localAction.addController((Controller)this);
            menuToolButton.addPopupItem((ToggleAction)localAction);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOGGLE_CATEGORIES_CMD_ID) {
            this._showCategories = !this._showCategories;
            action.setState(this._showCategories);
            ProjectNavigatorManager.refreshAllProjectsInNavigator((Context)context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == TOGGLE_CATEGORIES_CMD_ID) {
            action.setEnabled(true);
            action.setState(this._showCategories);
            return true;
        }
        return false;
    }

    private static void maybeInitToggleCategoriesAction() {
        if (_toggleCategoriesAction == null) {
            IdeAction action = IdeAction.get((int)TOGGLE_CATEGORIES_CMD_ID, (String)NavigatorArb.getString((int)17), (Integer)NavigatorArb.getInteger((int)18));
            action.setEnabled(true);
            action.putValue("Check", (Object)Boolean.TRUE);
            _toggleCategoriesAction = action;
        }
    }
}

