/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.explorer.ChildFilterHelper;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.jdevimpl.navigator.FileNameComparator;

final class ApplicationFilter
extends ChildFilterHelper {
    private static final FileNameComparator _comparator = new FileNameComparator();

    ApplicationFilter() {
    }

    public void initChildren(Context context, List children) {
        WorkingSet currentWorkingSet;
        Workspace workspace = context.getWorkspace();
        if (workspace != null && (currentWorkingSet = WorkingSets.getInstance((Workspace)workspace).getCurrentWorkingSet()) != null) {
            ArrayList<Project> projects = new ArrayList<Project>();
            Iterator iter = workspace.getChildren();
            while (iter.hasNext()) {
                Project project;
                Object next = iter.next();
                if (!(next instanceof Project) || !currentWorkingSet.isIncluded(project = (Project)next)) continue;
                projects.add(project);
            }
            Collections.sort(projects, _comparator);
            children.addAll(projects);
        }
    }

    public boolean handleChildrenAdded(Context context, List children, TNode parent, final TreeExplorer tree) {
        TNode child;
        Enumeration echildren = parent.children();
        while (echildren.hasMoreElements()) {
            child = (TNode)echildren.nextElement();
            Element element = child.getData();
            if (!children.contains(element)) continue;
            children.remove(element);
        }
        child = null;
        for (Element element : children) {
            child = tree.addChild(element, parent, tree.getTreeModel());
        }
        if (child != null) {
            final TNode selected = child;
            this.activateNavigator(tree);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tree.setSelected(selected);
                    tree.nodeChanged(selected);
                }
            });
        }
        return true;
    }

    private void activateNavigator(TreeExplorer tree) {
        JTree jtree = tree.getJTree();
        if (jtree != null) {
            jtree.requestFocus();
        }
    }
}

