/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.audit.transform;

import java.util.Arrays;
import java.util.List;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.jdeveloper.audit.java.JavaTransformContext;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdevimpl.javadoc.audit.DocAnalyzerUtils;
import oracle.jdevimpl.javadoc.audit.transform.AbstractDocFix;

public class SortTagsFix
extends AbstractDocFix {
    public static final String PROPERTY_SORT_ORDER = "sort-order";

    public SortTagsFix(Localizer localizer) {
        super("sort-tags-fix", localizer);
    }

    public boolean isApplicable(JavaTransformContext context, SourceElement construct) {
        if (this.getSourceMember(construct) != null) {
            SourceDocComment cmt = this.getDocComment(construct);
            List tagList = cmt.getBlockTags();
            Object[] tags = new SourceDocTag[tagList.size()];
            tagList.toArray(tags);
            TagDescriptor[] tds = (TagDescriptor[])context.getParameter(PROPERTY_SORT_ORDER);
            Object[] sortedTags = DocAnalyzerUtils.sortTags((SourceDocTag[])tags, tds);
            return !Arrays.equals(tags, sortedTags);
        }
        return false;
    }

    public void apply(JavaTransformContext context, SourceElement construct) {
        SourceDocComment comment = this.getDocComment(construct);
        if (comment != null) {
            List tagList = comment.getBlockTags();
            TagDescriptor[] tds = (TagDescriptor[])context.getParameter(PROPERTY_SORT_ORDER);
            SortTagsFix.sort(tagList, tds);
        }
    }

    protected static void sort(List blockTags, TagDescriptor[] sortOrder) {
        int size = blockTags.size();
        SourceDocTag[] tags = new SourceDocTag[size];
        blockTags.toArray(tags);
        SourceDocTag[] sortedTags = DocAnalyzerUtils.sortTags(tags, sortOrder);
        for (int i = 0; i < sortedTags.length; ++i) {
            SourceDocTag docTag = sortedTags[i];
            docTag.removeSelf();
            blockTags.add(docTag);
        }
    }
}

