/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.audit.transform;

import java.util.List;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.jdeveloper.audit.java.JavaTransformContext;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdevimpl.javadoc.audit.DocAnalyzerUtils;
import oracle.jdevimpl.javadoc.audit.transform.AbstractDocFix;

public class AddTerminatorFix
extends AbstractDocFix {
    public AddTerminatorFix(Localizer localizer) {
        super("add-terminator-fix", localizer);
    }

    public boolean isApplicable(JavaTransformContext context, SourceElement element) {
        SourceDocComment comment = this.getDocComment(element);
        if (comment == null) {
            return false;
        }
        SourceDocDescription description = comment.getDescription();
        String cmtText = description.getDocText();
        return !DocAnalyzerUtils.hasEndSentenceChar(cmtText);
    }

    public void apply(JavaTransformContext context, SourceElement element) {
        SourceDocComment comment = this.getDocComment(element);
        if (comment != null) {
            Object childElement;
            SourceDocDescription description = comment.getDescription();
            SourceFactory factory = this.getFactory(element);
            List children = description.getChildren();
            int size = children.size() - 1;
            int index = -1;
            int i = size;
            while (i >= 0 && (childElement = children.get(i)) instanceof SourceDocTextFragment) {
                index = i--;
                String txt = ((SourceDocTextFragment)childElement).getDocText().trim();
                if (txt.length() == 0) continue;
            }
            if (index == -1) {
                SourceDocTextFragment terminated = factory.createDocTextFragment(".");
                children.add(terminated);
            } else {
                SourceDocTextFragment unterminated = (SourceDocTextFragment)children.get(index);
                String txt = unterminated.getDocText();
                SourceDocTextFragment terminated = index < size ? factory.createDocTextFragment(txt.trim() + ".\n") : factory.createDocTextFragment(txt.trim() + ".");
                children.remove(unterminated);
                children.add(index, terminated);
            }
        }
    }
}

