/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.audit.transform;

import java.util.List;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTagName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.jdeveloper.audit.java.JavaTransformContext;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdevimpl.javadoc.audit.transform.AbstractDocFix;
import oracle.jdevimpl.javadoc.audit.transform.SortTagsFix;

public class AddTagFix
extends AbstractDocFix {
    public static final String PROPERTY_MISSING_TAG_NAMES = "missing-tag-names";
    public static final String PROPERTY_MISSING_TAGS = "missing-tags";
    public static final String PROPERTY_SORT_ORDER = "sort-order";

    public AddTagFix(Localizer localizer) {
        super("add-tag-fix", localizer);
    }

    public boolean isApplicable(JavaTransformContext context, SourceElement element) {
        Object parameter = context.getParameter(PROPERTY_MISSING_TAGS);
        if (parameter == null) {
            return false;
        }
        TagDescriptor[] missingTags = (TagDescriptor[])parameter;
        if (missingTags.length == 0) {
            return false;
        }
        SourceDocComment comment = this.getDocComment(element);
        if (comment == null) {
            return true;
        }
        for (int i = 0; i < missingTags.length; ++i) {
            if (this.getIndex(comment.getBlockTags(), missingTags[i], 0) != -1) continue;
            return true;
        }
        return false;
    }

    public void apply(JavaTransformContext context, SourceElement element) {
        TagDescriptor[] missingTags = (TagDescriptor[])context.getParameter(PROPERTY_MISSING_TAGS);
        SourceDocComment comment = this.getDocComment(element);
        if (comment == null) {
            comment = this.createDocComment(element);
        }
        if (comment != null) {
            SourceFactory factory = context.getSourceFactory();
            int insertionPoint = -1;
            for (TagDescriptor tag : missingTags) {
                SourceDocBlockTag newTag;
                SourceDocDescription description;
                SourceDocTextFragment descFragment;
                String template;
                List existingTags = comment.getBlockTags();
                int foundLocation = this.getIndex(existingTags, tag, insertionPoint);
                if (foundLocation >= 0) {
                    insertionPoint = foundLocation + 1;
                    continue;
                }
                String name = tag.getName();
                SourceDocTagName docTagName = factory.createDocTagName(name);
                String reference = tag.getReference();
                String string = template = tag.isAllowsTemplate() ? tag.getTemplate() : "";
                if ("@param".equals(name)) {
                    SourceDocReference paramReference = factory.createDocParameterReference(reference);
                    descFragment = factory.createDocTextFragment(template);
                    description = factory.createDocDescription(descFragment);
                    newTag = factory.createDocBlockTag(docTagName, paramReference, description);
                } else if ("@throws".equals(name) || "@exception".equals(name)) {
                    SourceDocReference exReference = factory.createDocClassReference(reference);
                    descFragment = factory.createDocTextFragment(template);
                    description = factory.createDocDescription(descFragment);
                    newTag = factory.createDocBlockTag(docTagName, exReference, description);
                } else {
                    String description2 = reference.length() > 0 ? reference + " " : "";
                    description2 = description2 + (template.length() > 0 ? template : "");
                    descFragment = factory.createDocTextFragment(description2);
                    SourceDocDescription docDescription = factory.createDocDescription(descFragment);
                    newTag = factory.createDocBlockTag(docTagName, docDescription);
                }
                existingTags.add(newTag);
            }
            TagDescriptor[] sortOrder = (TagDescriptor[])context.getParameter(PROPERTY_SORT_ORDER);
            SortTagsFix.sort(comment.getBlockTags(), sortOrder);
        }
    }

    private int getIndex(List existingTags, TagDescriptor td, int startingIndex) {
        int index;
        int location = -1;
        for (int i = index = startingIndex == -1 ? 0 : startingIndex; i < existingTags.size(); ++i) {
            SourceDocTag tag = (SourceDocTag)existingTags.get(i);
            if (!td.equals(tag)) continue;
            location = i;
            break;
        }
        return location;
    }
}

