/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.audit.transform;

import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.jdeveloper.audit.java.JavaTransformAdapter;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;

public class AbstractDocFix
extends Transform {
    public static final String PROPERTY_TAG_NAME = "tagName";
    public static final String PROPERTY_TAG_TEXT = "tagText";

    public AbstractDocFix(String name, Localizer localizer) {
        super((TransformAdapter)new JavaTransformAdapter(), name, localizer);
    }

    protected SourceDocComment createDocComment(SourceElement construct) {
        SourceDocComment comment = null;
        SourceMember member = this.getSourceMember(construct);
        if (member != null && (comment = member.getDocComment()) == null) {
            SourceFactory factory = this.getFactory(construct);
            SourceDocTextFragment fragment = factory.createDocTextFragment("");
            SourceDocDescription desc = factory.createDocDescription(fragment);
            comment = factory.createDocComment(desc);
            comment.addSelf((SourceElement)member);
        }
        return comment;
    }

    protected SourceFactory getFactory(SourceElement construct) {
        return construct.getOwningSourceFile().getFactory();
    }

    protected SourceMember getSourceMember(SourceElement element) {
        while (element != null) {
            if (element instanceof SourceClassInitializer) {
                return null;
            }
            if (element instanceof SourceMember) {
                return (SourceMember)element;
            }
            if (element instanceof SourceBlock) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    protected SourceDocTag getDocTag(SourceElement element) {
        if (element instanceof SourceDocTag) {
            return (SourceDocTag)element;
        }
        return null;
    }

    protected SourceDocComment getDocComment(SourceElement element) {
        if (element instanceof SourceDocComment) {
            return (SourceDocComment)element;
        }
        SourceMember member = this.getSourceMember(element);
        if (member != null) {
            return member.getDocComment();
        }
        return null;
    }
}

