/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.audit;

import java.awt.Component;
import java.net.URL;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vcs.VCSTask;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.jdeveloper.audit.AbstractAuditAddin;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.java.Visibility;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.javadoc.TagManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.JavaAddin;
import oracle.jdevimpl.java.explorer.CodeElement;
import oracle.jdevimpl.java.explorer.JavaCodeElement;
import oracle.jdevimpl.java.explorer.ModifierElement;
import oracle.jdevimpl.javadoc.JavadocArb;
import oracle.jdevimpl.javadoc.JavadocOptionsPanel;
import oracle.jdevimpl.javadoc.audit.DocAnalyzer;
import oracle.jdevimpl.javadoc.audit.DocAnalyzerBundle;
import oracle.jdevimpl.javadoc.audit.DocRule;

public class DocCommenter
extends AbstractAuditAddin
implements Addin,
CodeMenuConstants,
ContextMenuListener,
Controller,
DynamicMenuListener {
    private static boolean _addinInitialized;
    private boolean _cmdInitialized;
    private JMenuItem _addDocComments;
    private IdeAction _addDocCommentsAction;
    public static final String JAVADOC_RULES = "javadoc-rules";
    public static final String ADD_JAVADOC_CMD = "DocCommenter.ADD_JAVADOC_CMD";
    public static final int ADD_JAVADOC_CMD_ID;
    private JComponent[] _dynamicItems;

    public Class[] getAnalyzers() {
        return new Class[]{DocAnalyzer.class};
    }

    public Profile[] getProfiles() {
        AuditManager manager = AuditManager.getAuditManager();
        return new Profile[]{manager.createProfile(JAVADOC_RULES, DocAnalyzerBundle.get("JAVADOC_RULES_PROFILE"), ((Object)((Object)this)).getClass().getResource("Javadoc.xml"))};
    }

    public void initializeAlways() {
        TagManager.getInstance().getSettings();
        _addinInitialized = true;
    }

    public void initializeUI() {
        ExplorerManager.getExplorerManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        String optionsName = JavadocArb.getString(11);
        Navigable navigable = new Navigable(optionsName, JavadocOptionsPanel.class);
        JavaAddin addin = (JavaAddin)AddinManager.getAddinManager().getAddin(JavaAddin.class);
        if (addin != null) {
            Navigable javaNavigable = addin.getJavaNavigable();
            javaNavigable.addChildNavigable(navigable);
        } else {
            IdeSettings.registerUI((Navigable)navigable);
        }
        String menuLabel = JavadocArb.getString(8);
        Integer mnemonic = JavadocArb.getInteger(9);
        this._addDocCommentsAction = IdeAction.get((int)ADD_JAVADOC_CMD_ID, (String)AddinManager.getAddinManager().getCommand(ADD_JAVADOC_CMD_ID, null), (String)menuLabel, (String)CATEGORY_CODE_MENU, (Integer)mnemonic, null, null, (boolean)true);
        this._addDocCommentsAction.addController((Controller)this);
        this._initializeDynamicActions();
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
        KeyStrokeContextRegistry keyRegistry = Ide.getKeyStrokeContextRegistry();
        keyRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "oracle/jdevimpl/javadoc/audit/accelerators.xml");
    }

    public void menuWillShow(ContextMenu popup) {
        JavaCodeElement codeElement;
        Context context;
        Context context2 = context = popup != null ? popup.getContext() : null;
        if (context == null) {
            return;
        }
        View view = context.getView();
        Element elem = context.getElement();
        if (this._addDocComments == null) {
            this._addDocComments = popup.createMenuItem((ToggleAction)this._addDocCommentsAction, 440.0f);
        }
        if (view instanceof ExplorerWindow && elem instanceof ModifierElement && (codeElement = (JavaCodeElement)elem).getStartOffset() != -1) {
            popup.add((Component)this._addDocComments, CodeMenuConstants.SECTION_SOURCE_CTXT_MENU_NON_EDITOR);
            this.update(this._addDocCommentsAction, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdID = action.getCommandId();
        if (cmdID == ADD_JAVADOC_CMD_ID) {
            SourceMember member = DocCommenter.getMemberAt(context);
            if (!this._cmdInitialized) {
                this._cmdInitialized = true;
            }
            if (member == null) {
                String title = JavadocArb.getString(63);
                String msg = JavadocArb.getString(64);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)msg, (String)title, null);
                return true;
            }
            Node node = context.getNode();
            if (node.isReadOnly()) {
                try {
                    if (!((Boolean)VCSManager.getVCSManager().checkOutUsingUI(new VCSTask(new URL[]{node.getURL()}){}).get()).booleanValue()) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)JavadocArb.format(66, URLFileSystem.getPlatformPathName((URL)node.getURL())), (String)JavadocArb.getString(65), null);
                    }
                }
                catch (CancellationException ce) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            DocCommenter.addJavadocComments(member, context);
            DocCommenter.gotoCommentStart(member, context);
        }
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdID = action.getCommandId();
        if (cmdID == ADD_JAVADOC_CMD_ID) {
            boolean enabled = false;
            if (this.validateContext(context)) {
                if (!this._cmdInitialized) {
                    enabled = true;
                } else {
                    boolean singleSelection;
                    View view = context.getView();
                    Element[] selection = context.getSelection();
                    int selectionLength = selection != null ? selection.length : 0;
                    boolean bl = singleSelection = view instanceof CodeEditor || view instanceof ExplorerWindow && selectionLength == 1;
                    if (singleSelection) {
                        enabled = DocCommenter.getMemberAt(context) != null;
                    }
                }
            }
            action.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private boolean validateContext(Context context) {
        JavaSourceNode javaSourceNode;
        return context != null && context.getProject() != null && context.getNode() instanceof JavaSourceNode && (!(javaSourceNode = (JavaSourceNode)context.getNode()).isReadOnly() || VCSManager.getVCSManager() != null && VCSManager.getVCSManager().isVersioned(javaSourceNode.getURL()));
    }

    public static boolean isAddinInitialized() {
        return _addinInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addJavadocComments(SourceMember member, Context context) {
        if (!_addinInitialized) {
            return;
        }
        if (member == null) {
            member = DocCommenter.getMemberAt(context);
        }
        if (member != null) {
            DocCommenter commenter = new DocCommenter();
            AuditManager manager = AuditManager.getAuditManager();
            Auditor auditor = manager.createAuditor();
            try {
                if (auditor.addConstruct((Object)member, context.getNode().getURL(), context.getProject(), context.getWorkspace())) {
                    auditor.setVisitAncestors(false);
                    auditor.setVisitDescendants(false);
                    Profile profile = commenter.buildDocProfile((SourceElement)member);
                    auditor.setProfile(profile);
                    Throwable e = auditor.applyDefaultTransforms(JavadocArb.getString(8));
                    if (e != null) {
                        // empty if block
                    }
                }
            }
            catch (Exception e) {
            }
            finally {
                auditor.clear();
            }
        }
    }

    public static void gotoCommentStart(SourceMember member, Context context) {
        SourceDocComment comment;
        if (member != null && context != null && (comment = member.getDocComment()) != null) {
            SourceDocDescription description = comment.getDescription();
            int start = description != null ? (description.getDocText().trim().length() == 0 ? description.getEndOffset() - 1 : description.getStartOffset()) : comment.getStartOffset() + 3;
            NavigationManager mgr = NavigationManager.getNavigationManager();
            OffsetNavigationPoint point = new OffsetNavigationPoint(context, start, 0);
            try {
                if (start != -1 && mgr != null) {
                    mgr.navigateTo((NavigationPoint)point);
                } else {
                    point.navigate();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Profile buildDocProfile(SourceElement element) {
        Class profileAnalyzer = element == null ? DocAnalyzerNullElement.class : DocAnalyzerNonNullElement.class;
        AuditManager manager = AuditManager.getAuditManager();
        return manager.createProfile("jdev-auto-fix-javadoc", new Class[]{profileAnalyzer});
    }

    private boolean contains(Rule[] rules, Rule toFind) {
        for (int i = 0; i < rules.length; ++i) {
            if (!rules[i].id().equals(toFind.id())) continue;
            return true;
        }
        return false;
    }

    public static SourceMember getMemberAt(Context context) {
        SourceMember member = null;
        View view = context.getView();
        Project project = context.getProject();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        URL url = context.getNode().getURL();
        SourceFile file = javaManager.getSourceFile(url);
        if (view instanceof CodeEditor) {
            CodeEditor editor = (CodeEditor)view;
            int offset = editor.getCaretPosition();
            member = DocCommenter.getMemberAt(file, offset);
        } else {
            Element selection = context.getElement();
            if (selection instanceof CodeElement) {
                int offset = ((CodeElement)selection).getStartOffset();
                member = DocCommenter.getMemberAt(file, offset);
            }
        }
        return member;
    }

    private static SourceMember getMemberAt(SourceFile file, int offset) {
        for (SourceElement element = file.getElementAt(offset); element != null; element = element.getParent()) {
            if (element instanceof SourceClassInitializer) {
                return null;
            }
            if (element instanceof SourceMember) {
                if (element instanceof SourceClass) {
                    String text = element.getText();
                    int index = text.indexOf(123);
                    if (offset > element.getStartOffset() + index) {
                        return null;
                    }
                }
                if (!(element instanceof SourceFieldVariable)) {
                    return (SourceMember)element;
                }
            }
            if (!(element instanceof SourceBlock)) continue;
            return null;
        }
        return null;
    }

    private void _initializeDynamicActions() {
        JMenuItem addDocCommentsItem = Ide.getMenubar().createMenuItem((ToggleAction)this._addDocCommentsAction, 440.0f);
        this._dynamicItems = new JComponent[]{addDocCommentsItem};
    }

    public JComponent[] gatherDynamicActions(Context context) {
        Node node;
        View view = context.getView();
        if (view instanceof CodeEditor && (node = context.getNode()) instanceof JavaSourceNode) {
            return this._dynamicItems;
        }
        return new JComponent[0];
    }

    static {
        ADD_JAVADOC_CMD_ID = Ide.findOrCreateCmdID((String)ADD_JAVADOC_CMD);
    }

    public static class DocAnalyzerNonNullElement
    extends DocAnalyzer {
        @Override
        public Rule[] getRules() {
            Rule[] rules;
            this.setAutoGenScope(7);
            for (Rule rule : rules = this.getRulesNonNullElement()) {
                ((DocRule)rule).setVisibility(Visibility.PRIVATE);
            }
            return rules;
        }
    }

    public static class DocAnalyzerNullElement
    extends DocAnalyzer {
        @Override
        public Rule[] getRules() {
            Rule[] rules;
            this.setAutoGenScope(7);
            for (Rule rule : rules = this.getRulesNullElement()) {
                ((DocRule)rule).setVisibility(Visibility.PRIVATE);
            }
            return rules;
        }
    }
}

