/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.audit;

import java.util.ArrayList;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.jdeveloper.javadoc.TagDescriptor;

public class DocAnalyzerUtils {
    public static String getReference(SourceDocTag tag) {
        if (tag.isReference() || tag.isParameter() || tag.isException()) {
            return tag.getReferenceText();
        }
        return tag.getArgumentText();
    }

    public static String getFirstWord(String text) {
        String newText = text.trim();
        int pos = newText.indexOf(" ");
        if (pos < 0) {
            return newText;
        }
        return newText.substring(0, pos);
    }

    public static SourceDocTag[] sortTags(SourceDocTag[] docTags, TagDescriptor[] orderedTDs) {
        int i;
        ArrayList<Object> sortedList = new ArrayList<Object>();
        ArrayList<SourceDocTag> remainingList = new ArrayList<SourceDocTag>();
        for (i = 0; i < orderedTDs.length; ++i) {
            TagDescriptor td = orderedTDs[i];
            SourceDocTag[] matchingTags = td.findDocTags(docTags);
            for (int x = 0; x < matchingTags.length; ++x) {
                if (sortedList.contains(matchingTags[x])) continue;
                sortedList.add(matchingTags[x]);
            }
        }
        for (i = 0; i < docTags.length; ++i) {
            if (sortedList.contains(docTags[i])) continue;
            remainingList.add(docTags[i]);
        }
        sortedList.addAll(remainingList);
        SourceDocTag[] sortedTags = new SourceDocTag[sortedList.size()];
        sortedList.toArray(sortedTags);
        return sortedTags;
    }

    public static boolean hasEndSentenceChar(String cmt) {
        if (cmt.indexOf(". ") != -1 || cmt.indexOf(".\t") != -1 || cmt.indexOf(".\n") != -1 || cmt.indexOf(".\r") != -1 || cmt.indexOf(".\f") != -1 || cmt.indexOf("? ") != -1 || cmt.indexOf("?\t") != -1 || cmt.indexOf("?\n") != -1 || cmt.indexOf("?\r") != -1 || cmt.indexOf("?\f") != -1 || cmt.indexOf("! ") != -1 || cmt.indexOf("!\t") != -1 || cmt.indexOf("!\n") != -1 || cmt.indexOf("!\r") != -1 || cmt.indexOf("!\f") != -1 || cmt.indexOf(".<") != -1) {
            return true;
        }
        int endIndex = cmt.length() - 1;
        return cmt.charAt(endIndex) == '.' || cmt.charAt(endIndex) == '?' || cmt.charAt(endIndex) == '!';
    }
}

