/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.audit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocElement;
import oracle.javatools.parser.java.v2.model.doc.SourceDocInlineTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.java.Visibility;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdeveloper.javadoc.TagManager;
import oracle.jdevimpl.javadoc.JavadocArb;
import oracle.jdevimpl.javadoc.audit.DocAnalyzerBundle;
import oracle.jdevimpl.javadoc.audit.DocAnalyzerUtils;
import oracle.jdevimpl.javadoc.audit.DocCategory;
import oracle.jdevimpl.javadoc.audit.DocRule;
import oracle.jdevimpl.javadoc.audit.transform.AddCommentFix;
import oracle.jdevimpl.javadoc.audit.transform.AddTagFix;
import oracle.jdevimpl.javadoc.audit.transform.AddTerminatorFix;
import oracle.jdevimpl.javadoc.audit.transform.RemoveTagFix;
import oracle.jdevimpl.javadoc.audit.transform.SortTagsFix;
import oracle.jdevimpl.javadoc.audit.transform.TagSpellingFix;

public class DocAnalyzer
extends Analyzer {
    private TagDescriptor[] constructorTags;
    private TagDescriptor[] methodTags;
    private TagDescriptor[] classTags;
    private TagDescriptor[] fieldTags;
    public static final int CLASS_SCOPE = 1;
    public static final int METHOD_SCOPE = 2;
    public static final int FIELD_SCOPE = 4;
    public static final int ALL_SCOPE = 7;
    private int autoGenScope = 7;
    private static final SourceDocTag[] NO_DOC_TAGS = new SourceDocTag[0];
    private static final TagDescriptor[] NO_TAG_DESCRIPTORS = new TagDescriptor[0];
    private final Localizer _localizer = Localizer.instance(DocAnalyzerBundle.class);
    private final DocCategory docCategory = new DocCategory(this._localizer);
    private static final String COMMENT_MISSING = "missing-comment";
    private static final String DESCRIPTION_MISSING = "description-is-empty";
    private static final String TAG_MISSPELLED = "tag-misspelled";
    private static final String TAG_MISSING = "tag-is-missing";
    private static final String TAG_MISPLACED = "tag-is-misplaced";
    private static final String TAG_DUPLICATE = "tag-is-duplicate";
    private static final String TAG_DESCRIPTION_MISSING = "tag-description-missing";
    private static final String TAGS_UNSORTED = "tags-incorrectly-sorted";
    private static final String COMMENT_MISSING_PERIOD = "comment-period-missing";
    private static final String COMMENT_HTML_INVALID = "comment-html-is-unterminated";
    private DocRule JD_COMMENT_MISSING = new DocRule("missing-comment", this.docCategory, Severity.ADVISORY, this._localizer, new AddCommentFix(this._localizer));
    private DocRule JD_DESCRIPTION_MISSING = new DocRule("description-is-empty", this.docCategory, Severity.ADVISORY, this._localizer);
    private DocRule JD_TAG_MISSPELLED = new DocRule("tag-misspelled", this.docCategory, Severity.WARNING, this._localizer, new TagSpellingFix(this._localizer));
    private DocRule JD_TAG_MISSING = new DocRule("tag-is-missing", new String[]{"missing-comment"}, this.docCategory, Severity.WARNING, this._localizer, null, new AddTagFix(this._localizer));
    private DocRule JD_TAG_MISPLACED = new DocRule("tag-is-misplaced", this.docCategory, Severity.WARNING, this._localizer, new Transform[]{new RemoveTagFix(this._localizer)}, null);
    private DocRule JD_TAG_DUPLICATE = new DocRule("tag-is-duplicate", this.docCategory, Severity.WARNING, this._localizer, new RemoveTagFix(this._localizer));
    private DocRule JD_TAG_DESCRIPTION_MISSING = new DocRule("tag-description-missing", this.docCategory, Severity.ADVISORY, this._localizer);
    private DocRule JD_TAGS_UNSORTED = new DocRule("tags-incorrectly-sorted", this.docCategory, Severity.ADVISORY, this._localizer, new SortTagsFix(this._localizer));
    private DocRule JD_COMMENT_MISSING_PERIOD = new DocRule("comment-period-missing", this.docCategory, Severity.WARNING, this._localizer, new AddTerminatorFix(this._localizer));
    private DocRule JD_COMMENT_HTML_INVALID = new DocRule("comment-html-is-unterminated", this.docCategory, Severity.WARNING, this._localizer);
    private static final String MESSAGE_SUBJECT = "subject";
    private static final String MESSAGE_DETAIL = "detail";
    private static final String[] TAGS_CAN_BE_UNTERMINATED = new String[]{"p", "br", "li", "dt", "dd", "hr", "img", "th"};

    public Rule[] getRules() {
        return new Rule[]{this.JD_COMMENT_MISSING, this.JD_DESCRIPTION_MISSING, this.JD_TAG_DESCRIPTION_MISSING, this.JD_TAG_MISSPELLED, this.JD_TAG_MISSING, this.JD_TAG_MISPLACED, this.JD_TAG_DUPLICATE, this.JD_TAGS_UNSORTED, this.JD_COMMENT_MISSING_PERIOD, this.JD_COMMENT_HTML_INVALID};
    }

    public Rule[] getRules(SourceElement element) {
        if (element == null) {
            return this.getRulesNullElement();
        }
        return this.getRulesNonNullElement();
    }

    protected Rule[] getRulesNonNullElement() {
        return new Rule[]{this.JD_COMMENT_MISSING, this.JD_TAG_MISSING, this.JD_TAG_MISSPELLED, this.JD_TAGS_UNSORTED};
    }

    protected Rule[] getRulesNullElement() {
        return new Rule[]{this.JD_TAG_MISSING, this.JD_TAG_MISSPELLED, this.JD_TAGS_UNSORTED};
    }

    public void setAutoGenScope(int scope) {
        this.autoGenScope |= scope;
    }

    public void unsetAutoGenScope(int scope) {
        this.autoGenScope &= ~scope;
    }

    private void verify(AuditContext context, Visibility visibility, SourceDocComment comment, Collection collTypeParameters, TagDescriptor[] standardTags, TagDescriptor[] inlineTags) {
        TagDescriptor[] adjustedStandardTags;
        Set<TagDescriptor> typeParamTags = this.getTypeParameterTags(collTypeParameters);
        if (!typeParamTags.isEmpty()) {
            int i = 0;
            adjustedStandardTags = new TagDescriptor[standardTags.length + typeParamTags.size()];
            for (TagDescriptor td : typeParamTags) {
                adjustedStandardTags[i++] = td;
            }
            System.arraycopy(standardTags, 0, adjustedStandardTags, i, standardTags.length);
        } else {
            adjustedStandardTags = standardTags;
        }
        this.verifyComment(context, visibility, comment, adjustedStandardTags, inlineTags);
    }

    private void verifyComment(AuditContext context, Visibility visibility, SourceDocComment comment, TagDescriptor[] tds, TagDescriptor[] inlineTds) {
        if (comment == null) {
            HashMap<SourceDocTag, String> spellMap = new HashMap<SourceDocTag, String>();
            boolean missingTagsReported = this.checkRequired(context, visibility, comment, tds, NO_DOC_TAGS, spellMap);
            if (!missingTagsReported && this.shouldVerify(this.JD_COMMENT_MISSING, visibility)) {
                context.report((Rule)this.JD_COMMENT_MISSING);
            }
        } else {
            this.verifyDescription(visibility, comment, context);
            this.verifyTags(context, visibility, comment, tds);
            this.verifyInlineTags(context, visibility, comment, inlineTds);
        }
    }

    private void verifyDescription(Visibility visibility, SourceDocComment comment, AuditContext context) {
        this.verifyDescription(context, visibility, comment, null);
    }

    private void verifyDescription(AuditContext context, Visibility visibility, SourceDocComment comment, String template) {
        boolean descriptionIsBlank;
        if (comment == null) {
            return;
        }
        SourceDocDescription description = comment.getDescription();
        boolean bl = descriptionIsBlank = description == null || description.isBlank();
        if (this.shouldVerify(this.JD_DESCRIPTION_MISSING, visibility) && descriptionIsBlank) {
            ViolationReport report = template == null || template.trim().length() == 0 ? context.report((Rule)this.JD_DESCRIPTION_MISSING, (Object)comment) : context.report((Rule)this.JD_DESCRIPTION_MISSING);
        }
        if (!descriptionIsBlank) {
            String docText;
            if (this.shouldVerify(this.JD_COMMENT_MISSING_PERIOD, visibility) && !DocAnalyzerUtils.hasEndSentenceChar(docText = description.getDocText()) && !docText.trim().startsWith("@inheritDoc")) {
                context.report((Rule)this.JD_COMMENT_MISSING_PERIOD, (Object)description);
            }
            this.checkHTML(context, visibility, description);
        }
    }

    private void verifyTags(AuditContext context, Visibility visibility, SourceDocComment comment, TagDescriptor[] tds) {
        SourceDocTag[] existingTags;
        HashMap<SourceDocTag, String> misspelledTags = new HashMap<SourceDocTag, String>();
        ArrayList<TagDescriptor> dups = new ArrayList<TagDescriptor>();
        if (comment != null) {
            List blockTags = comment.getBlockTags();
            existingTags = blockTags.toArray(new SourceDocTag[blockTags.size()]);
        } else {
            existingTags = NO_DOC_TAGS;
        }
        this.checkRequired(context, visibility, comment, tds, existingTags, misspelledTags);
        for (int i = 0; i < existingTags.length; ++i) {
            SourceDocTag currentTag = existingTags[i];
            TagDescriptor td = this.findTag(currentTag, tds);
            if (td == null) {
                this.checkMisplaced(context, visibility, currentTag, misspelledTags);
                continue;
            }
            if (!this.checkDuplicates(context, visibility, currentTag, td, dups)) {
                this.checkTagDescription(context, visibility, currentTag);
            }
            if (!td.isAllowDuplicates() && !dups.contains(td)) {
                dups.add(td);
            }
            this.checkHTML(context, visibility, currentTag.getDescription());
        }
        this.checkSortOrder(context, visibility, tds, existingTags);
    }

    private void verifyInlineTags(AuditContext context, Visibility visibility, SourceDocComment comment, TagDescriptor[] inlineTds) {
        if (comment != null && this.shouldVerify(this.JD_TAG_MISPLACED, visibility)) {
            Collection tags = comment.getInlineTags();
            for (SourceDocInlineTag tag : tags) {
                boolean match = false;
                for (TagDescriptor inlineTag : inlineTds) {
                    if (!tag.getName().equals(inlineTag.getName())) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                ViolationReport report = context.report((Rule)this.JD_TAG_MISPLACED, (Object)tag);
                report.addParameter("tagName", (Object)tag.getName());
            }
        }
    }

    private void checkHTML(AuditContext context, Visibility visibility, SourceDocDescription srcDocDescription) {
        if (srcDocDescription == null) {
            return;
        }
        if (!this.shouldVerify(this.JD_COMMENT_HTML_INVALID, visibility)) {
            return;
        }
        HashMap<String, List<SourceElement>> openTags = new HashMap<String, List<SourceElement>>();
        HashMap<String, List<SourceElement>> closeTags = new HashMap<String, List<SourceElement>>();
        for (SourceDocElement docElement : srcDocDescription.getChildren()) {
            String descriptionText;
            SourceDocElement srcElement;
            if (docElement instanceof SourceDocInlineTag) {
                SourceDocInlineTag inlineTag = (SourceDocInlineTag)docElement;
                String tagName = inlineTag.getName();
                srcElement = inlineTag.getDescription();
                descriptionText = "@literal".equals(tagName) || "@code".equals(tagName) ? "" : (srcElement != null ? srcElement.getText() : "");
            } else {
                srcElement = docElement;
                descriptionText = docElement.getText();
            }
            this.checkUnterminatedTags(descriptionText, (SourceElement)srcElement, openTags, closeTags);
        }
        if (openTags.keySet().size() > 0) {
            ArrayList openingTags = new ArrayList(openTags.keySet());
            for (int i = openingTags.size() - 1; i > 0; --i) {
                String two;
                String one = (String)openingTags.get(i);
                if (!one.equalsIgnoreCase(two = (String)openingTags.get(i - 1))) continue;
                openingTags.remove(i);
                --i;
            }
        }
        this.reportHtmlErrors(context, openTags, JavadocArb.getString(103));
        this.reportHtmlErrors(context, closeTags, JavadocArb.getString(102));
    }

    private void checkUnterminatedTags(String descriptionText, SourceElement srcElement, Map<String, List<SourceElement>> openTags, Map<String, List<SourceElement>> closeTags) {
        if (descriptionText == null || descriptionText.trim().length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(descriptionText, " \t\n\r\f<>", true);
        while (st.hasMoreTokens()) {
            String endTokenName;
            boolean closeTagIsBogus;
            String token = st.nextToken();
            if (!token.equals("<")) continue;
            try {
                token = st.nextToken();
            }
            catch (Exception e) {
                break;
            }
            if (token.charAt(0) >= 'A' && token.charAt(0) <= 'Z' || token.charAt(0) >= 'a' && token.charAt(0) <= 'z') {
                if (!this.tagMustBeTerminated(token)) continue;
                this.addToTagMap(token, srcElement, openTags);
                continue;
            }
            if (token.charAt(0) != '/' || !(closeTagIsBogus = this.tagMustBeTerminated(endTokenName = token.substring(1)))) continue;
            Iterator<String> nextKey = openTags.keySet().iterator();
            while (nextKey.hasNext()) {
                String openTagName = nextKey.next();
                if (!endTokenName.equalsIgnoreCase(openTagName)) continue;
                List<SourceElement> valueList = openTags.get(openTagName);
                int size = valueList.size();
                if (size == 1) {
                    closeTagIsBogus = false;
                    nextKey.remove();
                    break;
                }
                if (size <= 0) break;
                closeTagIsBogus = false;
                valueList.remove(size - 1);
                break;
            }
            if (!closeTagIsBogus) continue;
            this.addToTagMap(token, srcElement, closeTags);
        }
    }

    private boolean tagMustBeTerminated(String token) {
        boolean needsCloseTag = true;
        for (String nextTag : TAGS_CAN_BE_UNTERMINATED) {
            if (!token.equalsIgnoreCase(nextTag) && !token.equalsIgnoreCase(nextTag + '/')) continue;
            needsCloseTag = false;
            break;
        }
        return needsCloseTag;
    }

    private void addToTagMap(String key, SourceElement value, Map<String, List<SourceElement>> map) {
        List<Object> locations;
        if (map.containsKey(key)) {
            locations = map.get(key);
        } else {
            locations = new ArrayList();
            map.put(key, locations);
        }
        if (!locations.contains(value)) {
            locations.add(value);
        }
    }

    private void reportHtmlErrors(AuditContext context, Map<String, List<SourceElement>> map, String violationDescription) {
        for (String tag : map.keySet()) {
            for (SourceElement errorLocation : map.get(tag)) {
                ViolationReport report = context.report((Rule)this.JD_COMMENT_HTML_INVALID, (Object)errorLocation);
                report.addParameter(MESSAGE_SUBJECT, (Object)tag);
                report.addParameter(MESSAGE_DETAIL, (Object)violationDescription);
            }
        }
    }

    private boolean checkRequired(AuditContext context, Visibility visibility, SourceDocComment comment, TagDescriptor[] tagsToCheck, SourceDocTag[] existing, Map<SourceDocTag, String> spellMap) {
        if (!this.shouldVerify(this.JD_TAG_MISSING, visibility) && !this.shouldVerify(this.JD_TAG_MISSPELLED, visibility)) {
            return false;
        }
        StringBuffer buf = new StringBuffer(100);
        ArrayList<TagDescriptor> required = new ArrayList<TagDescriptor>(tagsToCheck.length);
        for (TagDescriptor td : tagsToCheck) {
            SourceDocTag[] found = td.findDocTags(existing);
            if (!td.isRequired()) continue;
            required.add(td);
            if (found.length != 0 || this.checkSpelling(td, existing, spellMap)) continue;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(td.getName());
            if (td.getReference().length() <= 0) continue;
            buf.append(" ");
            buf.append(td.getReference());
        }
        if (buf.length() > 0) {
            TagDescriptor[] requiredTags = new TagDescriptor[required.size()];
            required.toArray(requiredTags);
            ViolationReport report = context.report((Rule)this.JD_TAG_MISSING);
            if (comment == null) {
                report.setVariation(COMMENT_MISSING);
            } else {
                report.setFocusLocation((Object)comment);
            }
            report.addParameter("missing-tag-names", (Object)buf.toString());
            report.addParameter("missing-tags", (Object)requiredTags);
            report.addParameter("sort-order", (Object)tagsToCheck);
            return true;
        }
        return false;
    }

    private void checkMisplaced(AuditContext context, Visibility visibility, SourceDocTag currentTag, Map<SourceDocTag, String> misspelledTags) {
        String fixText = misspelledTags.get(currentTag);
        if (fixText != null) {
            if (this.shouldVerify(this.JD_TAG_MISSPELLED, visibility)) {
                ViolationReport report = context.report((Rule)this.JD_TAG_MISSPELLED, (Object)currentTag);
                report.addParameter("tagName", (Object)currentTag.getName());
                report.addParameter("Correction", (Object)fixText);
                report.addParameter("tagText", (Object)DocAnalyzerUtils.getReference(currentTag));
            }
        } else if (this.shouldVerify(this.JD_TAG_MISPLACED, visibility) && !"@beaninfo".equals(currentTag.getName()) && !"@hidden".equals(currentTag.getName()) && !currentTag.isException()) {
            ViolationReport report = context.report((Rule)this.JD_TAG_MISPLACED, (Object)currentTag);
            report.addParameter("fullTagName", (Object)this.getFullTagName(currentTag));
            report.addParameter("tagName", (Object)currentTag.getName());
            report.addParameter("tagText", (Object)DocAnalyzerUtils.getReference(currentTag));
        }
    }

    private void checkSortOrder(AuditContext context, Visibility visibility, TagDescriptor[] sortedTDs, SourceDocTag[] existing) {
        Object[] sortedTags;
        if (this.shouldVerify(this.JD_TAGS_UNSORTED, visibility) && !Arrays.equals(existing, sortedTags = DocAnalyzerUtils.sortTags(existing, sortedTDs))) {
            SourceDocComment comment = (SourceDocComment)existing[0].getParent();
            ViolationReport report = context.report((Rule)this.JD_TAGS_UNSORTED, (Object)comment);
            report.addParameter("sort-order", (Object)sortedTDs);
        }
    }

    private boolean checkDuplicates(AuditContext context, Visibility visibility, SourceDocTag currentTag, TagDescriptor td, List<TagDescriptor> duplicateTags) {
        if (this.shouldVerify(this.JD_TAG_DUPLICATE, visibility) && !td.isAllowDuplicates() && duplicateTags.contains(td)) {
            ViolationReport report = context.report((Rule)this.JD_TAG_DUPLICATE, (Object)currentTag);
            report.addParameter("fullTagName", (Object)this.getFullTagName(currentTag));
            report.addParameter("tagName", (Object)currentTag.getName());
            report.addParameter("tagText", (Object)DocAnalyzerUtils.getReference(currentTag));
            return true;
        }
        return false;
    }

    private void checkTagDescription(AuditContext context, Visibility visibility, SourceDocTag currentTag) {
        boolean blank;
        SourceDocDescription description = currentTag.getDescription();
        boolean bl = blank = description == null || description.isBlank();
        if (this.shouldVerify(this.JD_TAG_DESCRIPTION_MISSING, visibility) && blank && !currentTag.isException() && !currentTag.isReference()) {
            ViolationReport report = context.report((Rule)this.JD_TAG_DESCRIPTION_MISSING, (Object)currentTag);
            report.addParameter("full-tag-name", (Object)this.getFullTagName(currentTag));
        }
    }

    private boolean checkSpelling(TagDescriptor td, SourceDocTag[] existing, Map<SourceDocTag, String> map) {
        String[] reCheck;
        boolean error = false;
        for (String tagName : reCheck = this.getMisspellings(td.getName())) {
            SourceDocTag[] found;
            TagDescriptor tdCopy = (TagDescriptor)td.copyTo(null);
            tdCopy.setName(tagName);
            for (SourceDocTag errorTag : found = tdCopy.findDocTags(existing)) {
                if (!map.containsKey(errorTag)) {
                    map.put(errorTag, td.getName());
                }
                if (error) continue;
                error = found.length > 0;
            }
        }
        return error;
    }

    private String[] getMisspellings(String tagName) {
        if ("@param".equals(tagName)) {
            return new String[]{"@parm"};
        }
        if ("@return".equals(tagName)) {
            return new String[]{"@returns"};
        }
        return new String[0];
    }

    private boolean shouldVerify(DocRule rule, Visibility vis) {
        return rule.isEnabled();
    }

    private boolean checkVisibility(Visibility elemVisibility) {
        boolean match = false;
        Rule[] rules = this.getRules();
        for (int i = 0; i < rules.length; ++i) {
            if (!rules[i].isEnabled() || match) continue;
            DocRule rule = (DocRule)rules[i];
            Visibility minimumVisibility = rule.getVisibility();
            match = minimumVisibility.compareTo(elemVisibility) <= 0;
        }
        return match;
    }

    private TagDescriptor findTag(SourceDocTag tag, TagDescriptor[] tds) {
        for (TagDescriptor td : tds) {
            if (!td.nameAndReferenceEquals(tag)) continue;
            return td;
        }
        return null;
    }

    private String getFullTagName(SourceDocTag tag) {
        String name = tag.getName();
        String append = "";
        SourceDocReference reference = tag.getReference();
        if (reference != null) {
            String ref = reference.getNormalizedText();
            int index = ref.indexOf(" ");
            append = index > 0 ? ref.substring(0, index) : ref;
        }
        return append != null && append.length() > 0 ? name + " " + append.trim() : name;
    }

    private Set<TagDescriptor> getTypeParameterTags(Collection typeParameters) {
        if (!typeParameters.isEmpty()) {
            HashSet<TagDescriptor> set = new HashSet<TagDescriptor>();
            for (JavaTypeVariable var : typeParameters) {
                set.add(this.newTypeParameterTagDescriptor(var));
            }
            return set;
        }
        return Collections.emptySet();
    }

    private TagDescriptor newTypeParameterTagDescriptor(JavaTypeVariable var) {
        TagDescriptor td = (TagDescriptor)TagManager.PARAM_TAG_DEF.copyTo(null);
        td.setTemplate("");
        td.setReference('<' + var.getName() + '>');
        return td;
    }

    public void exit(AuditContext context, SourceFieldDeclaration fieldConstruct) {
        if ((this.autoGenScope & 4) == 0) {
            return;
        }
        SourceClass cls = fieldConstruct.getEnclosingClass();
        if (cls == null || cls.isAnonymous()) {
            return;
        }
        int modifiers = fieldConstruct.getModifiers();
        Visibility visibility = Visibility.valueOf(modifiers);
        if (!this.checkVisibility(visibility)) {
            return;
        }
        this.verify(context, visibility, fieldConstruct.getDocComment(), Collections.emptySet(), this.getTagsForType(2), this.getInlineTagsForType(2));
    }

    public void exit(AuditContext context, SourceClass classConstruct) {
        if ((this.autoGenScope & 1) == 0) {
            return;
        }
        if (!classConstruct.isExported()) {
            return;
        }
        int modifiers = classConstruct.getModifiers();
        Visibility visibility = Visibility.valueOf(modifiers);
        if (!this.checkVisibility(visibility)) {
            return;
        }
        this.verify(context, visibility, classConstruct.getDocComment(), classConstruct.getTypeParameters(), this.getTagsForType(1), this.getInlineTagsForType(1));
    }

    public void exit(AuditContext context, SourceMethod methodConstruct) {
        if ((this.autoGenScope & 2) == 0) {
            return;
        }
        SourceClass cls = methodConstruct.getEnclosingClass();
        if (cls.isAnonymous()) {
            return;
        }
        int modifiers = methodConstruct.getModifiers();
        Visibility visibility = Visibility.valueOf(modifiers);
        if (!this.checkVisibility(visibility)) {
            return;
        }
        boolean isConstructor = methodConstruct.isConstructor();
        int TAG = isConstructor ? 8 : 4;
        TagDescriptor[] descriptors = this.getTagsForType(TAG);
        ArrayList<TagDescriptor> tagList = new ArrayList<TagDescriptor>(Arrays.asList(descriptors));
        this.addParamTags(methodConstruct, tagList);
        this.addReturnTag(methodConstruct, tagList);
        this.addThrowsTag(methodConstruct, tagList);
        TagDescriptor[] tagArray = new TagDescriptor[tagList.size()];
        tagList.toArray(tagArray);
        this.verify(context, visibility, methodConstruct.getDocComment(), methodConstruct.getTypeParameters(), tagArray, this.getInlineTagsForType(TAG));
    }

    private void addParamTags(SourceMethod srcMethod, List<TagDescriptor> tdList) {
        int pos = this.removeTagPlaceholder("@param", tdList);
        List params = srcMethod.getSourceParameters();
        if (params.size() == 0) {
            return;
        }
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            try {
                TagDescriptor td = (TagDescriptor)TagManager.PARAM_TAG_DEF.copyTo(null);
                SourceVariable p = (SourceVariable)iter.next();
                String paramName = p.getName();
                td.setReference(paramName);
                td.setTemplate("");
                tdList.add(pos++, td);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addReturnTag(SourceMethod srcMethod, List<TagDescriptor> tdList) {
        SourceTypeReference type = srcMethod.getSourceReturnType();
        if (type == null || "void".equals(type.getName())) {
            this.removeTagPlaceholder("@return", tdList);
            return;
        }
        try {
            TagDescriptor td = (TagDescriptor)TagManager.RETURN_TAG_DEF.copyTo(null);
            int pos = this.removeTagPlaceholder("@return", tdList);
            tdList.add(pos++, td);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addThrowsTag(SourceMethod srcMethod, List<TagDescriptor> tdList) {
        List checkedExceptions;
        ArrayList<String> exceptionTags = new ArrayList<String>();
        SourceDocComment comment = srcMethod.getDocComment();
        if (comment != null) {
            Collection c = comment.findExceptionTags();
            Iterator exTagIterator = c.iterator();
            while (exTagIterator.hasNext()) {
                try {
                    SourceDocBlockTag exTag = (SourceDocBlockTag)exTagIterator.next();
                    SourceDocReference ref = exTag.getReference();
                    if (ref == null) continue;
                    JavaHasType hasType = ref.getResolvedObject();
                    if (hasType != null) {
                        JavaType javaType = hasType.getResolvedType();
                        exceptionTags.add(javaType.getName());
                        continue;
                    }
                    exceptionTags.add(exTag.getReferenceText());
                }
                catch (Exception e) {}
            }
        }
        if ((checkedExceptions = srcMethod.getSourceExceptions()).size() + exceptionTags.size() == 0) {
            this.removeTagPlaceholder("@throws", tdList);
            return;
        }
        for (SourceTypeReference t : checkedExceptions) {
            String name = t.getName();
            if (exceptionTags.contains(name)) continue;
            exceptionTags.add(name);
        }
        try {
            int pos = -1;
            for (String name : exceptionTags) {
                TagDescriptor td = (TagDescriptor)TagManager.THROWS_TAG_DEF.copyTo(null);
                td.setReference(name);
                td.setTemplate("");
                pos = pos == -1 ? this.removeTagPlaceholder("@throws", tdList) : pos;
                tdList.add(pos++, td);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int removeTagPlaceholder(String tag, List<TagDescriptor> tdList) {
        TagDescriptor found = this.findByName(tag, tdList);
        if (found == null) {
            return tdList.size();
        }
        int location = tdList.indexOf(found);
        tdList.remove(location);
        return location;
    }

    private TagDescriptor findByName(String name, List<TagDescriptor> list) {
        for (TagDescriptor td : list) {
            if (!td.getName().equals(name)) continue;
            return td;
        }
        return null;
    }

    private TagDescriptor[] getTagsForType(int tagId) {
        switch (tagId) {
            case 2: {
                if (this.fieldTags == null) {
                    this.fieldTags = this.tagsForType(tagId);
                }
                return this.fieldTags;
            }
            case 1: {
                if (this.classTags == null) {
                    this.classTags = this.tagsForType(tagId);
                }
                return this.classTags;
            }
            case 4: {
                if (this.methodTags == null) {
                    this.methodTags = this.tagsForType(tagId);
                }
                return this.methodTags;
            }
            case 8: {
                if (this.constructorTags == null) {
                    this.constructorTags = this.tagsForType(tagId);
                }
                return this.constructorTags;
            }
        }
        return NO_TAG_DESCRIPTORS;
    }

    private TagDescriptor[] tagsForType(int tagId) {
        ArrayList tags = TagManager.getInstance().getTags(tagId);
        return tags.toArray(new TagDescriptor[tags.size()]);
    }

    private TagDescriptor[] getInlineTagsForType(int tagId) {
        switch (tagId) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                ArrayList tags = TagManager.getInstance().getInlineTags(tagId);
                return tags.toArray(new TagDescriptor[tags.size()]);
            }
        }
        return NO_TAG_DESCRIPTORS;
    }
}

