/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.java.JavaBraceProvider;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.scanner.LexerUtilities;
import oracle.jdevimpl.java.util.FoundSymbol;

public class ExpressionFinder
implements JavaTokens {
    private static boolean verboseOutput = false;
    public static final int FILTER_ACCEPT_STAR = 1;
    public static final int FILTER_ACCEPT_BRACES = 0;
    private JavaBraceProvider braceProvider;
    private ReadTextBuffer buffer;
    private static final int kSearchBackwardsGuess = 500;
    private static final double kCandidateDensityGuess = 0.05;
    private static NumberRange left = new NumberRange(0, 0);
    private static NumberRange right = new NumberRange(0, 0);

    public ExpressionFinder(ReadTextBuffer inBuffer, JavaBraceProvider inBraceProvider) {
        this.buffer = inBuffer;
        this.braceProvider = inBraceProvider;
    }

    public ExpressionFinder(ReadTextBuffer inBuffer, LanguageSupport inSupport) {
        this.buffer = inBuffer;
        this.braceProvider = (JavaBraceProvider)inSupport.getBraceProvider();
    }

    private int getSearchStartPoint(int cursorOffset, JavaLexer lexer, LexerToken lexerToken) {
        int searchStartOffset = 0;
        lexer.setPosition(0);
        while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset - 500 < startOffset || tokenValue == 0) {
                return searchStartOffset;
            }
            searchStartOffset = startOffset;
        }
    }

    private int[] createInitialArray() {
        int guessSize = 25;
        if (guessSize < 1) {
            guessSize = 1;
        }
        return new int[guessSize];
    }

    private int[] addToIntArray(int toAdd, int[] array, int nItems) {
        if (nItems == array.length) {
            int newSize = nItems * 2;
            int[] newArray = new int[newSize];
            System.arraycopy(array, 0, newArray, 0, nItems);
            array = newArray;
        }
        array[nItems] = toAdd;
        return array;
    }

    private int getPrecedingToken(int cursorOffset, JavaLexer lexer, LexerToken lexerToken) {
        int initial = this.getSearchStartPoint(cursorOffset, lexer, lexerToken);
        lexer.setPosition(initial);
        int lastToken = 0;
        while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset <= startOffset || tokenValue == 0) {
                return lastToken;
            }
            lastToken = tokenValue;
        }
    }

    public FoundSymbol determinePrimaryStart(int cursorOffset) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = lexer.createLexerToken();
        int[] candidateArray = this.buildPrimaryCandidateArray(cursorOffset, lexer, lexerToken);
        int nCandidates = candidateArray.length;
        if (nCandidates == 0) {
            return null;
        }
        FoundSymbol foundSymbol = null;
        for (int i = 0; i < nCandidates; ++i) {
            int startOffset = candidateArray[i];
            FoundSymbol returnSymbol = this.testThisPrimary(startOffset, cursorOffset, lexer, lexerToken);
            if (returnSymbol == null) continue;
            foundSymbol = returnSymbol;
            break;
        }
        if (foundSymbol == null) {
            return null;
        }
        if (foundSymbol.startOffset > 0 && this.buffer.getChar(foundSymbol.startOffset - 1) == '@') {
            return foundSymbol;
        }
        boolean foundArgs = false;
        lexer.setPosition(foundSymbol.endOffset);
        int tokenValue = this.lex(lexer, lexerToken);
        if (tokenValue == 58) {
            this.skipTypeArguments(lexer, lexerToken, tokenValue);
            tokenValue = this.lex(lexer, lexerToken);
        }
        if (tokenValue == 55) {
            foundArgs = true;
            int endBraceOffset = this.findEndOfBraceMatching(lexerToken.getStartOffset());
            if (endBraceOffset != -1) {
                foundSymbol.endOffset = endBraceOffset;
            }
        }
        if (!foundArgs) {
            lexer.setPosition(foundSymbol.startOffset);
            tokenValue = this.lex(lexer, lexerToken);
            if (tokenValue == 124) {
                this.lex(lexer, lexerToken);
                int nextStart = lexerToken.getStartOffset();
                if (nextStart < foundSymbol.endOffset) {
                    foundSymbol.startOffset = nextStart;
                    foundSymbol.resetString(this.buffer);
                }
            }
        }
        return foundSymbol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void skipTypeArguments(JavaLexer lexer, LexerToken lexerToken, int tokenValue) {
        int typeArgumentsDepth = 1;
        while (true) {
            if ((tokenValue = this.lex(lexer, lexerToken)) == 46) {
                if (--typeArgumentsDepth != 0) continue;
                return;
            }
            if (tokenValue == 58) {
                ++typeArgumentsDepth;
                continue;
            }
            if (tokenValue == 73 ? (typeArgumentsDepth -= 2) == 0 : tokenValue == 0) return;
        }
    }

    private int[] buildPrimaryCandidateArray(int cursorOffset, JavaLexer lexer, LexerToken lexerToken) {
        int searchStartOffset = this.getSearchStartPoint(cursorOffset, lexer, lexerToken);
        int[] candidateArray = this.createInitialArray();
        int nCandidates = 0;
        lexer.setPosition(searchStartOffset);
        boolean identifierCandidate = true;
        boolean parenthesisCandidate = true;
        while (true) {
            boolean parenthesisCandidateToken;
            boolean identifierCandidateToken;
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset < startOffset || tokenValue == 0) break;
            switch (tokenValue) {
                default: {
                    identifierCandidateToken = false;
                    break;
                }
                case 4: 
                case 14: 
                case 124: 
                case 133: 
                case 136: {
                    identifierCandidateToken = true;
                }
            }
            boolean bl = parenthesisCandidateToken = tokenValue == 55;
            if (identifierCandidateToken && identifierCandidate || parenthesisCandidateToken && parenthesisCandidate) {
                candidateArray = this.addToIntArray(startOffset, candidateArray, nCandidates++);
            }
            identifierCandidate = tokenValue != 43 && tokenValue != 124;
            parenthesisCandidate = tokenValue != 4 && tokenValue != 136 && tokenValue != 133;
        }
        if (nCandidates == candidateArray.length) {
            return candidateArray;
        }
        int[] returnArray = new int[nCandidates];
        System.arraycopy(candidateArray, 0, returnArray, 0, nCandidates);
        return returnArray;
    }

    private FoundSymbol testThisPrimary(int primaryStart, int cursorOffset, JavaLexer lexer, LexerToken lexerToken) {
        lexer.setPosition(primaryStart);
        boolean expectingIdentifier = true;
        boolean expectingTypeArguments = false;
        boolean parenPrimary = false;
        block8: while (true) {
            int endBraceOffset;
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            int endOffset = lexerToken.getEndOffset();
            if (cursorOffset < startOffset) {
                return null;
            }
            if (expectingTypeArguments) {
                expectingTypeArguments = false;
                if (tokenValue == 58) {
                    this.skipTypeArguments(lexer, lexerToken, tokenValue);
                    continue;
                }
            }
            if (expectingIdentifier) {
                if (tokenValue == 124) {
                    expectingIdentifier = true;
                    expectingTypeArguments = true;
                    continue;
                }
                switch (tokenValue) {
                    default: {
                        return null;
                    }
                    case 55: {
                        endBraceOffset = this.findEndOfBraceMatching(startOffset);
                        if (endBraceOffset == -1) {
                            return null;
                        }
                        if (cursorOffset <= endBraceOffset) {
                            return null;
                        }
                        lexer.setPosition(endBraceOffset);
                        expectingIdentifier = false;
                        parenPrimary = true;
                        continue block8;
                    }
                    case 4: 
                    case 14: 
                    case 133: 
                    case 136: 
                }
                if (startOffset <= cursorOffset && cursorOffset <= endOffset) {
                    return new FoundSymbol(this.buffer, primaryStart, endOffset);
                }
                expectingIdentifier = false;
                parenPrimary = false;
                continue;
            }
            switch (tokenValue) {
                case 43: {
                    if (cursorOffset < endOffset) {
                        return null;
                    }
                    expectingIdentifier = true;
                    expectingTypeArguments = true;
                    continue block8;
                }
                case 49: 
                case 50: 
                case 55: {
                    if (parenPrimary && tokenValue != 50) {
                        return null;
                    }
                    endBraceOffset = this.findEndOfBraceMatching(startOffset);
                    if (endBraceOffset == -1) {
                        return null;
                    }
                    if (cursorOffset < endBraceOffset) {
                        return null;
                    }
                    if (cursorOffset == endBraceOffset) {
                        return new FoundSymbol(this.buffer, primaryStart, endBraceOffset);
                    }
                    lexer.setPosition(endBraceOffset);
                    expectingIdentifier = false;
                    continue block8;
                }
            }
            break;
        }
        return null;
    }

    public int isCursorPartOfCodeUsage(int cursorOffset) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        lexer.setSkipComments(false);
        LexerToken lexerToken = lexer.createLexerToken();
        int unmatchedBraces = 0;
        int lastTokenStartOffset = 0;
        while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            int endOffset = lexerToken.getEndOffset();
            if (cursorOffset <= startOffset || tokenValue == 0) {
                return unmatchedBraces > 0 ? lastTokenStartOffset : -1;
            }
            if (tokenValue == 49) {
                ++unmatchedBraces;
            } else if (tokenValue == 70) {
                if (unmatchedBraces > 0) {
                    --unmatchedBraces;
                }
            } else if (tokenValue == 24 || tokenValue == 14) {
                if (startOffset < cursorOffset && cursorOffset <= endOffset) {
                    return -1;
                }
            } else if (tokenValue == 79) {
                if (1 == this.isCursorPartOfAnnotationUsage(startOffset, cursorOffset)) {
                    return startOffset;
                }
            } else if (!ExpressionFinder.isIdentifierPrefix(tokenValue) && startOffset < cursorOffset && cursorOffset < endOffset) {
                return -1;
            }
            lastTokenStartOffset = startOffset;
        }
    }

    public FoundSymbol determinePrimaryPrefix(int cursorOffset, int filterMask) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = lexer.createLexerToken();
        int[] candidateArray = this.buildPrimaryCandidateArray(cursorOffset, lexer, lexerToken);
        int nCandidates = candidateArray.length;
        if (nCandidates == 0) {
            return null;
        }
        FoundSymbol foundSymbol = null;
        for (int i = 0; i < nCandidates; ++i) {
            int startOffset = candidateArray[i];
            FoundSymbol returnSymbol = this.testThisPrimaryPrefix(startOffset, cursorOffset, lexer, lexerToken, filterMask);
            if (returnSymbol == null) continue;
            foundSymbol = returnSymbol;
        }
        return foundSymbol;
    }

    private FoundSymbol testThisPrimaryPrefix(int primaryStart, int cursorOffset, JavaLexer lexer, LexerToken lexerToken, int filterMask) {
        boolean acceptBraces = (filterMask & 0) == 0;
        boolean acceptStar = (filterMask & 1) == 1;
        lexer.setPosition(primaryStart);
        int lastDotEndOffset = -1;
        boolean justSawDot = true;
        block4: while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            int endOffset = lexerToken.getEndOffset();
            if (justSawDot) {
                boolean good = false;
                if (cursorOffset <= startOffset) break;
                if (tokenValue == 55) {
                    int endBraceOffset = this.findEndOfBraceMatching(startOffset);
                    if (endBraceOffset == -1) {
                        return null;
                    }
                    if (cursorOffset <= endBraceOffset) {
                        return null;
                    }
                    lexer.setPosition(endBraceOffset);
                    justSawDot = false;
                    continue;
                }
                if (tokenValue == 63 && acceptStar) {
                    if (cursorOffset == endOffset) break;
                    return null;
                }
                if (tokenValue == 124) continue;
                if (!ExpressionFinder.isIdentifierPrefix(tokenValue) && tokenValue != 14) {
                    return null;
                }
                if (cursorOffset <= endOffset) break;
                justSawDot = false;
                continue;
            }
            switch (tokenValue) {
                case 43: {
                    if (cursorOffset == startOffset) {
                        return null;
                    }
                    justSawDot = true;
                    lastDotEndOffset = endOffset;
                    if (cursorOffset != endOffset) continue block4;
                    break block4;
                }
                case 49: 
                case 50: 
                case 55: {
                    if (acceptBraces) {
                        int endBraceOffset = this.findEndOfBraceMatching(startOffset);
                        if (endBraceOffset == -1) {
                            return null;
                        }
                        if (cursorOffset <= endBraceOffset) {
                            return null;
                        }
                        lexer.setPosition(endBraceOffset);
                        justSawDot = false;
                        break;
                    }
                }
                default: {
                    return null;
                }
            }
        }
        if (lastDotEndOffset == -1) {
            return null;
        }
        return new FoundSymbol(this.buffer, primaryStart, lastDotEndOffset);
    }

    private boolean isConstructorInvocation(int primaryStart, int length) {
        int primaryEnd = primaryStart + length;
        JavaLexer lexer = new JavaLexer();
        LexerToken lexerToken = lexer.createLexerToken();
        lexer.setTextBuffer(this.buffer);
        lexer.setPosition(primaryStart);
        boolean newContext = false;
        boolean sawParen = false;
        int tokenValue;
        while ((tokenValue = this.lex(lexer, lexerToken)) != 0) {
            int startOffset = lexerToken.getStartOffset();
            if (primaryEnd <= startOffset) {
                return newContext;
            }
            switch (tokenValue) {
                case 124: {
                    newContext = true;
                    break;
                }
                case 43: {
                    if (!sawParen) break;
                    newContext = false;
                    break;
                }
                case 55: {
                    int rparenEnd = this.findEndOfBraceMatching(startOffset);
                    if (rparenEnd == -1 || primaryEnd <= rparenEnd) {
                        throw new RuntimeException("Unmatched in constructor query.");
                    }
                    lexer.setPosition(rparenEnd);
                    sawParen = true;
                }
            }
        }
        return false;
    }

    public boolean isMethodDeclaration(FoundSymbol invocation) {
        String invokeString = invocation.string;
        if (invokeString.indexOf(40) != -1 || invokeString.indexOf(46) != -1) {
            return false;
        }
        int cursorOffset = invocation.startOffset;
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = lexer.createLexerToken();
        lexer.setPosition(cursorOffset);
        int thisToken = lexer.lex(lexerToken);
        if (thisToken != 4) {
            return false;
        }
        int lastToken = this.getPrecedingToken(cursorOffset, lexer, lexerToken);
        if (lastToken == 4 || lastToken == 141) {
            return true;
        }
        return ExpressionFinder.isPrimitiveType(lastToken);
    }

    public boolean isAnnotation(FoundSymbol invocation) {
        String invokeString = invocation.string;
        if (invokeString.indexOf(40) != -1) {
            return false;
        }
        int cursorOffset = invocation.startOffset;
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = lexer.createLexerToken();
        lexer.setPosition(cursorOffset);
        int thisToken = lexer.lex(lexerToken);
        if (thisToken != 4) {
            return false;
        }
        int lastToken = this.getPrecedingToken(cursorOffset, lexer, lexerToken);
        return lastToken == 79;
    }

    public FoundSymbol determineArgumentInvocation(int cursorOffset, int[] outArgumentIndex) {
        int checkPos;
        outArgumentIndex[0] = -1;
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = lexer.createLexerToken();
        int[] candidateArray = this.buildArgumentsCandidateArray(cursorOffset, lexer, lexerToken);
        int nCandidates = candidateArray.length;
        int foundOffset = -1;
        for (int i = 0; i < nCandidates; ++i) {
            boolean yup;
            int startOffset = candidateArray[i];
            int argumentIndex = this.testThisArguments(startOffset, cursorOffset, lexer, lexerToken);
            boolean bl = yup = argumentIndex != -1;
            if (!yup) continue;
            outArgumentIndex[0] = argumentIndex;
            foundOffset = startOffset;
        }
        if (foundOffset == -1) {
            return null;
        }
        int inTypeArguments = 0;
        for (checkPos = foundOffset - 1; checkPos >= 0; --checkPos) {
            char c = this.buffer.getChar(checkPos);
            if (inTypeArguments > 0) {
                if (c == '<') {
                    --inTypeArguments;
                    continue;
                }
                if (c != '>') continue;
                ++inTypeArguments;
                continue;
            }
            if (c == '>') {
                ++inTypeArguments;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) break;
        }
        FoundSymbol primary = this.determinePrimaryStart(checkPos);
        return primary;
    }

    private int[] buildArgumentsCandidateArray(int cursorOffset, JavaLexer lexer, LexerToken lexerToken) {
        int searchStartOffset = this.getSearchStartPoint(cursorOffset, lexer, lexerToken);
        int[] candidateArray = this.createInitialArray();
        int nCandidates = 0;
        lexer.setPosition(searchStartOffset);
        boolean functionParamPrefix = false;
        while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset <= startOffset || tokenValue == 0) break;
            if (tokenValue == 55 && functionParamPrefix) {
                candidateArray = this.addToIntArray(startOffset, candidateArray, nCandidates++);
            }
            functionParamPrefix = tokenValue == 4 || tokenValue == 136 || tokenValue == 133 || tokenValue == 46 || tokenValue == 73;
        }
        if (nCandidates == candidateArray.length) {
            return candidateArray;
        }
        int[] returnArray = new int[nCandidates];
        System.arraycopy(candidateArray, 0, returnArray, 0, nCandidates);
        return returnArray;
    }

    private int testThisArguments(int parenStart, int cursorOffset, JavaLexer lexer, LexerToken lexerToken) {
        lexer.setPosition(parenStart);
        this.lex(lexer, lexerToken);
        if (lexerToken.getEndOffset() == cursorOffset) {
            return 0;
        }
        int commaCount = 0;
        block8: while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset <= startOffset) {
                return commaCount;
            }
            switch (tokenValue) {
                case 0: 
                case 70: 
                case 71: 
                case 72: 
                case 75: {
                    return -1;
                }
                case 39: {
                    ++commaCount;
                    break;
                }
            }
            switch (tokenValue) {
                case 49: 
                case 50: {
                    int endBraceOffset = this.findEndOfBraceMatching(startOffset);
                    if (endBraceOffset == -1) continue block8;
                    if (startOffset < cursorOffset && cursorOffset < endBraceOffset) {
                        return commaCount;
                    }
                    lexer.setPosition(endBraceOffset);
                    break;
                }
                case 55: {
                    int endBraceOffset = this.findEndOfBraceMatching(startOffset);
                    if (endBraceOffset == -1) {
                        return -1;
                    }
                    if (startOffset < cursorOffset && cursorOffset < endBraceOffset) {
                        return -1;
                    }
                    lexer.setPosition(endBraceOffset);
                    break;
                }
            }
        }
    }

    public int tokenPrecedingExtends(int cursorOffset, String[] typeName) {
        int precedingToken = 0;
        typeName[0] = null;
        JavaLexer lexer = new JavaLexer();
        LexerToken lexerToken = lexer.createLexerToken();
        lexer.setTextBuffer(this.buffer);
        int searchStartPoint = this.getSearchStartPoint(cursorOffset, lexer, lexerToken);
        lexer.setPosition(searchStartPoint);
        boolean grabNextIdentifier = false;
        int genericDepth = 0;
        while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset <= startOffset || tokenValue == 0) {
                return genericDepth > 0 ? 58 : precedingToken;
            }
            switch (tokenValue) {
                case 103: {
                    precedingToken = 103;
                    genericDepth = 0;
                    break;
                }
                case 121: {
                    precedingToken = 121;
                    genericDepth = 0;
                    break;
                }
                case 58: {
                    ++genericDepth;
                    break;
                }
                case 46: {
                    --genericDepth;
                    break;
                }
                case 73: {
                    genericDepth -= 2;
                    break;
                }
                case 49: 
                case 75: {
                    genericDepth = 0;
                    precedingToken = 0;
                    break;
                }
                case 4: {
                    if (!grabNextIdentifier) break;
                    int endOffset = lexerToken.getEndOffset();
                    int length = endOffset - startOffset;
                    typeName[0] = this.buffer.getString(startOffset, length);
                    break;
                }
            }
            grabNextIdentifier = tokenValue == 103 || tokenValue == 121;
        }
    }

    public int isCursorPartOfQualifiedNameUsage(int cursorOffset) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = lexer.createLexerToken();
        for (int startOffset : this.buildQualifiedNameCandidateArray(cursorOffset, lexer, lexerToken)) {
            boolean yup = this.testThisQualifiedNameUsage(startOffset, cursorOffset, lexer, lexerToken);
            if (!yup) continue;
            return startOffset;
        }
        return -1;
    }

    private int[] buildQualifiedNameCandidateArray(int cursorOffset, JavaLexer lexer, LexerToken lexerToken) {
        int searchStartOffset = this.getSearchStartPoint(cursorOffset, lexer, lexerToken);
        int[] candidateArray = this.createInitialArray();
        int nCandidates = 0;
        lexer.setPosition(searchStartOffset);
        while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset < startOffset || tokenValue == 0) break;
            switch (tokenValue) {
                case 79: 
                case 110: 
                case 117: 
                case 118: 
                case 124: 
                case 125: 
                case 137: 
                case 138: {
                    candidateArray = this.addToIntArray(startOffset, candidateArray, nCandidates++);
                    break;
                }
            }
        }
        if (nCandidates == candidateArray.length) {
            return candidateArray;
        }
        int[] returnArray = new int[nCandidates];
        System.arraycopy(candidateArray, 0, returnArray, 0, nCandidates);
        return returnArray;
    }

    private boolean testThisQualifiedNameUsage(int usageStart, int cursorOffset, JavaLexer lexer, LexerToken lexerToken) {
        lexer.setPosition(usageStart);
        int firstToken = this.lex(lexer, lexerToken);
        int keywordEndOffset = lexerToken.getEndOffset();
        switch (firstToken) {
            case 79: {
                if (cursorOffset == keywordEndOffset) {
                    return true;
                }
            }
            case 110: 
            case 117: 
            case 118: 
            case 124: 
            case 125: 
            case 137: 
            case 138: {
                if (cursorOffset > keywordEndOffset) break;
                return false;
            }
            default: {
                throw new RuntimeException("Not a qualified name usage!");
            }
        }
        boolean expectingIdentifier = true;
        int genericDepth = 0;
        while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            int endOffset = lexerToken.getEndOffset();
            if (firstToken == 137) {
                if (tokenValue != 124) {
                    return false;
                }
                if (cursorOffset <= endOffset) {
                    return false;
                }
                firstToken = 124;
                continue;
            }
            if (expectingIdentifier) {
                if (cursorOffset <= startOffset) {
                    return true;
                }
                if (!(ExpressionFinder.isIdentifierPrefix(tokenValue) || genericDepth > 0 && tokenValue == 69)) {
                    return false;
                }
                if (cursorOffset <= endOffset) {
                    return true;
                }
            } else {
                switch (tokenValue) {
                    case 39: {
                        if (firstToken != 117 && firstToken != 138) {
                            return false;
                        }
                    }
                    case 43: {
                        if (cursorOffset == startOffset) {
                            return false;
                        }
                        if (cursorOffset != endOffset) break;
                        return true;
                    }
                    case 110: {
                        if (genericDepth > 0) break;
                        return false;
                    }
                    case 58: {
                        ++genericDepth;
                        break;
                    }
                    case 73: {
                        --genericDepth;
                    }
                    case 46: {
                        --genericDepth;
                        expectingIdentifier = !expectingIdentifier;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            expectingIdentifier = !expectingIdentifier;
        }
    }

    public boolean isCursorPartOfLabelUsage(int cursorOffset) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        LexerToken lexerToken = lexer.createLexerToken();
        for (int startOffset : this.buildLabelCandidateArray(cursorOffset, lexer, lexerToken)) {
            boolean yup = this.testThisLabelUsage(startOffset, cursorOffset, lexer, lexerToken);
            if (!yup) continue;
            return true;
        }
        return false;
    }

    private int[] buildLabelCandidateArray(int cursorOffset, JavaLexer lexer, LexerToken lexerToken) {
        int searchStartOffset = this.getSearchStartPoint(cursorOffset, lexer, lexerToken);
        int[] candidateArray = this.createInitialArray();
        int nCandidates = 0;
        lexer.setPosition(searchStartOffset);
        while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset < startOffset || tokenValue == 0) break;
            switch (tokenValue) {
                case 98: 
                case 105: {
                    candidateArray = this.addToIntArray(startOffset, candidateArray, nCandidates++);
                    break;
                }
            }
        }
        if (nCandidates == candidateArray.length) {
            return candidateArray;
        }
        int[] returnArray = new int[nCandidates];
        System.arraycopy(candidateArray, 0, returnArray, 0, nCandidates);
        return returnArray;
    }

    private boolean testThisLabelUsage(int usageStart, int cursorOffset, JavaLexer lexer, LexerToken lexerToken) {
        lexer.setPosition(usageStart);
        this.lex(lexer, lexerToken);
        int keywordEnd = lexerToken.getEndOffset();
        if (cursorOffset <= keywordEnd) {
            return false;
        }
        int nextToken = this.lex(lexer, lexerToken);
        int nextTokenStart = lexerToken.getStartOffset();
        if (cursorOffset < nextTokenStart) {
            return true;
        }
        if (nextToken == 75 && cursorOffset == nextTokenStart) {
            return true;
        }
        int nextTokenEnd = lexerToken.getEndOffset();
        return ExpressionFinder.isIdentifierPrefix(nextToken) && cursorOffset <= nextTokenEnd;
    }

    public int isCursorPartOfAnnotationUsage(int tokenOffset, int cursorOffset) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        lexer.setSkipComments(true);
        lexer.setPosition(tokenOffset);
        LexerToken lexerToken = lexer.createLexerToken();
        int state = 0;
        while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset <= startOffset || tokenValue == 0) break;
            switch (state) {
                case 0: {
                    if (tokenValue != 79) break;
                    ++state;
                    break;
                }
                case 1: {
                    if (tokenValue != 4) {
                        return 0;
                    }
                    ++state;
                    break;
                }
                case 2: {
                    if (tokenValue == 43) {
                        --state;
                        break;
                    }
                    if (tokenValue != 55) {
                        return 0;
                    }
                    int rightBrace = this.findEndOfBraceMatching(startOffset);
                    if (rightBrace < 0) {
                        return 0;
                    }
                    if (cursorOffset < rightBrace) {
                        return 1 + this.isCursorPartOfAnnotationUsage(startOffset, cursorOffset);
                    }
                    return 0;
                }
            }
        }
        return 0;
    }

    public boolean isCursorAtAnnotationElementName(int tokenOffset, int cursorOffset) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        lexer.setSkipComments(true);
        lexer.setPosition(tokenOffset);
        LexerToken lexerToken = lexer.createLexerToken();
        int state = 0;
        boolean expectingElementName = false;
        int curlyDepth = 0;
        block5: while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset <= startOffset || tokenValue == 0) break;
            switch (state) {
                case 0: {
                    if (tokenValue != 55) break;
                    ++state;
                    expectingElementName = true;
                    break;
                }
                case 1: {
                    if (tokenValue != 33 && tokenValue != 43) continue block5;
                    ++state;
                    expectingElementName = false;
                    break;
                }
                case 2: {
                    if (tokenValue == 49) {
                        ++curlyDepth;
                        break;
                    }
                    if (tokenValue == 70) {
                        --curlyDepth;
                        break;
                    }
                    if (tokenValue != 39 || curlyDepth != 0) continue block5;
                    state = 1;
                    expectingElementName = true;
                    break;
                }
            }
        }
        return expectingElementName;
    }

    public LexerToken isCursorAtAnnotationElementValue(int tokenOffset, int cursorOffset, boolean isCompactForm) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        lexer.setSkipComments(true);
        lexer.setPosition(tokenOffset);
        LexerToken lexerToken = lexer.createLexerToken();
        int state = 0;
        boolean expectingValue = false;
        int lastToken = -1;
        int lastTokenStart = 0;
        int lastTokenEnd = 0;
        int curlyDepth = 0;
        block5: while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset <= startOffset || tokenValue == 0) break;
            lastToken = tokenValue;
            lastTokenStart = startOffset;
            lastTokenEnd = lexerToken.getEndOffset();
            switch (state) {
                case 0: {
                    if (tokenValue != 55) break;
                    if (isCompactForm) {
                        state += 2;
                        expectingValue = true;
                        break;
                    }
                    ++state;
                    break;
                }
                case 1: {
                    expectingValue = false;
                    if (tokenValue != 33) break;
                    ++state;
                    expectingValue = true;
                    break;
                }
                case 2: {
                    if (tokenValue == 49) {
                        expectingValue = true;
                        ++curlyDepth;
                        break;
                    }
                    if (tokenValue == 70) {
                        expectingValue = true;
                        --curlyDepth;
                        break;
                    }
                    if (tokenValue == 39) {
                        expectingValue = true;
                        if (curlyDepth != 0 || isCompactForm) continue block5;
                        state = 1;
                        break;
                    }
                    if (tokenValue != 43) break;
                    expectingValue = false;
                    break;
                }
            }
        }
        if (expectingValue) {
            final int finalToken = lastToken;
            final int finalStart = lastTokenStart;
            final int finalEnd = lastTokenEnd;
            return new LexerToken(){

                public int getToken() {
                    return finalToken;
                }

                public int getStartOffset() {
                    return finalStart;
                }

                public int getEndOffset() {
                    return finalEnd;
                }
            };
        }
        return null;
    }

    public String getAnnotationName(int tokenOffset) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        lexer.setSkipComments(true);
        lexer.setPosition(tokenOffset);
        LexerToken lexerToken = lexer.createLexerToken();
        int tokenValue = this.lex(lexer, lexerToken);
        if (tokenValue != 79) {
            return null;
        }
        tokenValue = this.lex(lexer, lexerToken);
        if (tokenValue == 4) {
            int startOffset = lexerToken.getStartOffset();
            int endOffset = lexerToken.getEndOffset();
            int length = endOffset - startOffset;
            return this.buffer.getString(startOffset, length);
        }
        return null;
    }

    public String getAnnotationElementNameAtCursor(int tokenOffset, int cursorOffset) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        lexer.setSkipComments(true);
        lexer.setPosition(tokenOffset);
        LexerToken lexerToken = lexer.createLexerToken();
        int state = 0;
        String elementName = null;
        int curlyDepth = 0;
        boolean firstElement = true;
        while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset <= startOffset || tokenValue == 0) break;
            switch (state) {
                case 0: {
                    if (tokenValue != 55) break;
                    ++state;
                    break;
                }
                case 1: {
                    if (tokenValue == 49) {
                        ++curlyDepth;
                    } else if (tokenValue == 70) {
                        --curlyDepth;
                    } else if (tokenValue == 39) {
                        if (curlyDepth == 0) {
                            elementName = null;
                        }
                    } else if ((tokenValue == 4 || tokenValue >= 96 && tokenValue <= 146) && elementName == null) {
                        int endOffset = lexerToken.getEndOffset();
                        int length = endOffset - startOffset;
                        elementName = this.buffer.getString(startOffset, length);
                    }
                    if (firstElement && elementName == null && tokenValue != 72 && tokenValue != 39) {
                        elementName = "value";
                    }
                    firstElement = false;
                    break;
                }
            }
        }
        return elementName;
    }

    public String getAnnotationElementValuePrefix(int tokenOffset, int cursorOffset, boolean isCompactForm) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        lexer.setSkipComments(true);
        lexer.setPosition(tokenOffset);
        LexerToken lexerToken = lexer.createLexerToken();
        int state = 0;
        String prefix = "";
        int curlyDepth = 0;
        block5: while (true) {
            int tokenValue = this.lex(lexer, lexerToken);
            int startOffset = lexerToken.getStartOffset();
            if (cursorOffset <= startOffset || tokenValue == 0) break;
            switch (state) {
                case 0: {
                    if (tokenValue != 55) break;
                    if (isCompactForm) {
                        state += 2;
                        break;
                    }
                    ++state;
                    break;
                }
                case 1: {
                    if (tokenValue != 33) break;
                    ++state;
                    break;
                }
                case 2: {
                    if (tokenValue == 4 || tokenValue == 14) {
                        int startName = lexerToken.getStartOffset();
                        int endName = Math.min(cursorOffset, lexerToken.getEndOffset());
                        prefix = this.buffer.getString(startName, endName - startName);
                        break;
                    }
                    prefix = "";
                    if (tokenValue == 49) {
                        ++curlyDepth;
                        break;
                    }
                    if (tokenValue == 70) {
                        --curlyDepth;
                        break;
                    }
                    if (tokenValue != 39 || curlyDepth != 0 || isCompactForm) continue block5;
                    state = 1;
                    break;
                }
            }
        }
        return prefix;
    }

    public List<String> getAnyTypeArguments(int tokenOffset) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(this.buffer);
        lexer.setSkipComments(true);
        lexer.setPosition(tokenOffset);
        LexerToken lexerToken = lexer.createLexerToken();
        int state = 0;
        int typeArgStart = 0;
        int angleDepth = 0;
        ArrayList<String> typeArgList = new ArrayList<String>();
        while (true) {
            int tokenValue;
            if ((tokenValue = this.lex(lexer, lexerToken)) == 0) {
                typeArgList.clear();
                return typeArgList;
            }
            switch (state) {
                case 0: {
                    if (tokenValue != 58) {
                        return typeArgList;
                    }
                    ++state;
                    ++angleDepth;
                    typeArgStart = lexerToken.getEndOffset();
                    break;
                }
                case 1: {
                    boolean foundTypeArg = false;
                    if (tokenValue == 58) {
                        ++angleDepth;
                    } else if (tokenValue == 46) {
                        if (--angleDepth <= 0) {
                            foundTypeArg = true;
                        }
                    } else if (tokenValue == 73) {
                        if ((angleDepth -= 2) <= 0) {
                            foundTypeArg = true;
                        }
                    } else if (angleDepth == 1 && tokenValue == 39) {
                        foundTypeArg = true;
                    }
                    if (!foundTypeArg) break;
                    String typeArg = this.buffer.getString(typeArgStart, lexerToken.getEndOffset() - typeArgStart - 1);
                    typeArgList.add(typeArg.trim());
                    if (tokenValue == 46 || tokenValue == 73) {
                        return typeArgList;
                    }
                    typeArgStart = lexerToken.getEndOffset() + 1;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findEndOfBraceMatching(int leftBraceStartOffset) {
        NumberRange numberRange = left;
        synchronized (numberRange) {
            int braceType = this.braceProvider.isPartOfBrace(leftBraceStartOffset, left);
            if (braceType == -1) {
                return -1;
            }
            int matchResult = this.braceProvider.findMatchingBrace(braceType, left, right);
            if (matchResult == 3) {
                return -1;
            }
            return ExpressionFinder.right.end;
        }
    }

    private int lex(JavaLexer lexer, LexerToken lexerToken) {
        int tokenValue = lexer.lex(lexerToken);
        if (verboseOutput) {
            int startOffset = lexerToken.getStartOffset();
            int endOffset = lexerToken.getEndOffset();
            String tokenString = this.buffer.getString(startOffset, endOffset - startOffset);
            System.out.print(tokenString + " (" + startOffset + "," + endOffset + ") ");
        }
        return tokenValue;
    }

    private static boolean isLiteral(int token) {
        return 8 <= token && token < 16;
    }

    private static boolean isPrimitiveType(int token) {
        return ExpressionFinder.isKeyword(token) && PrimitiveType.PRIMITIVE_lookup[token - 96] != null;
    }

    private static boolean isModifier(int token) {
        return ExpressionFinder.isKeyword(token) && LexerUtilities.kw2modifier((int)token) != 0;
    }

    private static boolean isKeyword(int token) {
        return 96 <= token && token < 146;
    }

    private static boolean isIdentifierPrefix(int token) {
        return token == 4 || ExpressionFinder.isKeyword(token) || token == 12 || token == 15;
    }
}

