/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.ide.ceditor.insight.BasicInsight;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.util.filter.AssignableFilter;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.parser.java.v2.util.filter.OrFilter;
import oracle.jdevimpl.java.insight.AnnotationSymFilter;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.IntConstantFilter;
import oracle.jdevimpl.java.insight.RegularProvider;

final class SmartProvider
extends RegularProvider {
    private InsightContext context;

    SmartProvider(BasicInsight insight) {
        super(insight);
    }

    @Override
    protected JavaFilter getJavaFilter(BasicEditorPane editorPane) {
        InsightContext context = this.createInsightContext(editorPane);
        JavaFilter smartFilter = this.getFilter(context);
        return smartFilter;
    }

    static SourceElement getLeftElem(SourceElement sourceElement, int offset) {
        int lStart = sourceElement.getStartOffset();
        if (offset <= lStart) {
            return null;
        }
        SourceElement ret = sourceElement;
        List children = sourceElement.getChildren();
        for (SourceElement child : children) {
            SourceElement candidate = SmartProvider.getLeftElem(child, offset);
            if (candidate == null) continue;
            ret = candidate;
        }
        return ret;
    }

    private static String getAdjustedText(SourceElement el, int offs) {
        String res = el.getText();
        if (offs > el.getStartOffset() && offs < el.getEndOffset()) {
            res = res.substring(0, offs - el.getStartOffset());
        }
        return res;
    }

    private JavaFilter checkAssign(JavaHasType tp, String cmm) {
        if ((cmm = cmm.trim()).endsWith(";")) {
            return null;
        }
        if (cmm.endsWith(",")) {
            return null;
        }
        int equalsIndex = cmm.indexOf(61);
        if (equalsIndex != -1) {
            JavaType javaType;
            if (cmm.substring(equalsIndex + 1).trim().startsWith("new")) {
                boolean makeFilter;
                block11: {
                    boolean bl = makeFilter = (cmm = cmm.substring(equalsIndex + 1).trim().substring(3).trim()).length() == 0;
                    if (!makeFilter && Character.isJavaIdentifierStart(cmm.charAt(0))) {
                        for (int x = 1; x < cmm.length(); ++x) {
                            char c = cmm.charAt(x);
                            if (c == '.' || Character.isJavaIdentifierPart(c)) {
                                continue;
                            }
                            break block11;
                        }
                        makeFilter = true;
                    }
                }
                if (makeFilter) {
                    JavaType javaType2 = tp.getResolvedType();
                    return javaType2 == null ? null : new AssignableFilter(javaType2, 2);
                }
            } else {
                if (cmm.endsWith("[")) {
                    JavaClass intType = this.context.getProvider().getClass("int");
                    return new AssignableFilter((JavaType)intType, 1);
                }
                if (cmm.endsWith("(")) {
                    JavaType javaType3 = tp.getResolvedType();
                    return javaType3 == null ? null : new AssignableFilter(javaType3, 3);
                }
            }
            return (javaType = tp.getResolvedType()) == null ? null : new AssignableFilter(javaType, 1);
        }
        return null;
    }

    private static JavaFilter lookForCaseLabel(SourceElement el) {
        SourceElement sel;
        JavaType switchType = null;
        for (sel = el; sel != null; sel = sel.getParent()) {
            if (sel.getSymbolKind() != 41) continue;
            SourceSwitchStatement sss = (SourceSwitchStatement)sel;
            switchType = sss.getControlExpression().getResolvedType();
            break;
        }
        for (sel = el; sel != null; sel = sel.getParent()) {
            SourceSwitchLabel lbl;
            if (sel.getSymbolKind() != 23 || !(lbl = (SourceSwitchLabel)sel).getText().startsWith("case")) continue;
            if (switchType != null && switchType.isEnum()) {
                return new AssignableFilter(switchType);
            }
            return new IntConstantFilter();
        }
        return null;
    }

    private JavaFilter lookForDeclaration(SourceElement el, int offset) {
        SourceLocalVariable slv = null;
        for (SourceElement sel = el; sel != null; sel = sel.getParent()) {
            if (sel.getSymbolKind() == 17) {
                slv = (SourceLocalVariable)sel;
                continue;
            }
            if (sel.getSymbolKind() != 18) continue;
            if (slv == null) {
                return null;
            }
            SourceLocalVariableDeclaration sld = (SourceLocalVariableDeclaration)sel;
            SourceElement parent = sld.getParent();
            String dString = parent.getSymbolKind() == 38 ? SmartProvider.getAdjustedText(parent, offset) : SmartProvider.getAdjustedText((SourceElement)sld, offset);
            return this.checkAssign((JavaHasType)slv, dString);
        }
        return null;
    }

    private static JavaFilter lookForInfixExpression(SourceElement el, int offset) {
        block3: for (SourceElement sel = el; sel != null; sel = sel.getParent()) {
            if (sel.getSymbolKind() != 50) continue;
            SourceInfixExpression sif = (SourceInfixExpression)sel;
            switch (sif.getOperatorCode()) {
                case 20: 
                case 21: 
                case 22: 
                case 25: 
                case 30: 
                case 42: {
                    SourceExpression fop;
                    if (offset < sif.getEndOffset() || (fop = sif.getFirstOperand()) == null) continue block3;
                    JavaType ttp = fop.getResolvedType();
                    return new AssignableFilter(ttp, 1);
                }
            }
        }
        return null;
    }

    private static int getArgumentPosition(SourceListExpression slist, int offset) {
        int res = 0;
        int cur = 0;
        for (SourceElement el : slist.getOperands()) {
            if (el.getEndOffset() < offset) {
                res = cur;
            }
            ++cur;
        }
        String adjt = SmartProvider.getAdjustedText((SourceElement)slist, offset).trim();
        if (adjt.endsWith(",")) {
            ++res;
        }
        return res;
    }

    private static JavaFilter findPossibleParameterTypes(SourceListExpression sourceListExpression, JavaClass javaClass, String name, int parameterIndex, boolean isCast) {
        HashSet<JavaType> validTypes = new HashSet<JavaType>();
        while (javaClass != null) {
            Iterator it = name != null ? javaClass.getMethods(name).iterator() : javaClass.getDeclaredConstructors().iterator();
            while (it.hasNext()) {
                JavaMethod meth = (JavaMethod)it.next();
                JavaType[] parameterTypes = meth.getParameterTypes();
                if (parameterIndex >= parameterTypes.length) continue;
                boolean isok = true;
                for (int i = 0; i < parameterIndex; ++i) {
                    SourceExpression sourceExpression = sourceListExpression.getOperandAt(i);
                    JavaType resolvedType = sourceExpression.getResolvedType();
                    JavaType javaType = parameterTypes[i];
                    if (javaType == null) continue;
                    isok &= javaType.isAssignableFrom(resolvedType);
                }
                if (!isok) continue;
                JavaType javaType = parameterTypes[parameterIndex];
                validTypes.add(javaType);
            }
            JavaType javaType = javaClass.getSuperclass();
            if (name != null && javaType != null) {
                javaClass = javaType.getTypeErasure();
                continue;
            }
            javaClass = null;
        }
        if (validTypes.isEmpty()) {
            return null;
        }
        JavaFilter[] filters = new JavaFilter[validTypes.size()];
        int require = isCast ? 2 : 1;
        int i = 0;
        for (JavaType javaType : validTypes) {
            filters[i++] = new AssignableFilter(javaType, require);
        }
        return new OrFilter(filters);
    }

    private static JavaFilter lookForMethodParameter(SourceElement el, int offset) {
        SourceListExpression slist = null;
        for (SourceElement sel = el; sel != null; sel = sel.getParent()) {
            if (sel.getSymbolKind() == 51) {
                if (offset > sel.getEndOffset()) continue;
                slist = (SourceListExpression)sel;
                continue;
            }
            if (sel.getSymbolKind() != 53 && sel.getSymbolKind() != 55 || offset >= sel.getEndOffset()) continue;
            if (slist == null) {
                return null;
            }
            int paramindex = SmartProvider.getArgumentPosition(slist, offset);
            SourceExpression sex = slist.getOperandAt(paramindex);
            boolean inCast = false;
            if (sex != null && (sex.getSymbolKind() == 61 || sex.getSymbolKind() == 59) && offset < sex.getEndOffset()) {
                inCast = true;
            }
            SourceInvokeExpression mcall = (SourceInvokeExpression)sel;
            String mname = null;
            JavaClass cls = null;
            if (mcall instanceof SourceMethodCallExpression) {
                SourceMethodCallExpression smc = (SourceMethodCallExpression)mcall;
                mname = smc.getName();
                JavaHasType lhs = mcall.getResolvedLhs();
                if (lhs != null) {
                    JavaType lhsResolved = lhs.getResolvedType();
                    if (lhsResolved != null) {
                        cls = lhsResolved.getTypeErasure();
                    }
                } else {
                    SourceElement lel;
                    for (lel = sel; lel != null && lel.getSymbolKind() != 3; lel = lel.getParent()) {
                    }
                    cls = (JavaClass)lel;
                }
            } else {
                SourceNewClassExpression scce = (SourceNewClassExpression)mcall;
                JavaType javaType = scce.getSourceType().getResolvedType();
                if (javaType != null) {
                    cls = javaType.getTypeErasure();
                }
            }
            return SmartProvider.findPossibleParameterTypes(slist, cls, mname, paramindex, inCast);
        }
        return null;
    }

    private JavaFilter lookForAssignment(SourceElement el, int offset) {
        JavaType assignmentType = null;
        boolean makeCheckAssign = false;
        for (SourceElement sel = el; sel != null; sel = sel.getParent()) {
            if (sel.getSymbolKind() == 48) {
                assignmentType = ((SourceAssignmentExpression)sel).getResolvedType();
            } else if (sel.getSymbolKind() == 36 || sel.getSymbolKind() == 51) {
                if (assignmentType == null) {
                    return null;
                }
                makeCheckAssign = true;
            } else if (sel.getSymbolKind() == 9 || sel.getSymbolKind() == 18) {
                SourceTypeReference ref = ((SourceVariableDeclaration)sel).getSourceType();
                if (ref != null) {
                    assignmentType = ref.getResolvedType();
                }
                if (assignmentType != null) {
                    makeCheckAssign = true;
                }
            }
            if (!makeCheckAssign) continue;
            String dString = SmartProvider.getAdjustedText(sel, offset);
            return this.checkAssign((JavaHasType)assignmentType, dString);
        }
        return null;
    }

    private JavaFilter lookForCast(SourceElement el, int offset) {
        for (SourceElement sel = el; sel != null; sel = sel.getParent()) {
            if (sel.getSymbolKind() != 59) continue;
            if (offset >= sel.getEndOffset()) {
                return null;
            }
            int off = sel.getStartOffset() + 1;
            if (off == offset) {
                return null;
            }
            return this.getFilter(off);
        }
        return null;
    }

    private JavaFilter lookForWrapper(SourceElement el, int offset) {
        for (SourceElement sel = el; sel != null; sel = sel.getParent()) {
            int off;
            if (sel.getSymbolKind() != 61) continue;
            if (offset >= sel.getEndOffset()) {
                return null;
            }
            SourceElement parent = sel.getParent();
            if (parent != null) {
                if (parent.getSymbolKind() == 39 || parent.getSymbolKind() == 45) {
                    JavaClass booleanType = this.context.getProvider().getClass("boolean");
                    return new AssignableFilter((JavaType)booleanType, 1);
                }
                if (parent.getSymbolKind() == 41) {
                    JavaClass intType = this.context.getProvider().getClass("int");
                    return new AssignableFilter((JavaType)intType, 1);
                }
            }
            if ((off = sel.getStartOffset() + 1) == offset) {
                return null;
            }
            return this.getFilter(off);
        }
        return null;
    }

    private JavaFilter lookForAnnotationSym(SourceElement el) {
        if (el.getSymbolKind() == 1 || el.getSymbolKind() == 20 && el.getParent() != null && el.getParent().getSymbolKind() == 1) {
            return new AnnotationSymFilter();
        }
        return null;
    }

    public JavaFilter getFilter(InsightContext context) {
        this.context = context;
        JavaFilter filter = this.getFilter(context.getCaretPosition());
        this.context = null;
        return filter;
    }

    private JavaFilter getFilter(int curoffset) {
        SourceFile sf = this.context.getSourceFile();
        SourceElement el = SmartProvider.getLeftElem((SourceElement)sf, curoffset);
        if (el == null) {
            return null;
        }
        JavaFilter res = SmartProvider.lookForInfixExpression(el, curoffset);
        if (res != null) {
            return res;
        }
        res = SmartProvider.lookForMethodParameter(el, curoffset);
        if (res != null) {
            return res;
        }
        res = this.lookForCast(el, curoffset);
        if (res != null) {
            return res;
        }
        res = this.lookForWrapper(el, curoffset);
        if (res != null) {
            return res;
        }
        res = this.lookForDeclaration(el, curoffset);
        if (res != null) {
            return res;
        }
        res = this.lookForAssignment(el, curoffset);
        if (res != null) {
            return res;
        }
        res = SmartProvider.lookForCaseLabel(el);
        if (res != null) {
            return res;
        }
        res = this.lookForAnnotationSym(el);
        if (res != null) {
            return res;
        }
        res = new JavaFilter(){

            public boolean accepts(JavaElement element) {
                return true;
            }
        };
        return res;
    }
}

