/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AbstractCompletionInsightData;
import oracle.jdevimpl.java.insight.AnnotationInsightData;
import oracle.jdevimpl.java.insight.ClassInsightData;
import oracle.jdevimpl.java.insight.DocTagInsightData;
import oracle.jdevimpl.java.insight.ImportInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.LabelInsightData;
import oracle.jdevimpl.java.insight.MemberInsightData;
import oracle.jdevimpl.java.insight.NameInsightData;
import oracle.jdevimpl.java.insight.PackageInsightData;
import oracle.jdevimpl.java.util.ExpressionFinder;

class RegularInsightHelper {
    protected static final int IN_UNKNOWN = 0;
    protected static final int IN_PACKAGE = 1;
    protected static final int IN_IMPORT = 2;
    protected static final int IN_CLASS = 3;
    protected static final int IN_CLASS_DECLARATION = 4;
    protected static final int IN_CLASS_MEMBER = 5;
    protected static final int IN_CLASS_BODY = 6;
    protected static final int IN_DOC_COMMENT = 7;
    protected static final int IN_IMPORT_STATIC = 8;
    protected static final int IN_LINE_COMMENT = 9;
    public static final int FEEDBACK_MESSAGE_DELAY = 5000;
    protected static final boolean DEBUG_DUMP_TEXT_BUFFER = false;
    protected static final String DEBUG_DUMP_FILE_NAME = "insight_buffer_dump.java";

    RegularInsightHelper() {
    }

    public InsightData getInsightData(InsightContext context, JavaFilter filter) {
        Object insightData = RegularInsightHelper.getInsightDataViaJot();
        if (insightData == null) {
            insightData = this.getInsightDataViaLexer(context, filter);
        }
        if (insightData == null) {
            if (!RegularInsightHelper.verifyValidContext(context)) {
                return null;
            }
            int type = RegularInsightHelper.getSimpleContextType(context);
            if (type == 0) {
                type = RegularInsightHelper.getComplexContextType(context);
            }
            switch (type) {
                case 1: {
                    insightData = new PackageInsightData(context);
                    break;
                }
                case 2: {
                    insightData = new ImportInsightData(context, false);
                    break;
                }
                case 8: {
                    insightData = new ImportInsightData(context, true);
                    break;
                }
                case 7: {
                    insightData = new DocTagInsightData(context);
                    break;
                }
                case 9: {
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
        }
        if (insightData != null) {
            Object[] dataList = insightData.getData();
            return dataList.length > 0 ? insightData : null;
        }
        return null;
    }

    public static InsightData updateInsightData(JavaFilter filter, InsightData lastData) {
        if (lastData instanceof PackageInsightData) {
            PackageInsightData packageData = (PackageInsightData)lastData;
            packageData.updateData();
        } else if (lastData instanceof ImportInsightData) {
            ImportInsightData importData = (ImportInsightData)lastData;
            importData.updateData();
        } else if (lastData instanceof ClassInsightData) {
            ClassInsightData classData = (ClassInsightData)lastData;
            classData.setResultFilter(filter);
            classData.updateData();
        } else if (lastData instanceof MemberInsightData) {
            MemberInsightData memberData = (MemberInsightData)lastData;
            memberData.setResultFilter(filter);
            memberData.updateData();
        } else if (lastData instanceof LabelInsightData) {
            LabelInsightData labelData = (LabelInsightData)lastData;
            labelData.updateData();
        } else if (lastData instanceof DocTagInsightData) {
            DocTagInsightData docTagData = (DocTagInsightData)lastData;
            docTagData.updateData();
        } else if (lastData instanceof NameInsightData) {
            NameInsightData docTagData = (NameInsightData)lastData;
            docTagData.updateData();
        }
        return lastData;
    }

    private static InsightData getInsightDataViaJot() {
        return null;
    }

    private InsightData getInsightDataViaLexer(InsightContext context, JavaFilter filter) {
        int caretPosition;
        ExpressionFinder finder = context.getFinder();
        if (finder.isCursorPartOfLabelUsage(caretPosition = context.getCaretPosition())) {
            return new LabelInsightData(context);
        }
        int tokenStartOffset = finder.isCursorPartOfQualifiedNameUsage(caretPosition);
        if (tokenStartOffset != -1) {
            TextBuffer textBuffer = context.getTextBuffer();
            int token = RegularInsightHelper.getTokenAtOffset(textBuffer, tokenStartOffset);
            switch (token) {
                case 125: {
                    return new PackageInsightData(context);
                }
                case 118: {
                    return new ImportInsightData(context, false);
                }
                case 79: 
                case 110: 
                case 117: 
                case 124: 
                case 137: 
                case 138: {
                    return new ClassInsightData(context, token, filter);
                }
            }
            throw new RuntimeException("Not a qualified name keyword.");
        }
        int tokenStart = finder.isCursorPartOfCodeUsage(caretPosition);
        if (tokenStart >= 0) {
            MemberInsightData memberInsightData = null;
            TextBuffer textBuffer = context.getTextBuffer();
            int token = RegularInsightHelper.getTokenAtOffset(textBuffer, tokenStart);
            if (token == 79) {
                memberInsightData = new AnnotationInsightData(context, tokenStart);
            } else {
                if (token == 11 || token == 10 || token == 8 || token == 9) {
                    return null;
                }
                memberInsightData = this.createMemberInsightData(context);
            }
            ((AbstractCompletionInsightData)memberInsightData).setResultFilter(filter);
            memberInsightData.fillInitialData();
            return memberInsightData;
        }
        return null;
    }

    protected MemberInsightData createMemberInsightData(InsightContext context) {
        return new MemberInsightData(context);
    }

    protected static boolean verifyValidContext(InsightContext context) {
        TextBuffer textBuffer = context.getTextBuffer();
        int caretPosition = context.getCaretPosition();
        int token = RegularInsightHelper.getTokenAtOffset(textBuffer, caretPosition);
        String errorMessage = null;
        if (RegularInsightHelper.isSQLJToken(token)) {
            errorMessage = JavaArb.getString(48);
        } else if (RegularInsightHelper.isLiteralToken(token)) {
            errorMessage = JavaArb.getString(47);
        }
        if (errorMessage != null) {
            context.showFeedback(errorMessage);
            return false;
        }
        return true;
    }

    protected static int getSimpleContextType(InsightContext context) {
        int lineEnd;
        TextBuffer textBuffer = context.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        int caretPosition = context.getCaretPosition();
        int currentToken = RegularInsightHelper.getTokenAtOffset(textBuffer, caretPosition);
        if (currentToken == 26) {
            return 7;
        }
        if (currentToken == 24) {
            return 9;
        }
        int type = 0;
        int line = lineMap.getLineFromOffset(caretPosition);
        int lineStart = lineMap.getLineStartOffset(line);
        char[] lineChars = textBuffer.getChars(lineStart, (lineEnd = lineMap.getLineEndOffset(line)) - lineStart);
        String lineText = new String(lineChars);
        String trimmedText = lineText.trim();
        if (trimmedText.startsWith("package")) {
            type = 1;
        } else if (trimmedText.startsWith("import")) {
            type = trimmedText.substring(6).trim().startsWith("static") ? 8 : 2;
        }
        return type;
    }

    protected static int getComplexContextType(InsightContext context) {
        int type;
        int caretPosition = context.getCaretPosition();
        SourceFile rootSymbol = context.getSourceFile();
        if (rootSymbol == null) {
            String errorMessage = JavaArb.getString(43);
            context.showFeedback(errorMessage);
            return 0;
        }
        ArrayList<Object> traverseList = new ArrayList<Object>();
        traverseList.add(rootSymbol);
        SourcePackage packageSymbol = rootSymbol.getSourcePackage();
        if (packageSymbol != null && RegularInsightHelper.inJavaSymbol(caretPosition, (SourceElement)packageSymbol)) {
            type = 1;
            traverseList.add(packageSymbol);
        } else {
            List classSymbols;
            List importSymbols = rootSymbol.getSourceImports();
            if (!importSymbols.isEmpty()) {
                for (SourceImport importSymbol : importSymbols) {
                    if (!RegularInsightHelper.inJavaSymbol(caretPosition, (SourceElement)importSymbol)) continue;
                    type = importSymbol.isStatic() ? 8 : 2;
                    traverseList.add(importSymbol);
                    break;
                }
            } else if (!(classSymbols = rootSymbol.getSourceClasses()).isEmpty()) {
                for (SourceClass classSymbol : classSymbols) {
                    if (!RegularInsightHelper.inJavaSymbol(caretPosition, (SourceElement)classSymbol)) continue;
                    type = 3;
                    traverseList.add(classSymbol);
                    break;
                }
            } else {
                String errorMessage = JavaArb.getString(44);
                context.showFeedback(errorMessage);
                return 0;
            }
        }
        block2: while (type == 3) {
            int lastIndex = traverseList.size() - 1;
            SourceClass classSymbol = (SourceClass)traverseList.get(lastIndex);
            SourceClassBody bodySymbol = classSymbol.getSourceBody();
            if (!RegularInsightHelper.inJavaSymbol(caretPosition, (SourceElement)bodySymbol)) {
                type = 4;
                break;
            }
            type = 6;
            traverseList.add(bodySymbol);
            List memberSymbols = classSymbol.getSourceMembers();
            if (memberSymbols.isEmpty()) break;
            for (SourceMember memberSymbol : memberSymbols) {
                if (!RegularInsightHelper.inJavaSymbol(caretPosition, (SourceElement)memberSymbol)) continue;
                type = 5;
                traverseList.add(memberSymbol);
                if (!(memberSymbol instanceof SourceClass)) break block2;
                type = 3;
                traverseList.add(memberSymbol);
                continue block2;
            }
        }
        return type;
    }

    private static boolean inJavaSymbol(int offset, SourceElement javaSymbol) {
        return offset >= javaSymbol.getStartOffset() && offset <= javaSymbol.getEndOffset();
    }

    public static int getTokenAtOffset(TextBuffer textBuffer, int caretPosition) {
        int token;
        JavaLexer lexer = new JavaLexer();
        LexerToken lexerToken = lexer.createLexerToken();
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setSkipComments(false);
        lexer.setRecognizeSQLJ(true);
        lexer.setPosition(0);
        int foundToken = -1;
        while ((token = lexer.lex(lexerToken)) != 0) {
            int tokenStart = lexerToken.getStartOffset();
            int tokenEnd = lexerToken.getEndOffset();
            if (tokenEnd < caretPosition) continue;
            if (tokenStart <= caretPosition && caretPosition < tokenEnd) {
                foundToken = token;
                break;
            }
            if (tokenEnd == caretPosition) {
                foundToken = token;
                continue;
            }
            if (caretPosition < tokenStart) break;
            throw new IllegalStateException("Unexpected");
        }
        lexer.setTextBuffer(null);
        return foundToken;
    }

    public static boolean isSQLJToken(int token) {
        switch (token) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCommentToken(int token) {
        switch (token) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLiteralToken(int token) {
        return 8 <= token && token < 16;
    }

    public static boolean isKeywordToken(int token) {
        return 96 <= token && token < 146;
    }
}

