/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

final class NameEntry {
    protected static final int DATA_TYPE = 1;
    protected static final int FUNCTION_TYPE = 2;
    protected static final int ARRAY_TYPE = 3;
    private String entryName;
    private int startOffset;
    private int endOffset;
    private String identifierName;
    private int type;

    NameEntry(String entryName, boolean parseEntry, int startOffset, int endOffset) {
        this.entryName = entryName;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.identifierName = entryName;
        this.type = 1;
        if (parseEntry) {
            int length = entryName.length();
            for (int i = 0; i < length; ++i) {
                char c = entryName.charAt(i);
                if (c == '(') {
                    this.identifierName = entryName.substring(0, i);
                    this.type = 2;
                    break;
                }
                if (c != '[') continue;
                this.identifierName = entryName.substring(0, i);
                this.type = 3;
                break;
            }
        }
    }

    protected String getEntryName() {
        return this.entryName;
    }

    protected int getStartOffset() {
        return this.startOffset;
    }

    protected int getEndOffset() {
        return this.endOffset;
    }

    protected int getType() {
        return this.type;
    }

    protected String getIdentifierName() {
        return this.identifierName;
    }

    public String toString() {
        return this.entryName + " (" + this.startOffset + ":" + this.endOffset + ") " + this.type;
    }
}

