/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.JList;
import oracle.ide.ceditor.insight.InsightCellRenderer;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.jdevimpl.java.insight.InsightDataItem;

class MemberCellRenderer
extends InsightCellRenderer {
    private boolean boldDeclaredMembersOption = false;
    private boolean italicLocalVariablesOption = false;
    private boolean strikethruDeprecatedOption = false;
    private boolean showDefiningClassOption = false;

    MemberCellRenderer() {
    }

    protected void setBoldDeclaredMembers(boolean boldDeclaredMembers) {
        this.boldDeclaredMembersOption = boldDeclaredMembers;
    }

    protected void setItalicLocalVariables(boolean italicLocalVariables) {
        this.italicLocalVariablesOption = italicLocalVariables;
    }

    protected void setStrikethruDeprecated(boolean strikethruDeprecated) {
        this.strikethruDeprecatedOption = strikethruDeprecated;
    }

    protected void setShowDefiningClass(boolean showDefiningClass) {
        this.showDefiningClassOption = showDefiningClass;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setIconTextGap(8);
        if (value instanceof InsightDataItem) {
            String declaringClass;
            InsightDataItem currentItem = (InsightDataItem)((Object)value);
            AccessibleContext ac = this.getAccessibleContext();
            if (ac != null) {
                ac.setAccessibleName(currentItem.getAccessibleText());
            }
            Font boldFont = this.boldDeclaredMembersOption ? list.getFont().deriveFont(1) : list.getFont();
            Font italicFont = this.italicLocalVariablesOption ? list.getFont().deriveFont(2) : list.getFont();
            boolean isLocal = currentItem.belongsToClass();
            boolean isVariable = currentItem.getUnderlyingItem() instanceof JavaVariable;
            Font fontToUse = isLocal ? boldFont : (isVariable ? italicFont : list.getFont());
            this.setFont(fontToUse);
            this.setIcon(currentItem.getIcon());
            this.setText(currentItem.getDisplayCellName());
            String description = currentItem.getDisplayCellType();
            if (this.showDefiningClassOption && (declaringClass = currentItem.declaringClass()) != null && declaringClass.length() > 0) {
                description = description + " - " + declaringClass;
            }
            this.setDescription(description);
            Map<TextAttribute, ?> attributes = list.getFont().getAttributes();
            if (this.strikethruDeprecatedOption && currentItem.isDeprecated()) {
                attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                this.setFont(this.getFont().deriveFont(attributes));
            }
        }
        return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
    }
}

