/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.common.QuickHasName;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AbstractCompletionInsightData;
import oracle.jdevimpl.java.insight.EnumInsightDataItem;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;

public class ImportInsightData
extends AbstractCompletionInsightData {
    private boolean isImportStatic;
    private static final EditDescriptor editDescriptor;
    private String importPrefix;

    @Override
    int getNameStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        if (textBuffer.getChar(caretOffset - 1) == '*') {
            return caretOffset - 1;
        }
        return super.getNameStartOffset(textBuffer, caretOffset);
    }

    @Override
    int getNameEndOffset(ReadTextBuffer textBuffer, int caretOffset) {
        if (caretOffset >= textBuffer.getLength()) {
            return textBuffer.getLength();
        }
        if (textBuffer.getChar(caretOffset) == '*') {
            return caretOffset + 1;
        }
        return ImportInsightData.getIdentifierEnd(textBuffer, caretOffset);
    }

    @Override
    EditDescriptor getEditDescriptor() {
        return editDescriptor;
    }

    @Override
    String identifySelf() {
        return "Import";
    }

    @Override
    int getPrimaryPrefixFilter() {
        return 1;
    }

    public ImportInsightData(InsightContext insight, boolean isImportStatic) {
        super(insight);
        this.isImportStatic = isImportStatic;
        this.fillInitialData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean complete(Object selectedObject) {
        String checkTrailer;
        InsightDataItem item = (InsightDataItem)((Object)selectedObject);
        String importName = item.getName();
        String importSuffix = ".";
        boolean retriggerInsight = true;
        if (importName.equals("*")) {
            importSuffix = this.getEndSuffix();
            retriggerInsight = false;
        } else if (item.getItemType() != 9) {
            if (this.isImportStatic && item.getItemType() == 3) {
                JavaType javaType = (JavaType)item.getUnderlyingItem();
                if (javaType.isMemberClass()) {
                    importSuffix = this.getEndSuffix();
                    retriggerInsight = false;
                }
            } else {
                importSuffix = this.getEndSuffix();
                retriggerInsight = false;
            }
        }
        BasicDocument document = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        int offsetAdjustment = this.helper.getCaretPositionAdjustment();
        int startOffset = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        int endOffset = this.getNameEndOffset((ReadTextBuffer)textBuffer, caretOffset);
        int caretToStartOffset = caretOffset - startOffset;
        BasicEditorPane editor = this.helper.getEditorPane();
        editor.beginEdit(editDescriptor);
        if (textBuffer.getLength() > endOffset && (checkTrailer = textBuffer.getString(endOffset, 1)).equals(importSuffix)) {
            ++endOffset;
        }
        try {
            String currentText = textBuffer.getString(startOffset, endOffset - startOffset);
            String replacementText = importName + importSuffix;
            if (replacementText.startsWith(currentText)) {
                int insertionPoint = editor.getCaretPosition() - caretToStartOffset;
                document.insertString(startOffset + offsetAdjustment + currentText.length(), replacementText.substring(currentText.length()), null);
                editor.setCaretPosition(insertionPoint + replacementText.length());
            } else {
                document.remove(startOffset + offsetAdjustment, endOffset - startOffset);
                document.insertString(startOffset + offsetAdjustment, replacementText, null);
            }
        }
        catch (BadLocationException e) {
            System.err.println("Exception occurred in completion: " + e);
            e.printStackTrace();
        }
        finally {
            editor.endEdit();
        }
        return retriggerInsight;
    }

    @Override
    void fillInitialDataImpl() {
        this.importPrefix = this.findCurrentPrefix();
        this.fillDataList();
    }

    @Override
    void updateDataImpl() {
        String newPrefix = this.findCurrentPrefix();
        if (!newPrefix.startsWith(this.importPrefix)) {
            this.clearData();
            return;
        }
        if (!this.importPrefix.equals(newPrefix)) {
            this.importPrefix = newPrefix;
            this.fillDataList();
        }
    }

    protected String getEndSuffix() {
        return ";";
    }

    protected boolean shouldImportWildcardBeIncluded() {
        return true;
    }

    private void fillDataList() {
        int startOffset;
        int endOffset = startOffset = this.analysisStartOffset;
        CallerContext.InputOptions options = new CallerContext.InputOptions();
        options.input = (byte)2;
        options.squash = 1;
        if (this.importPrefix.length() > 0) {
            endOffset += this.importPrefix.length() - 1;
            options.input = (byte)(options.input | 4);
        }
        if (this.isImportStatic) {
            options.input = (byte)(options.input | 0x49);
        }
        this.fillDataListHelper(startOffset, endOffset, false, options);
        ArrayList<InsightDataItem> dataItemList = new ArrayList<InsightDataItem>(this.dataList.length);
        block6: for (InsightDataItem dataItem : this.dataList) {
            switch (dataItem.getUnderlyingItem().getElementKind()) {
                case 9: {
                    dataItemList.add(dataItem);
                    continue block6;
                }
                case 3: {
                    JavaType javaType = (JavaType)dataItem.getUnderlyingItem();
                    if (!javaType.isPublic() || javaType.isMemberClass() && (!javaType.isMemberClass() || !javaType.isStatic())) continue block6;
                    dataItemList.add(dataItem);
                    continue block6;
                }
                case 5: {
                    JavaField javaField;
                    if (!this.isImportStatic || !(javaField = (JavaField)dataItem.getUnderlyingItem()).isStatic() || !javaField.isPublic()) continue block6;
                    if (javaField.isEnumConstant()) {
                        dataItemList.add(new EnumInsightDataItem((JavaElement)javaField, true));
                        continue block6;
                    }
                    dataItemList.add(dataItem);
                    continue block6;
                }
                case 8: {
                    JavaMethod javaMethod;
                    if (!this.isImportStatic || !(javaMethod = (JavaMethod)dataItem.getUnderlyingItem()).isStatic() || !javaMethod.isPublic()) continue block6;
                    dataItemList.add(dataItem);
                    continue block6;
                }
            }
        }
        this.dataList = dataItemList.toArray(new InsightDataItem[dataItemList.size()]);
        Arrays.sort((Object[])this.dataList);
        if (this.importPrefix.length() > 0 && this.shouldImportWildcardBeIncluded()) {
            int count = this.dataList.length;
            InsightDataItem[] newDataList = new InsightDataItem[count + 1];
            System.arraycopy(this.dataList, 0, newDataList, 0, count);
            newDataList[count] = new InsightDataItem((JavaElement)QuickHasName.createHasName((String)"*"));
            this.dataList = newDataList;
        }
    }

    static {
        String editName = JavaArb.getString(50);
        editDescriptor = new EditDescriptor(editName);
    }
}

