/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.insight.BasicInsight;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.ui.ColorUtils2;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;
import oracle.jdeveloper.java.util.VariableNaming;
import oracle.jdevimpl.audit.java.JavaHelper;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.MemberInsightData;
import oracle.jdevimpl.java.insight.RegularInsightHelper;
import oracle.jdevimpl.java.insight.RegularProvider;

final class DeclarationProvider
extends RegularProvider {
    DeclarationProvider(BasicInsight basicInsight) {
        super(basicInsight);
    }

    @Override
    protected JavaFilter getJavaFilter(BasicEditorPane editorPane) {
        return new ReturnableMethodFilter();
    }

    @Override
    public InsightData getInsightData(BasicEditorPane editorPane) {
        JavaFilter filter = this.getJavaFilter(editorPane);
        InsightContext context = this.createInsightContext(editorPane);
        DeclarationInsightHelper declarationInsightHelper = new DeclarationInsightHelper();
        return declarationInsightHelper.getInsightData(context, filter);
    }

    @Override
    protected ListInsightView createInsightView() {
        ListInsightView view = super.createInsightView();
        JComponent comp = view.getComponent();
        Color c = comp.getBackground();
        view.getComponent().setBackground(ColorUtils2.getCompliment((Color)c));
        return view;
    }

    private static boolean isVoid(JavaType javaType) {
        return javaType.getName() == JavaConstants.KW_words[45];
    }

    private static class DeclarationDataItem
    extends InsightDataItem {
        private String name = null;

        public DeclarationDataItem(InsightDataItem item) {
            super(item.getUnderlyingItem());
        }

        @Override
        protected String getDisplayCellName() {
            if (this.name == null) {
                JavaMethod javaMethod = (JavaMethod)this.getUnderlyingItem();
                this.name = this.useFullSignature() ? DeclarationDataItem.getShortSignature(javaMethod) : DeclarationDataItem.getVeryShortSignature(javaMethod);
            }
            return this.name;
        }

        @Override
        protected String getDisplayCellType() {
            JavaMethod javaMethod = (JavaMethod)this.getUnderlyingItem();
            JavaType returnType = javaMethod.getReturnType();
            return returnType.getUnqualifiedName() + " ... =";
        }
    }

    private static class DeclarationData
    extends MemberInsightData {
        private InsightContext context;

        DeclarationData(InsightContext context) {
            super(context);
            this.context = context;
        }

        @Override
        protected InsightDataItem[] createInsightDataItems(CallerContext.Output output, JavaPackage packagePrimary, JavaHasType hasTypePrimary) {
            ArrayList<DeclarationDataItem> declarationDataItems = new ArrayList<DeclarationDataItem>();
            for (InsightDataItem dataItem : super.createInsightDataItems(output, packagePrimary, hasTypePrimary)) {
                JavaMethod javaMethod;
                if (!(dataItem.getUnderlyingItem() instanceof JavaMethod) || DeclarationProvider.isVoid((javaMethod = (JavaMethod)dataItem.getUnderlyingItem()).getReturnType())) continue;
                declarationDataItems.add(new DeclarationDataItem(dataItem));
            }
            return declarationDataItems.toArray(new DeclarationDataItem[declarationDataItems.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        protected void insertAdditionalText(InsightDataItem item) {
            JavaType returnType;
            SourceTypeArgument[] typeArguments;
            SourceElement parent;
            SourceFile sf = this.context.getSourceFile();
            SourceElement elem = sf.getElementAt(this.context.getCaretPosition());
            JavaMethod javaMethod = (JavaMethod)item.getUnderlyingItem();
            for (parent = elem; parent != null; parent = parent.getParent()) {
                void var10_11;
                if (parent.getSymbolKind() != 53) continue;
                SourceMethodCallExpression methodCall = (SourceMethodCallExpression)parent;
                List typeArgList = methodCall.getChildren(25);
                if (typeArgList.size() <= 0) break;
                typeArguments = typeArgList.toArray(new SourceTypeArgument[typeArgList.size()]);
                JavaType[] typeArgTypes = new JavaType[typeArguments.length];
                boolean bl = false;
                while (var10_11 < typeArgTypes.length) {
                    typeArgTypes[var10_11] = typeArguments[var10_11].getResolvedType();
                    if (typeArgTypes[var10_11] == null) {
                        typeArgTypes = null;
                        break;
                    }
                    ++var10_11;
                }
                if (typeArgTypes == null) break;
                javaMethod = CallerContext.createParameterizedMethod((JavaProvider)sf.getProvider(), (JavaMethod)javaMethod, (JavaType[])typeArgTypes);
                break;
            }
            if ((returnType = javaMethod.getReturnType()).hasActualTypeArguments()) {
                JavaClass currentClass = null;
                for (parent = elem.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent.getSymbolKind() != 3) continue;
                    currentClass = (JavaClass)parent;
                    break;
                }
                typeArguments = returnType.getActualTypeArguments();
                for (JavaType javaType : typeArguments) {
                    if (javaType.getElementKind() == 3) continue;
                    boolean eraseType = false;
                    if (javaMethod.getTypeParameter(javaType.getName()) != null) {
                        eraseType = true;
                    } else if (currentClass != null && currentClass.getTypeParameter(javaType.getName()) == null) {
                        eraseType = true;
                    }
                    if (!eraseType) continue;
                    returnType = returnType.getTypeErasure();
                    break;
                }
            }
            while (!(elem instanceof SourceExpressionStatement)) {
                if ((elem = elem.getParent()) != null) continue;
                return;
            }
            SourceExpression expression = ((SourceExpressionStatement)elem).getExpression();
            TextBuffer textBuffer = this.helper.getTextBuffer();
            textBuffer.writeLock();
            try {
                Context editorContext = CodeEditor.getContext((BasicEditorPane)this.helper.getEditorPane());
                UndoableEditCommand undoableEditCommand = new UndoableEditCommand(JavaArb.getString(386), editorContext);
                boolean success = false;
                SourceTransaction transaction = sf.beginTransaction();
                try {
                    SourceFactory factory = sf.getFactory();
                    SourceTypeReference typeRef = factory.createType(returnType.getUnqualifiedName());
                    List<String> names = VariableNaming.suggestVariableNames((SourceElement)expression, returnType.getName());
                    String name = returnType.getName().toLowerCase();
                    if (names.size() > 0) {
                        name = names.get(0);
                    } else if (!VariableNaming.canIntroduceVariable((SourceElement)expression, name)) {
                        for (int i = 0; i < 100; ++i) {
                            String newName = name + i;
                            if (!VariableNaming.canIntroduceVariable((SourceElement)expression, newName)) continue;
                            name = newName;
                            break;
                        }
                    }
                    expression.removeSelf();
                    SourceLocalVariableDeclaration decl = factory.createLocalVariableDeclaration(typeRef, name, expression);
                    elem.replaceSelf((SourceElement)decl);
                    JavaHelper.addImport(sf, returnType.getRawName());
                    success = true;
                }
                finally {
                    if (success) {
                        UndoableEdit edit = transaction.commit();
                        undoableEditCommand.addEdit(edit);
                    } else {
                        transaction.abort();
                    }
                }
                try {
                    CommandProcessor commandProcessor = CommandProcessor.getInstance();
                    commandProcessor.invoke((Command)undoableEditCommand);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            finally {
                textBuffer.writeUnlock();
            }
        }

        @Override
        public boolean complete(Object selectedObject) {
            return super.complete(selectedObject);
        }
    }

    private static class DeclarationInsightHelper
    extends RegularInsightHelper {
        private DeclarationInsightHelper() {
        }

        @Override
        protected MemberInsightData createMemberInsightData(InsightContext context) {
            return new DeclarationData(context);
        }
    }

    private static class ReturnableMethodFilter
    implements JavaFilter {
        private ReturnableMethodFilter() {
        }

        public boolean accepts(JavaElement element) {
            JavaMethod javaMethod;
            JavaType returnType;
            return element instanceof JavaMethod && !DeclarationProvider.isVoid(returnType = (javaMethod = (JavaMethod)element).getReturnType());
        }
    }
}

