/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.HashSet;
import javax.swing.ListCellRenderer;
import oracle.ide.Context;
import oracle.ide.ceditor.htmlpopup.ContentProvider;
import oracle.ide.ceditor.insight.BasicInsight;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.jdevimpl.java.insight.CompletionCellRenderer;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightContextImpl;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.JavaInsightOptions;
import oracle.jdevimpl.java.insight.RegularProvider;
import oracle.jdevimpl.java.insight.SmartProvider;
import oracle.jdevimpl.javadoc.popup.JavadocElements;
import oracle.jdevimpl.javadoc.popup.SourceMemberProvider;

public class CompletionInsight
extends BasicInsight
implements JavaConstants {
    private ListInsightView _listInsightView;
    private JavaFilter _smartFilter = null;
    protected static final boolean DEBUG_DUMP_TEXT_BUFFER = false;
    protected static final String DEBUG_DUMP_FILE_NAME = "insight_buffer_dump.java";

    public CompletionInsight() {
    }

    public CompletionInsight(Context context) {
        this();
    }

    public int getInsightType() {
        return 1;
    }

    protected InsightProvider createInsightProvider() {
        return new RegularProvider(this);
    }

    protected InsightProvider createSmartInsightProvider() {
        return new SmartProvider(this);
    }

    protected InsightContext createInsightContext(BasicEditorPane pane) {
        return new InsightContextImpl(this, pane);
    }

    public boolean isInsightTriggerChar(char typedChar) {
        return typedChar == '.' || typedChar == '@';
    }

    private static boolean isMethodWithParameters(InsightDataItem item) {
        if (item.getItemType() != 8) {
            return false;
        }
        JavaMethod method = (JavaMethod)item.getUnderlyingItem();
        return !method.getParameters().isEmpty();
    }

    protected boolean isExactMatch(InsightData data) {
        Object[] matches = data.getMatchingData();
        if (matches == null) {
            return false;
        }
        int length = matches.length;
        if (length <= 1) {
            return length == 1;
        }
        InsightDataItem firstItem = (InsightDataItem)((Object)matches[0]);
        if (!CompletionInsight.isMethodWithParameters(firstItem)) {
            return false;
        }
        JavaMethod firstMethod = (JavaMethod)firstItem.getUnderlyingItem();
        String name = firstMethod.getName();
        JavaType firstType = firstMethod.getReturnType();
        if (firstType == null) {
            return false;
        }
        boolean firstIsVoid = "V".equals(firstType.getDescriptor());
        for (int i = 1; i < length; ++i) {
            boolean isVoid;
            InsightDataItem item = (InsightDataItem)((Object)matches[i]);
            if (!CompletionInsight.isMethodWithParameters(item)) {
                return false;
            }
            JavaMethod method = (JavaMethod)item.getUnderlyingItem();
            if (!name.equals(method.getName())) {
                return false;
            }
            JavaType type = method.getReturnType();
            boolean bl = isVoid = type != null && "V".equals(type.getDescriptor());
            if (firstIsVoid == isVoid) continue;
            return false;
        }
        return true;
    }

    public void install(BasicEditorPane editor) {
        super.install(editor);
        int type = this.getInsightType();
        String typeString = this.getTypeString(type);
        editor.putProperty(typeString, (Object)this);
    }

    public void deinstall(BasicEditorPane editor) {
        super.deinstall(editor);
        int type = this.getInsightType();
        String typeString = this.getTypeString(type);
        editor.putProperty(typeString, null);
    }

    public InsightView getInsightView() {
        if (this._listInsightView == null) {
            JavaInsightOptions options = JavaInsightOptions.getJavaInsightOptions();
            CompletionCellRenderer renderer = new CompletionCellRenderer();
            renderer.setBoldDeclaredMembers(options.getBoldDeclaredMembers());
            renderer.setItalicLocalVariables(options.getItalicLocalVariables());
            renderer.setStrikethruDeprecated(options.getStrikethruDeprecated());
            renderer.setShowDefiningClass(options.getShowDefiningClass());
            this._listInsightView = new ListInsightView((ListCellRenderer)renderer);
        }
        return this._listInsightView;
    }

    protected ListInsightView getListInsightView() {
        return this._listInsightView;
    }

    protected ContentProvider getSelectedContentProvider() {
        ContentProvider ret = super.getSelectedContentProvider();
        if (ret instanceof SourceMemberProvider) {
            SourceMemberProvider sourceMemberProvider = (SourceMemberProvider)ret;
            HashSet<JavadocElements> visibleElements = new HashSet<JavadocElements>(JavadocElements.allElements);
            visibleElements.remove((Object)JavadocElements.SIGNATURE);
            sourceMemberProvider.setVisibleElements(visibleElements);
        }
        return ret;
    }

    public int getCaretPositionAdjustment() {
        return 0;
    }
}

