/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.saveactions.SaveActionsPlugin;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.util.ArraySortedSet;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.util.Formatting;
import oracle.javatools.parser.java.v2.write.SourceComparator;
import oracle.jdeveloper.controller.JavaSourceNodeActionDelegate;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.java.JavaArb;

public class OrganizeImportsActionDelegate
extends JavaSourceNodeActionDelegate {
    public static final String ERROR_INFO_ID = "OrganizeImportsErrorInfo";
    public static final String THRESHOLD = "organize-imports-threshold";

    @Override
    protected int[] doAction(SourceFile file, Context context, Element[] elements, int[] text, IdeAction action) {
        int threshold = -1;
        Integer property = (Integer)action.getValue(THRESHOLD);
        if (property != null) {
            threshold = property;
        }
        OrganizeImportsActionDelegate.organizeImports(context, file, threshold);
        return null;
    }

    public static List<SourceImport> organizeImports(Context context, SourceFile file, int threshold) {
        return OrganizeImportsActionDelegate.organizeImports(context, file, threshold, threshold);
    }

    public static List<SourceImport> organizeImports(Context context, SourceFile file, int typeThreshold, int memberThreshold) {
        CodingStyleOptions options;
        if (typeThreshold < 0) {
            options = CodingStyleManager.getCodingStyleManager().getCodingStyleOptions(context);
            typeThreshold = Integer.MAX_VALUE;
            if (options.getUseWideImports()) {
                typeThreshold = options.getWideImportThreshold();
            }
        }
        if (memberThreshold < 0) {
            options = CodingStyleManager.getCodingStyleManager().getCodingStyleOptions(context);
            memberThreshold = Integer.MAX_VALUE;
            if (options.getUseWideMemberImports()) {
                memberThreshold = options.getWideImportMemberThreshold();
            }
        }
        file.getTransaction().savepoint();
        file.compile();
        LinkedHashMap typeImports = new LinkedHashMap();
        LinkedHashMap<String, ArraySortedSet> memberImports = new LinkedHashMap<String, ArraySortedSet>();
        List importDeclarations = file.getSourceImports();
        if (file.hasErrors(3, 4)) {
            return OrganizeImportsActionDelegate.errorAction();
        }
        for (SourceImport impor : importDeclarations) {
            int count;
            String qualifiedName = impor.getName();
            if (!impor.isUsed() || (count = impor.getImportedElementCount()) == 0) continue;
            int dot = qualifiedName.lastIndexOf(46);
            String qualifierName = dot > 0 ? qualifiedName.substring(0, dot) : "";
            LinkedHashMap<String, Object> importMap = impor.isStatic() ? memberImports : typeImports;
            Set unqualifiedNames = (Set)importMap.get(qualifierName);
            if (unqualifiedNames == null) {
                unqualifiedNames = new ArraySortedSet();
                importMap.put(qualifierName, (ArraySortedSet)unqualifiedNames);
            }
            for (int j = 0; j < count; ++j) {
                JavaMember member = (JavaMember)impor.getImportedElementAt(j);
                unqualifiedNames.add(member.getName());
            }
        }
        JavaProvider provider = file.getProvider();
        SourceFactory factory = file.getFactory();
        SourceImport dummy = factory.createImportDeclaration("dummy" + System.currentTimeMillis());
        importDeclarations.add(dummy);
        importDeclarations.retainAll(Arrays.asList(dummy));
        OrganizeImportsActionDelegate.processTypeImports(file, typeThreshold, provider, factory, typeImports, importDeclarations);
        OrganizeImportsActionDelegate.processMemberImports(memberThreshold, provider, factory, memberImports, importDeclarations);
        importDeclarations.remove(dummy);
        if (!importDeclarations.isEmpty()) {
            Collections.sort(importDeclarations, SourceComparator.hasNameComparator());
            file.getTransaction().savepoint();
            SourceElement first = (SourceElement)importDeclarations.get(0);
            SourceElement last = (SourceElement)importDeclarations.get(importDeclarations.size() - 1);
            Formatting.reformatRegion((SourceFile)file, (int)first.getStartOffset(), (int)last.getEndOffset());
        }
        return importDeclarations;
    }

    private static void processMemberImports(int threshold, JavaProvider provider, SourceFactory factory, Map memberImports, List importDeclarations) {
        Set set;
        String qualifierName;
        HashMap<String, ArraySortedSet> unqualifiedDemandImportMemberNames = new HashMap<String, ArraySortedSet>();
        for (Map.Entry entry : memberImports.entrySet()) {
            qualifierName = (String)entry.getKey();
            set = (Set)entry.getValue();
            if (set.size() < threshold) continue;
            JavaClass type = provider.getClass(qualifierName);
            for (JavaMember member : type.getDeclaredFields()) {
                String unqualifiedName = member.getName();
                Set names = (Set)unqualifiedDemandImportMemberNames.get(unqualifiedName);
                if (names == null) {
                    names = new ArraySortedSet();
                    unqualifiedDemandImportMemberNames.put(unqualifiedName, (ArraySortedSet)names);
                }
                names.add(qualifierName);
            }
        }
        for (Map.Entry entry : memberImports.entrySet()) {
            SourceImport impor;
            String qualifiedName;
            qualifierName = (String)entry.getKey();
            set = (Set)entry.getValue();
            if (set.size() >= threshold) {
                Iterator j = set.iterator();
                while (j.hasNext()) {
                    String memberName = (String)j.next();
                    qualifiedName = qualifierName + '.' + memberName;
                    Set conflicts = (Set)unqualifiedDemandImportMemberNames.get(memberName);
                    if (conflicts == null || conflicts.size() <= 1) continue;
                    SourceImport impor2 = factory.createImportDeclaration(8, qualifiedName);
                    importDeclarations.add(impor2);
                    j.remove();
                }
                if (set.isEmpty()) continue;
                if (set.size() >= threshold) {
                    SourceImport impor3 = factory.createImportDeclaration(8, qualifierName + ".*");
                    importDeclarations.add(impor3);
                    continue;
                }
                for (String memberName : set) {
                    qualifiedName = qualifierName + '.' + memberName;
                    impor = factory.createImportDeclaration(8, qualifiedName);
                    importDeclarations.add(impor);
                }
                continue;
            }
            for (String memberName : set) {
                qualifiedName = qualifierName + '.' + memberName;
                impor = factory.createImportDeclaration(8, qualifiedName);
                importDeclarations.add(impor);
            }
        }
    }

    private static void processTypeImports(SourceFile file, int threshold, JavaProvider provider, SourceFactory factory, Map typeImports, List importDeclarations) {
        String qualifierName;
        HashMap<String, ArraySortedSet> unqualifiedDemandImportTypeNames = new HashMap<String, ArraySortedSet>();
        for (Map.Entry entry : typeImports.entrySet()) {
            qualifierName = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (set.size() < threshold) continue;
            JavaPackage packag = provider.getPackage(qualifierName);
            for (JavaClass type : packag.getDeclaredClasses()) {
                String unqualifiedName = type.getName();
                Set names = (Set)unqualifiedDemandImportTypeNames.get(unqualifiedName);
                if (names == null) {
                    names = new ArraySortedSet();
                    unqualifiedDemandImportTypeNames.put(unqualifiedName, (ArraySortedSet)names);
                }
                names.add(qualifierName);
            }
        }
        for (Map.Entry entry : typeImports.entrySet()) {
            SourceImport impor;
            String qualifiedName;
            qualifierName = (String)entry.getKey();
            String thisPackage = file.getPackageName();
            if (thisPackage != null && thisPackage.equals(qualifierName)) continue;
            Set set = (Set)entry.getValue();
            if (set.size() >= threshold) {
                Iterator j = set.iterator();
                while (j.hasNext()) {
                    String memberName = (String)j.next();
                    qualifiedName = qualifierName + '.' + memberName;
                    Set conflicts = (Set)unqualifiedDemandImportTypeNames.get(memberName);
                    if (conflicts == null || conflicts.size() <= 1) continue;
                    SourceImport impor2 = factory.createImportDeclaration(qualifiedName);
                    importDeclarations.add(impor2);
                    j.remove();
                }
                if (set.isEmpty()) continue;
                if (set.size() >= threshold) {
                    SourceImport impor3 = factory.createImportDeclaration(qualifierName + ".*");
                    importDeclarations.add(impor3);
                    continue;
                }
                for (String memberName : set) {
                    qualifiedName = qualifierName + '.' + memberName;
                    impor = factory.createImportDeclaration(qualifiedName);
                    importDeclarations.add(impor);
                }
                continue;
            }
            for (String memberName : set) {
                qualifiedName = qualifierName + '.' + memberName;
                impor = factory.createImportDeclaration(qualifiedName);
                importDeclarations.add(impor);
            }
        }
    }

    private static List<SourceImport> errorAction() {
        if (!SaveActionsPlugin.isExecuting()) {
            MessageDialog.optionalInformation((String)ERROR_INFO_ID, (Component)Ide.getMainWindow().getContentPane(), (String)JavaArb.getString(174), (String)JavaArb.getString(175), null);
        }
        return Collections.EMPTY_LIST;
    }
}

