/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ArraySortedSet;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.popup.PopupWindow;
import oracle.javatools.editor.popup.PopupWindowListener;
import oracle.javatools.editor.popup.PopupWindowManager;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.util.filter.AnnotationFilter;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.ui.actiontip.ActionTipManager;
import oracle.javatools.ui.actiontip.ActionTipTask;
import oracle.javatools.ui.actiontip.DefaultActionTipComponent;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.audit.java.JavaHelper;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;
import oracle.jdevimpl.java.imports.ImportController;
import oracle.jdevimpl.java.imports.JavaImportOptions;
import oracle.jdevimpl.java.imports.SmartImportComparator;
import oracle.jdevimpl.java.insight.JavaInsightOptions;

public final class ImportAssistPlugin
implements ActionListener,
ActionHookInvoker,
CaretListener,
ChangeListener,
EditorPlugin,
FocusListener,
HierarchyListener,
Observer,
PopupWindowListener,
JavaParserPlugin.HelperClient {
    private static final boolean DEBUG_VERBOSE = false;
    private BasicEditorPane editor;
    private JViewport viewport;
    private Timer updateTimer;
    private Project project;
    private JavaSourceNode javaNode;
    private long cancelEndTime = System.currentTimeMillis();
    private static final int CANCEL_PERIOD_TIMEOUT = 10000;
    private static boolean skipImportPopup = false;
    private static final int SHORT_DELAY = 1000;
    private static final int LONG_DELAY = 5000;
    private JavaManager smJavaManager;
    private int smChangeId;
    private SourceFile smFile;
    private SourceError[] smErrors;
    private static final String PLUGIN_KEY = ImportAssistPlugin.class.getName();
    private String[] importChoices;
    private SourceError importError;
    private Rectangle importRect;
    private PopupWindow importPopup;
    private AssistInsight assistInsight;
    private boolean inModify = false;
    private List<String> doNotAutoImportList = new ArrayList<String>();
    private List<String> doNotPromptImportList = new ArrayList<String>();
    private Set<String> autoImportSet = new HashSet<String>();
    private static String nameInEditor;
    private static AsyncScheduler asScheduler;
    private AssistanceTask asTask = null;
    private ActionTipTask actionTipTask;

    @Override
    public void notifyCompileScheduled() {
        this.stopTimer();
        this.clearSemanticErrors();
        if (!this.inModify) {
            Runnable cancelRunner = new Runnable(){

                @Override
                public void run() {
                    ImportAssistPlugin.this.cancelInsight();
                    ImportAssistPlugin.this.cancelUI();
                    ImportAssistPlugin.this.cancelAssistance();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                cancelRunner.run();
            } else {
                SwingUtilities.invokeLater(cancelRunner);
            }
        }
    }

    @Override
    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    @Override
    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        SourceError[] filteredErrors;
        List errors = sourceFile.getCompileErrors();
        if (errors.isEmpty()) {
            filteredErrors = SourceError.EMPTY_ARRAY;
        } else {
            ArrayList<SourceError> errorList = new ArrayList<SourceError>();
            for (SourceError error : errors) {
                short errorCode = error.getErrorCode();
                if (errorCode != 56 && errorCode != 69) continue;
                errorList.add(error);
            }
            filteredErrors = errorList.toArray(new SourceError[errorList.size()]);
        }
        this.setSemanticErrors(javaManager, sourceFile, filteredErrors, changeId);
        if (this.editor.hasFocus() && this.hasSemanticErrors()) {
            JavaImportOptions options = ImportAssistPlugin.getOptions();
            int assistDelay = options.getAssistPopupDelay();
            int remainingDelay = Math.max(50, assistDelay - elapsedDelay);
            this.restartTimer(remainingDelay);
        }
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.addFocusListener((FocusListener)this);
        editor.addActionHookInvoker((ActionHookInvoker)this);
        editor.addCaretListener((CaretListener)this);
        editor.putProperty(PLUGIN_KEY, (Object)this);
        editor.addHierarchyListener((HierarchyListener)this);
        this.updateViewportTracking();
        this.updateTimer = new Timer(2000, this);
        this.updateTimer.setRepeats(false);
        Context context = CodeEditor.getContext((BasicEditorPane)editor);
        if (context == null) {
            throw new IllegalStateException("Unexpected null context");
        }
        this.updateContext(context);
        JavaParserPlugin.attachHelperClient(editor, this);
    }

    private void updateContext(Context newContext) {
        if (this.project != null) {
            this.project.detach((Observer)this);
            this.project = null;
            this.javaNode = null;
        }
        if (newContext != null) {
            this.project = newContext.getProject();
            this.javaNode = (JavaSourceNode)newContext.getNode();
            if (this.project != null) {
                this.project.attach((Observer)this);
            }
        }
    }

    public void deinstall(BasicEditorPane editor) {
        JavaParserPlugin.detachHelperClient(editor, this);
        editor.putProperty(PLUGIN_KEY, null);
        editor.removeActionHookInvoker((ActionHookInvoker)this);
        editor.removeCaretListener((CaretListener)this);
        editor.removeHierarchyListener((HierarchyListener)this);
        this.clearViewportTracking();
        this.cancelAssistance();
        this.cancelUI();
        this.cancelInsight();
        if (this.updateTimer != null) {
            this.stopTimer();
            this.updateTimer = null;
        }
        this.updateContext(null);
        Container parent = editor.getParent();
        if (parent != null && parent instanceof JViewport) {
            ((JViewport)parent).removeChangeListener(this);
        }
        editor.removeFocusListener((FocusListener)this);
        this.editor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeAction(String actionKey) {
        if (actionKey.equals("cancel")) {
            ImportAssistPlugin importAssistPlugin = this;
            synchronized (importAssistPlugin) {
                if (this.importPopup != null) {
                    this.cancelAssistance();
                    this.cancelUI();
                    this.cancelInsight();
                    if (!this.doNotPromptImportList.contains(nameInEditor)) {
                        this.doNotPromptImportList.add(nameInEditor);
                    }
                    this.cancelEndTime = System.currentTimeMillis() + 10000L;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent event) {
        this.updateViewportTracking();
    }

    private void updateViewportTracking() {
        Container parent = this.editor.getParent();
        if (parent != this.viewport) {
            this.clearViewportTracking();
            if (parent instanceof JViewport) {
                this.viewport = (JViewport)parent;
                if (this.viewport != null) {
                    this.viewport.addChangeListener(this);
                }
            }
        }
    }

    private void clearViewportTracking() {
        if (this.viewport != null) {
            this.viewport.removeChangeListener(this);
            this.viewport = null;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.cancelUI();
        this.cancelAssistance();
        this.restartTimer();
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.restartTimer();
    }

    @Override
    public void focusLost(FocusEvent event) {
        boolean isTemporary = event.isTemporary();
        if (!isTemporary) {
            this.cancelInsight();
            this.clearSemanticErrors();
        }
        this.stopTimer();
        this.cancelUI();
        this.cancelAssistance();
    }

    public void update(Object observed, UpdateMessage change) {
        if (observed instanceof Project) {
            int messageId = change.getMessageID();
            if (messageId == UpdateMessage.OBJECT_RELOADED || messageId == UpdateMessage.PROPERTY_SET) {
                this.clearSemanticErrors();
            } else if (messageId == UpdateMessage.ATTRIBUTE_CHANGED) {
                // empty if block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("editor-ide-context")) {
            this.stopTimer();
            this.cancelInsight();
            this.cancelUI();
            this.cancelAssistance();
            this.clearSemanticErrors();
            Context newContext = CodeEditor.getContext((BasicEditorPane)this.editor);
            this.updateContext(newContext);
        }
    }

    @Override
    public void caretUpdate(CaretEvent event) {
        if (!this.inModify) {
            this.cancelInsight();
            this.cancelUI();
            this.cancelAssistance();
            this.restartTimer();
        }
    }

    private void stopTimer() {
        this.updateTimer.stop();
    }

    private void restartTimer() {
        JavaImportOptions options = ImportAssistPlugin.getOptions();
        int assistDelay = options.getAssistPopupDelay();
        this.restartTimer(assistDelay);
    }

    private void restartTimer(int delay) {
        JavaImportOptions options;
        if (this.updateTimer == null) {
            return;
        }
        this.stopTimer();
        if (this.hasSemanticErrors() && (options = ImportAssistPlugin.getOptions()).getAssistEnablePopup()) {
            this.updateTimer.setInitialDelay(delay);
            this.updateTimer.restart();
        }
    }

    private static JavaImportOptions getOptions() {
        JavaImportOptions options = (JavaImportOptions)Ide.getSettings().getData("JavaImportOptions");
        if (options == null) {
            options = new JavaImportOptions();
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("JavaImportOptions", (Copyable)options);
        }
        return options;
    }

    private static JavaInsightOptions getInsightOptions() {
        JavaInsightOptions options = (JavaInsightOptions)Ide.getSettings().getData("JavaInsightOptions");
        if (options == null) {
            options = new JavaInsightOptions();
            ClientSetting.findOrCreate((String)"oracle.jdeveloper").putData("JavaInsightOptions", (Copyable)options);
        }
        return options;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        long current = System.currentTimeMillis();
        int remainingTime = (int)(this.cancelEndTime - current);
        if (remainingTime <= 0) {
            this.scheduleAssistance();
        } else {
            this.restartTimer(Math.max(100, remainingTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popupClosed(PopupWindow popupWindow, int how) {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.importPopup = null;
        }
    }

    public void editorFocusGained(PopupWindow popupWindow) {
    }

    public void editorFocusLost(PopupWindow popupWindow, boolean isTemporary) {
    }

    private TextBuffer getTextBuffer() {
        return this.getDocument().getTextBuffer();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    private void showTemporaryFeedback(String feedbackMessage, int delay) {
        FeedbackManager feedbackManager = this.editor.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(this.editor, feedbackMessage, delay);
        }
    }

    private JavaManager getJavaManager() {
        return this.smJavaManager;
    }

    private SourceFile getSourceFile() {
        return this.smFile;
    }

    private boolean hasSemanticErrors() {
        SourceError[] errors = this.getSemanticErrors();
        int numErrors = errors == null ? 0 : errors.length;
        return numErrors > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceError[] getSemanticErrors() {
        SourceError[] errors;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            errors = this.smErrors;
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getChangeId() {
        int changeId;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            changeId = this.smChangeId;
        }
        return changeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSemanticErrors(JavaManager javaManager, SourceFile file, SourceError[] errors, int changeId) {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.smJavaManager = javaManager;
            this.smFile = file;
            this.smErrors = errors;
            this.smChangeId = changeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSemanticErrors() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.smJavaManager = null;
            this.smErrors = null;
        }
    }

    private static ImportAssistPlugin lookupPlugin(BasicEditorPane editor) {
        return (ImportAssistPlugin)editor.getProperty(PLUGIN_KEY);
    }

    static void invokeImportAssistance(BasicEditorPane editor) {
        ImportAssistPlugin plugin = ImportAssistPlugin.lookupPlugin(editor);
        if (plugin != null) {
            skipImportPopup = true;
            plugin.respondUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respondUI() {
        Rectangle rect;
        SourceError error;
        String[] choices;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.importPopup != null) {
                PopupWindowManager pwManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
                pwManager.dismissPopup(this.importPopup);
                this.importPopup = null;
            } else if (this.project != null) {
                String message = JavaArb.getString(172);
                this.showTemporaryFeedback(message, 1000);
                this.stopTimer();
                this.cancelEndTime = System.currentTimeMillis();
                this.scheduleAssistance();
                return;
            }
            skipImportPopup = false;
            choices = this.importChoices;
            this.importChoices = null;
            error = this.importError;
            this.importError = null;
            rect = this.importRect;
            this.importRect = null;
        }
        if (choices != null) {
            if (choices.length == 1) {
                this.insertImport(choices[0], error, null);
            } else {
                this.showInsight(choices, rect, error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertImport(String importName, SourceError error, UndoableEdit autoEdit) {
        Rectangle visibleRect;
        int row;
        block25: {
            int line = this.editor.getLineFromOffset(this.editor.getCaret().getDot());
            row = this.editor.getRowForLine(line);
            visibleRect = this.editor.getVisibleRect();
            TextBuffer textBuffer = this.getTextBuffer();
            SourceFile sourceFile = error.getOwningSourceFile();
            int lastImportOffset = 0;
            List imports = sourceFile.getSourceImports();
            for (SourceImport sourceImport : imports) {
                lastImportOffset = Math.max(lastImportOffset, sourceImport.getEndOffset());
            }
            String replaceText = null;
            int replaceStart = -1;
            int replaceEnd = -1;
            try {
                JavaLexer lexer = new JavaLexer();
                LexerToken lexerToken = lexer.createLexerToken();
                lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                lexer.setPosition(error.getStartOffset());
                lexer.setSkipComments(true);
                lexer.setRecognizeSQLJ(true);
                int token = lexer.lex(lexerToken);
                if (token == 124) {
                    token = lexer.lex(lexerToken);
                }
                if (token == 4) {
                    String importClassName;
                    replaceStart = lexerToken.getStartOffset();
                    replaceEnd = lexerToken.getEndOffset();
                    String errorText = textBuffer.getString(replaceStart, replaceEnd - replaceStart);
                    int dot = importName.lastIndexOf(46);
                    String string = importClassName = dot != -1 ? importName.substring(dot + 1) : importName;
                    if (!errorText.equals(importClassName)) {
                        replaceText = importClassName;
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            textBuffer.writeLock();
            try {
                UndoableEdit edit;
                SourceTransaction transaction;
                this.inModify = true;
                OffsetMark replaceStartPosition = null;
                OffsetMark replaceEndPosition = null;
                if (replaceText != null) {
                    replaceStartPosition = textBuffer.addOffsetMark(replaceStart);
                    replaceEndPosition = textBuffer.addOffsetMark(replaceEnd);
                }
                UndoableEditCommand command = new UndoableEditCommand(JavaArb.getString(165), CodeEditor.getContext((BasicEditorPane)this.editor));
                boolean addedImport = false;
                try {
                    transaction = sourceFile.beginTransaction();
                }
                catch (ExpiredTextBufferException e) {
                    this.inModify = false;
                    textBuffer.writeUnlock();
                    return;
                }
                try {
                    addedImport = JavaHelper.addImport(sourceFile, importName) != null;
                }
                finally {
                    if (addedImport) {
                        edit = transaction.commit();
                        if (edit != null) {
                            command.addEdit(edit);
                        }
                        if (autoEdit != null) {
                            command.addEdit(autoEdit);
                        }
                    } else {
                        transaction.abort();
                    }
                }
                if (replaceText != null) {
                    replaceStart = replaceStartPosition.getOffset();
                    replaceEnd = replaceEndPosition.getOffset();
                    textBuffer.removeOffsetMark(replaceStartPosition);
                    textBuffer.removeOffsetMark(replaceEndPosition);
                    edit = textBuffer.remove(replaceStart, replaceEnd - replaceStart);
                    command.addEdit(edit);
                    edit = textBuffer.insert(replaceStart, replaceText.toCharArray());
                    command.addEdit(edit);
                }
                if (!command.hasEdits()) break block25;
                try {
                    CommandProcessor commandProcessor = CommandProcessor.getInstance();
                    commandProcessor.invoke((Command)command);
                    if (addedImport) {
                        String feedbackMessage = JavaArb.format(41, importName);
                        this.showTemporaryFeedback(feedbackMessage, 5000);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            finally {
                this.inModify = false;
                textBuffer.writeUnlock();
            }
        }
        int newLine = this.editor.getLineFromOffset(this.editor.getCaret().getDot());
        int newRow = this.editor.getRowForLine(newLine);
        int lineHeight = this.editor.getFontMetrics(this.editor.getFont()).getHeight();
        visibleRect.translate(0, (newRow - row) * lineHeight);
        this.editor.scrollRectToVisible(visibleRect);
        this.restartTimer();
    }

    private String getKeyText() {
        IdeSettings ideSettings = Ide.getSettings();
        KeyStrokeOptions ksOptions = ideSettings.getKeyStrokeOptions();
        if (ksOptions != null) {
            int cmdId;
            Integer iCmdId;
            List assistKeyStrokes;
            KeyStrokeMap ksMap = ksOptions.getGlobalKeyMap();
            IdeAction action = IdeAction.find((int)ImportController.IMPORT_ASSISTANCE_CMD_ID);
            if (action != null && (assistKeyStrokes = ksMap.getKeyStrokesFor(iCmdId = new Integer(cmdId = action.getCommandId()))).size() > 0) {
                KeyStrokes ks = (KeyStrokes)assistKeyStrokes.get(0);
                return ks.toString();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showUI(SourceError error, Rectangle caretRect, String[] choices) {
        if (this.editor == null || !this.editor.isShowing() || this.actionTipTask != null) {
            return;
        }
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            boolean caretInsideError;
            this.clearAssistance();
            if (!this.hasSemanticErrors()) {
                return;
            }
            String keyText = this.getKeyText();
            if (keyText == null || keyText.length() == 0) {
                String message = JavaArb.getString(170);
                this.showTemporaryFeedback(message, 5000);
                return;
            }
            this.importChoices = choices;
            this.importError = error;
            this.importRect = caretRect;
            boolean bl = caretInsideError = this.importError.getStartOffset() <= this.editor.getCaretPosition() && this.importError.getEndOffset() >= this.editor.getCaretPosition();
            if (!caretInsideError && this.tryAutoImport()) {
                return;
            }
            int numChoices = choices.length;
            String[] sortedChoices = new String[numChoices];
            for (int i = 0; i < numChoices; ++i) {
                sortedChoices[i] = ImportAssistPlugin.getClassPackageDisplayText(choices[i]);
            }
            String firstChoice = sortedChoices[0];
            int parenPos = firstChoice.indexOf(40);
            if (parenPos != -1) {
                String packageName = firstChoice.substring(parenPos + 1, firstChoice.length() - 1);
                String className = firstChoice.substring(0, parenPos - 1);
                firstChoice = packageName + "." + className;
            }
            int assistId = choices.length == 1 ? 168 : 169;
            String assistText = choices.length == 1 ? JavaArb.format(assistId, firstChoice, keyText) : JavaArb.format(assistId, nameInEditor, keyText);
            JLabel assistLabel = new JLabel(assistText);
            assistLabel.setOpaque(true);
            Border tooltipBorder = UIManager.getBorder("ToolTip.border");
            Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            CompoundBorder assistBorder = BorderFactory.createCompoundBorder(tooltipBorder, emptyBorder);
            assistLabel.setBorder(assistBorder);
            LookAndFeel.installColorsAndFont(assistLabel, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
            PopupWindowManager pwManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
            this.importPopup = pwManager.createPopup((Component)assistLabel, false);
            int[] locations = new int[]{4, 8};
            pwManager.positionPopup(this.importPopup, caretRect, locations);
            if (skipImportPopup) {
                this.respondUI();
            } else {
                pwManager.showPopup(this.importPopup, (PopupWindowListener)this);
            }
        }
    }

    private boolean tryAutoImport() {
        JavaImportOptions options = ImportAssistPlugin.getOptions();
        if (!options.getAutoImport()) {
            return false;
        }
        boolean foundCurrentMatch = false;
        SourceFile sourceFile = this.importError.getOwningSourceFile();
        for (SourceImport anImport : sourceFile.getSourceImports()) {
            String importName = anImport.getName();
            int dot = importName.lastIndexOf(46);
            String importClassName = dot != -1 ? importName.substring(dot + 1) : importName;
            if (!importClassName.startsWith(nameInEditor)) continue;
            foundCurrentMatch = true;
        }
        if (!foundCurrentMatch && this.importChoices != null && this.importChoices.length == 1) {
            if (this.doNotAutoImportList.contains(this.importChoices[0])) {
                return true;
            }
            int dot = this.importChoices[0].lastIndexOf(46);
            String choicesClassName = dot != -1 ? this.importChoices[0].substring(dot + 1) : this.importChoices[0];
            boolean importException = false;
            for (Object anImportException : options.getAutoImportExceptionList()) {
                if (!this.importChoices[0].startsWith(anImportException.toString())) continue;
                importException = true;
            }
            if (!importException && choicesClassName.equals(nameInEditor)) {
                if (this.actionTipTask == null) {
                    String importChoice = this.importChoices[0];
                    if (this.autoImportSet.contains(importChoice)) {
                        this.autoImportSet.remove(importChoice);
                        this.insertImport(importChoice, this.importError, new AutoUndoableEdit(importChoice));
                    } else {
                        this.actionTipTask = new AutoTipTask(importChoice, this.importError);
                        ActionTipManager.getActionTipManager().submitTipTask(this.actionTipTask);
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUI() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.importPopup != null) {
                final PopupWindowManager pwManager = PopupWindowManager.getPopupWindowManager((BasicEditorPane)this.editor);
                final PopupWindow popup = this.importPopup;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        pwManager.dismissPopup(popup);
                    }
                });
                this.importPopup = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showInsight(String[] choices, Rectangle rect, SourceError error) {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            Arrays.sort(choices, new SmartImportComparator(error.getOwningSourceFile(), CodeEditor.getContext((BasicEditorPane)this.editor), nameInEditor));
            this.assistInsight = new AssistInsight(choices, rect, error);
            this.editor.installPlugin((EditorPlugin)this.assistInsight);
            this.assistInsight.showInsight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelInsight() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.assistInsight != null) {
                this.clearInsight();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInsight() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.assistInsight != null) {
                AssistInsight tmpInsight = this.assistInsight;
                this.assistInsight = null;
                this.editor.deinstallPlugin((EditorPlugin)tmpInsight);
            }
        }
        this.restartTimer();
    }

    private static String getClassPackageDisplayText(String fqName) {
        int dotPos = fqName.lastIndexOf(46);
        if (dotPos != -1) {
            String packageName = fqName.substring(0, dotPos);
            String className = fqName.substring(dotPos + 1);
            return className + " (" + packageName + ")";
        }
        return fqName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleAssistance() {
        if (!this.editor.isEditable() || this.project == null || !this.hasSemanticErrors()) {
            return;
        }
        boolean uiUp = false;
        AssistanceTask task = new AssistanceTask(this, new LinkedList<String>(this.doNotPromptImportList));
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            if (this.asTask != null) {
                asScheduler.cancelTask((AsyncTask)this.asTask);
            }
            this.asTask = task;
            if (this.assistInsight != null || this.importPopup != null) {
                uiUp = true;
            }
        }
        if (!uiUp) {
            asScheduler.scheduleTask((AsyncTask)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAssistance() {
        AssistanceTask pendingTask;
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            pendingTask = this.asTask;
            this.asTask = null;
        }
        if (pendingTask != null) {
            asScheduler.cancelTask((AsyncTask)pendingTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAssistance() {
        ImportAssistPlugin importAssistPlugin = this;
        synchronized (importAssistPlugin) {
            this.asTask = null;
        }
    }

    static String getClassName(String classPackageName) {
        int dot = classPackageName.lastIndexOf(46);
        String className = dot != -1 ? classPackageName.substring(dot + 1) : classPackageName;
        return className;
    }

    static String getPackageName(String fqClassName) {
        int dot = fqClassName.lastIndexOf(46);
        String packageName = dot != -1 ? fqClassName.substring(0, dot) : "";
        return packageName;
    }

    static {
        asScheduler = new AsyncScheduler("ImportAssistance", 30000);
    }

    private static class ImportDataItemCellRenderer
    extends ListDataItemCellRenderer {
        Font normal;
        Font strikeThru;

        private ImportDataItemCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (this.normal == null) {
                this.normal = label.getFont();
                Map<TextAttribute, ?> attributes = this.normal.getAttributes();
                attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                this.strikeThru = new Font(attributes);
            }
            if (value instanceof AssistDataItem) {
                AssistDataItem assistDataItem = (AssistDataItem)value;
                label.setFont(assistDataItem.showStrikethru ? this.strikeThru : this.normal);
            } else {
                label.setFont(this.normal);
            }
            return label;
        }
    }

    private class AutoTipTask
    implements ActionTipTask {
        private String importChoice;
        private SourceError sourceError;

        public AutoTipTask(String importChoice, SourceError sourceError) {
            this.importChoice = importChoice;
            this.sourceError = sourceError;
        }

        public JComponent getActionTipContent() {
            if (ImportAssistPlugin.this.editor == null || this.sourceError == null) {
                return null;
            }
            String feedbackMessage = JavaArb.format(388, this.importChoice);
            ImportAssistPlugin.this.showTemporaryFeedback(feedbackMessage, 5000);
            return new DefaultActionTipComponent((ActionTipTask)this, JavaArb.getString(387), this.importChoice);
        }

        public JComponent getParentComponent() {
            return ImportAssistPlugin.this.editor;
        }

        public Rectangle getLocation() {
            if (ImportAssistPlugin.this.editor == null || this.sourceError == null) {
                return null;
            }
            try {
                Rectangle rect = ImportAssistPlugin.this.editor.modelToView(this.sourceError.getStartOffset());
                rect.add(ImportAssistPlugin.this.editor.modelToView(this.sourceError.getEndOffset()));
                return rect;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void actionTipResult(ActionTipManager.TaskResult result) {
            ImportAssistPlugin.this.actionTipTask = null;
            if (result == ActionTipManager.TaskResult.ACCEPTED) {
                ImportAssistPlugin.this.autoImportSet.add(this.importChoice);
                ImportAssistPlugin.this.insertImport(this.importChoice, this.sourceError, new AutoUndoableEdit(this.importChoice));
            } else if (result == ActionTipManager.TaskResult.REJECTED) {
                ImportAssistPlugin.this.doNotAutoImportList.add(this.importChoice);
            }
        }

        public boolean isCancelable() {
            return true;
        }
    }

    private class AutoUndoableEdit
    extends AbstractUndoableEdit {
        String importClass;

        public AutoUndoableEdit(String importClass) {
            this.importClass = importClass;
        }

        @Override
        public void undo() {
            if (!ImportAssistPlugin.this.doNotAutoImportList.contains(this.importClass)) {
                ImportAssistPlugin.this.doNotAutoImportList.add(this.importClass);
            }
        }
    }

    private static final class AssistanceTask
    extends AsyncTask {
        private ImportAssistPlugin asPlugin;
        private JavaSourceNode asNode;
        private boolean asCancelled;
        private List doNotPromptList;

        private AssistanceTask(ImportAssistPlugin plugin, List doNotPromptList) {
            this.asPlugin = plugin;
            this.asNode = plugin.javaNode;
            this.asCancelled = false;
            this.doNotPromptList = doNotPromptList;
        }

        protected void requestCancelImpl() {
            this.asCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.asCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object runImpl() throws AsyncTask.CancelledException {
            JavaImportOptions options;
            if (!this.asNode.isOpen() || this.asNode.isReadOnly()) {
                return null;
            }
            TextBuffer textBuffer = this.asNode.acquireTextBuffer();
            if (textBuffer == null) {
                return null;
            }
            this.bailIfCancelled();
            SourceError[] currentErrors = this.asPlugin.getSemanticErrors();
            int currentId = this.asPlugin.getChangeId();
            textBuffer.readLock();
            try {
                int changeId = textBuffer.getChangeId();
                if (changeId != currentId) {
                    currentErrors = null;
                    this.asPlugin.clearSemanticErrors();
                    currentId = changeId;
                }
            }
            finally {
                textBuffer.readUnlock();
            }
            this.bailIfCancelled();
            if (currentErrors == null || currentErrors.length == 0) {
                return null;
            }
            BasicEditorPane editor = this.asPlugin.editor;
            NumberRange visibleRange = AssistanceTask.taskGetVisibleOffsets(editor, textBuffer);
            int startOffset = visibleRange.start;
            int endOffset = visibleRange.end;
            this.bailIfCancelled();
            int caretPos = editor.getCaretPosition();
            SourceError[] visibleErrors = AssistanceTask.taskGetVisibleErrors(currentErrors, startOffset, endOffset, caretPos);
            this.bailIfCancelled();
            int numVisible = visibleErrors.length;
            if (numVisible == 0) {
                return null;
            }
            String[] visibleNames = AssistanceTask.taskGetClassNames(visibleErrors, textBuffer, currentId);
            Set validatedNameSet = AssistanceTask.taskFilterClassNames(visibleNames, options = ImportAssistPlugin.getOptions());
            if (validatedNameSet.size() == 0) {
                return null;
            }
            this.bailIfCancelled();
            SourceError possibleError = null;
            String[] possibleImports = null;
            nameInEditor = null;
            String notFoundMessage = null;
            for (int i = 0; i < numVisible; ++i) {
                boolean onCaret;
                int errorEnd;
                int errorStart;
                String errorText;
                int posOffset;
                this.bailIfCancelled();
                String name = visibleNames[i];
                if (!AssistanceTask.isValidClassName(name, options)) continue;
                SourceError currentError = visibleErrors[i];
                boolean includePrefixMatches = false;
                if (currentError.getStartOffset() <= caretPos && caretPos <= currentError.getEndOffset() && (posOffset = (errorText = textBuffer.getString(errorStart = currentError.getStartOffset(), (errorEnd = currentError.getEndOffset()) - errorStart)).indexOf(name)) != -1) {
                    int adjustedStart = errorStart + posOffset;
                    int adjustedEnd = adjustedStart + name.length();
                    if (adjustedStart <= caretPos && caretPos <= adjustedEnd) {
                        includePrefixMatches = true;
                    }
                }
                JavaManager javaManager = this.asPlugin.getJavaManager();
                JavaClassLocator locator = javaManager.getJavaClassLocator();
                List<String> classList = includePrefixMatches ? locator.getClassesByPrefix(name, options.getSearchClassesCaseSensitive()) : locator.getClassesByName(name, options.getSearchClassesCaseSensitive());
                this.bailIfCancelled();
                if (classList == null) {
                    if (notFoundMessage != null) continue;
                    notFoundMessage = JavaArb.format(171, name);
                    this.asPlugin.showTemporaryFeedback(notFoundMessage, 5000);
                    continue;
                }
                ArrayList<String> notImportedClassList = new ArrayList<String>();
                SourceFile file = currentError.getOwningSourceFile();
                Set importNames = file.getSourceImportNames();
                Iterator classIterator = classList.iterator();
                while (classIterator.hasNext()) {
                    String fqClassName = classIterator.next().toString();
                    int dotIndex = fqClassName.lastIndexOf(46);
                    if (dotIndex > 0 && fqClassName.substring(0, dotIndex).equals("java.lang") || importNames.contains(fqClassName)) continue;
                    notImportedClassList.add(fqClassName);
                }
                classList = notImportedClassList;
                if (options.getCheckPackageAccess()) {
                    String packageName = file.getPackageName();
                    AnnotationFilter filter = null;
                    try {
                        SourceFile sourceFile = this.asPlugin.getSourceFile();
                        SourceElement elementAt = sourceFile.getElementAt(caretPos);
                        if (elementAt != null) {
                            if (elementAt != null && elementAt.getSymbolKind() == 20) {
                                elementAt = elementAt.getParent();
                            }
                            if (elementAt != null && elementAt.getSymbolKind() == 1) {
                                filter = new AnnotationFilter();
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        filter = null;
                    }
                    CacheSupport cacheSupport = javaManager.getCacheSupport();
                    try {
                        cacheSupport.beginCacheUse();
                        classList = this.taskFilterVisibleClasses(javaManager, packageName, classList, (JavaFilter)filter);
                    }
                    finally {
                        cacheSupport.endCacheUse();
                    }
                }
                int numClasses = classList.size();
                boolean bl = onCaret = visibleErrors[i].getStartOffset() <= caretPos && visibleErrors[i].getEndOffset() >= caretPos;
                if (this.doNotPromptList.contains(name) && !skipImportPopup && !onCaret || numClasses <= 0) continue;
                possibleImports = classList.toArray(new String[numClasses]);
                possibleError = visibleErrors[i];
                nameInEditor = name;
                break;
            }
            this.bailIfCancelled();
            if (possibleError != null && possibleImports != null) {
                Rectangle fixRect;
                final SourceError fixError = possibleError;
                final String[] fixChoices = possibleImports;
                String fixNameInEditor = nameInEditor;
                try {
                    fixRect = editor.modelToView(fixError.getStartOffset());
                }
                catch (BadLocationException e) {
                    return null;
                }
                Runnable uiInvoker = new Runnable(){

                    @Override
                    public void run() {
                        if (!AssistanceTask.this.isCancelledImpl()) {
                            AssistanceTask.this.asPlugin.showUI(fixError, fixRect, fixChoices);
                        }
                    }
                };
                SwingUtilities.invokeLater(uiInvoker);
            }
            return null;
        }

        private static boolean isErrorVisible(SourceError error, int startOffset, int endOffset) {
            int errorEnd = error.getEndOffset();
            int errorStart = error.getStartOffset();
            if (startOffset < errorEnd && errorEnd <= endOffset) {
                return true;
            }
            return startOffset <= errorStart && errorStart < endOffset;
        }

        private static String stripName(String name) {
            int otherParenPos;
            int parenPos;
            int anglePos;
            int dotPos;
            int arrayPos;
            if (name.startsWith("new ")) {
                name = name.substring(4);
            }
            if ((arrayPos = name.indexOf(91)) != -1) {
                name = name.substring(0, arrayPos);
            }
            if ((dotPos = name.indexOf(46)) != -1) {
                name = name.substring(0, dotPos);
            }
            if ((anglePos = name.indexOf(60)) != -1) {
                name = name.substring(0, anglePos);
            }
            if ((parenPos = name.indexOf(40)) != -1) {
                name = name.substring(0, parenPos);
            }
            if ((otherParenPos = name.indexOf(41)) != -1) {
                name = name.substring(0, otherParenPos);
            }
            return name.trim();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static NumberRange taskGetVisibleOffsets(BasicEditorPane editor, TextBuffer textBuffer) {
            if (editor == null) {
                return null;
            }
            Rectangle visibleRect = editor.getVisibleRect();
            if (visibleRect == null) {
                return null;
            }
            textBuffer.readLock();
            try {
                int fontHeight = BasicAction.getFontHeight((BasicEditorPane)editor);
                int ADJUST = fontHeight * 3 / 4;
                Point startPoint = new Point(visibleRect.x, visibleRect.y + ADJUST);
                int startOffset = editor.viewToModel(startPoint);
                Point endPoint = new Point(visibleRect.x + visibleRect.width - 1, visibleRect.y + visibleRect.height - 1 - ADJUST);
                int endOffset = editor.viewToModel(endPoint);
                if (startOffset == -1 || endOffset == -1) {
                    NumberRange numberRange = null;
                    return numberRange;
                }
                int startLine = editor.getLineFromOffset(startOffset);
                int endLine = editor.getLineFromOffset(endOffset);
                startOffset = Math.min(startOffset, editor.getLineStartOffset(startLine));
                endOffset = Math.max(endOffset, editor.getLineEndOffset(endLine));
                NumberRange numberRange = new NumberRange(startOffset, endOffset);
                return numberRange;
            }
            finally {
                textBuffer.readUnlock();
            }
        }

        private static SourceError[] taskGetVisibleErrors(SourceError[] errors, int startOffset, int endOffset, int caretPos) {
            int numErrors;
            int n = numErrors = errors != null ? errors.length : 0;
            if (numErrors == 0) {
                return new SourceError[0];
            }
            ArrayList<SourceError> visibleList = new ArrayList<SourceError>();
            for (int i = 0; i < numErrors; ++i) {
                SourceError error = errors[i];
                if (!AssistanceTask.isErrorVisible(error, startOffset, endOffset)) continue;
                if (error.getStartOffset() <= caretPos && error.getEndOffset() >= caretPos) {
                    visibleList.add(0, error);
                    continue;
                }
                visibleList.add(error);
            }
            int numVisible = visibleList.size();
            return visibleList.toArray(new SourceError[numVisible]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String[] taskGetClassNames(SourceError[] errors, TextBuffer textBuffer, int expectedChangeId) {
            int numErrors = errors.length;
            String[] names = new String[numErrors];
            textBuffer.readLock();
            try {
                if (textBuffer.getChangeId() != expectedChangeId) {
                    String[] stringArray = null;
                    return stringArray;
                }
                for (int i = 0; i < numErrors; ++i) {
                    SourceError error = errors[i];
                    int start = error.getStartOffset();
                    int end = error.getEndOffset();
                    String errorName = textBuffer.getString(start, end - start);
                    names[i] = AssistanceTask.stripName(errorName);
                }
            }
            finally {
                textBuffer.readUnlock();
            }
            return names;
        }

        private static boolean isValidClassName(String name, JavaImportOptions options) {
            int len;
            int n = len = name == null ? 0 : name.length();
            if (len == 0) {
                return false;
            }
            if (options.getIgnoreShortClasses() && len <= 2) {
                return false;
            }
            return !options.getIgnoreNonUppercase() || Character.isUpperCase(name.charAt(0));
        }

        private static Set taskFilterClassNames(String[] names, JavaImportOptions options) {
            ArraySortedSet nameSet = new ArraySortedSet();
            int numNames = names == null ? 0 : names.length;
            for (int i = 0; i < numNames; ++i) {
                String name = names[i];
                if (!AssistanceTask.isValidClassName(name, options)) continue;
                nameSet.add(name);
            }
            return nameSet;
        }

        private List taskFilterVisibleClasses(JavaManager javaManager, String packageName, Collection classes, JavaFilter filter) {
            ArrayList<String> filteredList = new ArrayList<String>();
            Iterator classIterator = classes.iterator();
            while (classIterator.hasNext()) {
                int itsModifiers;
                String fqClassName = classIterator.next().toString();
                String itsPackage = ImportAssistPlugin.getPackageName(fqClassName);
                JavaClass itsClass = javaManager.getClass(fqClassName);
                if (filter != null && itsClass != null && !filter.accepts((JavaElement)itsClass)) continue;
                if (packageName.equals(itsPackage)) {
                    filteredList.add(fqClassName);
                    continue;
                }
                if (itsClass == null || !Modifier.isPublic(itsModifiers = itsClass.getModifiers())) continue;
                filteredList.add(fqClassName);
            }
            return filteredList;
        }
    }

    private final class AssistInsight
    extends AbstractInsight
    implements InsightProvider {
        private InsightData asData;
        private Rectangle asRect;

        private AssistInsight(String[] importChoices, Rectangle importRect, SourceError error) {
            this.asData = new AssistData(importChoices, error);
            this.asRect = importRect;
        }

        public void install(BasicEditorPane editor) {
            super.install(editor);
        }

        public void deinstall(BasicEditorPane editor) {
            super.deinstall(editor);
        }

        protected InsightProvider createInsightProvider() {
            return this;
        }

        public boolean isInsightTriggerChar(char typedChar) {
            return false;
        }

        public void characterTyped(BasicEditorPane editorPane, int offset, char typedChar) {
        }

        public Rectangle getShowRectangle() {
            return this.asRect;
        }

        protected void updateInsight() {
        }

        public void hideInsight() {
            super.hideInsight();
            ImportAssistPlugin.this.clearInsight();
        }

        protected int[] getPreferredLocations() {
            return TOOLTIP_LOCATIONS;
        }

        public InsightData getInsightData(BasicEditorPane editorPane) {
            return this.asData;
        }

        public InsightData updateInsightData(BasicEditorPane editorPane, InsightData lastData) {
            return lastData;
        }

        public InsightView getInsightView() {
            return new ListInsightView((ListCellRenderer)((Object)new ImportDataItemCellRenderer()));
        }
    }

    private final class AssistData
    implements ListInsightData {
        private List<ListDataItem> asData = new ArrayList<ListDataItem>();
        private ListModel asModel;
        private SourceError asError;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AssistData(String[] choices, SourceError error) {
            this.asError = error;
            Icon interfaceIcon = OracleIcons.getIcon((String)"interface.png");
            Icon classIcon = OracleIcons.getIcon((String)"class.png");
            boolean showDeprecated = ImportAssistPlugin.getInsightOptions().getShowDeprecated();
            boolean strikethruDeprecated = ImportAssistPlugin.getInsightOptions().getStrikethruDeprecated();
            JavaManager javaManager = ImportAssistPlugin.this.getJavaManager();
            if (javaManager == null) {
                return;
            }
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            try {
                for (String choice : choices) {
                    Icon icon;
                    JavaClass jc = javaManager.getClass(choice);
                    Icon icon2 = icon = jc != null && jc.isInterface() ? interfaceIcon : classIcon;
                    if (jc != null && jc.isDeprecated() && !showDeprecated) continue;
                    this.asData.add(new AssistDataItem(choice, icon, jc != null && jc.isDeprecated() && strikethruDeprecated));
                }
            }
            finally {
                cacheSupport.endCacheUse();
            }
        }

        public ListModel getListModel() {
            if (this.asModel == null) {
                this.asModel = new ReadOnlyListModel(this.getData());
            }
            return this.asModel;
        }

        public Object[] getData() {
            return this.asData.toArray(new ListDataItem[this.asData.size()]);
        }

        public Object[] getMatchingData() {
            return this.getData();
        }

        public int getMatchingDataCount() {
            return this.asData.size();
        }

        public Object getDefault() {
            return this.asData.get(0);
        }

        public boolean complete(Object selectedObject) {
            ImportAssistPlugin.this.insertImport(((ListDataItem)selectedObject).getName(), this.asError, null);
            return false;
        }

        public void partialComplete() {
        }
    }

    private static final class AssistDataItem
    extends ListDataItem
    implements Comparable {
        private String asName;
        private Icon asIcon;
        private String displayName;
        private boolean showStrikethru;

        private AssistDataItem(String name, Icon icon, boolean showStrikethru) {
            this.asName = name;
            this.asIcon = icon;
            this.displayName = ImportAssistPlugin.getClassPackageDisplayText(this.asName);
            this.showStrikethru = showStrikethru;
        }

        public Icon getIcon() {
            return this.asIcon;
        }

        public String getDisplayText() {
            return this.displayName;
        }

        public String getName() {
            return this.asName;
        }

        public int compareTo(Object obj) {
            String name1 = this.getDisplayText();
            String name2 = ((AssistDataItem)obj).getDisplayText();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

