/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.folding;

import java.util.List;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdevimpl.java.folding.AbstractJavaFoldingBlock;
import oracle.jdevimpl.java.folding.JavaMethodBlock;

final class ParameterAnnotationBlock
extends AbstractJavaFoldingBlock {
    protected static final String REPLACEMENT_TEXT = "@annotations";
    private Object key;

    public ParameterAnnotationBlock(SourceFormalParameter parameter, boolean isExpanded) {
        super((SourceElement)parameter, REPLACEMENT_TEXT, isExpanded);
        List annotations = parameter.getSourceAnnotations();
        int start = -1;
        int end = -1;
        for (SourceAnnotation annotation : annotations) {
            if (start == -1 || annotation.getStartOffset() < start) {
                start = annotation.getStartOffset();
            }
            if (end != -1 && annotation.getEndOffset() <= end) continue;
            end = annotation.getEndOffset();
        }
        if (annotations.size() == 1) {
            SourceAnnotation annotation = (SourceAnnotation)annotations.get(0);
            if (annotation.getArgumentCount() > 0) {
                this.setReplacementText("@" + annotation.getName() + "(...)");
            } else {
                this.setReplacementText("@" + annotation.getName());
            }
        }
        this.setStartOffset(start);
        this.setEndOffset(end);
    }

    public void setUserObject(Object object) {
        this.key = null;
        super.setUserObject(object);
    }

    @Override
    public Object getId() {
        if (this.key == null) {
            SourceElement element;
            String newKey = "";
            SourceFormalParameter parameter = (SourceFormalParameter)this.getSym();
            for (element = parameter.getParent(); element != null && !(element instanceof SourceMethod); element = element.getParent()) {
            }
            if (element instanceof SourceMethod) {
                newKey = newKey + JavaMethodBlock.getMethodId((SourceMethod)element);
            }
            if (parameter.getParent() instanceof SourceFormalParameterList) {
                newKey = newKey + ":" + ((SourceFormalParameterList)parameter.getParent()).getSourceParameters().indexOf(parameter);
            }
            this.key = newKey;
        }
        return this.key;
    }
}

