/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.folding;

import java.util.List;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdevimpl.java.folding.AbstractJavaMemberBlock;

final class JavaMethodBlock
extends AbstractJavaMemberBlock {
    private Object key;

    public JavaMethodBlock(SourceMethod method, boolean isExpanded) {
        super((SourceMember)method, isExpanded);
        SourceBlock block = method.getBlock();
        this.setStartOffset(block.getStartOffset());
        this.setEndOffset(block.getEndOffset());
    }

    public void setUserObject(Object object) {
        this.key = null;
        super.setUserObject(object);
    }

    @Override
    protected Object getId() {
        if (this.key == null) {
            SourceMethod method = this.getMethodSym();
            this.key = JavaMethodBlock.getMethodId(method);
        }
        return this.key;
    }

    protected SourceMethod getMethodSym() {
        return (SourceMethod)this.getSym();
    }

    protected static Object getMethodId(SourceMethod method) {
        StringBuffer id = new StringBuffer();
        String name = method.getName();
        id.append(name);
        id.append("(");
        List params = method.getSourceParameters();
        for (SourceVariable param : params) {
            JavaType resolvedType = param.getResolvedType();
            if (resolvedType != null) {
                id.append(resolvedType.getDescriptor());
                continue;
            }
            id.append('V');
        }
        id.append(")");
        return id.toString();
    }
}

