/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.folding;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Project;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.AbstractCodeFoldingPlugin;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.editor.folding.FoldingBlock;
import oracle.javatools.parser.java.v2.internal.symbol.CommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.PackageSym;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;
import oracle.jdevimpl.java.folding.AbstractJavaFoldingBlock;
import oracle.jdevimpl.java.folding.AnnotationBlock;
import oracle.jdevimpl.java.folding.JavaClassBlock;
import oracle.jdevimpl.java.folding.JavaCodeFoldingModel;
import oracle.jdevimpl.java.folding.JavaCodeFoldingOptions;
import oracle.jdevimpl.java.folding.JavaFileBlock;
import oracle.jdevimpl.java.folding.JavaImportsBlock;
import oracle.jdevimpl.java.folding.JavaInitialCommentBlock;
import oracle.jdevimpl.java.folding.JavaInitializerBlock;
import oracle.jdevimpl.java.folding.JavaMethodBlock;
import oracle.jdevimpl.java.folding.JavadocBlock;
import oracle.jdevimpl.java.folding.ParameterAnnotationBlock;

public class JavaCodeFoldingPlugin
extends AbstractCodeFoldingPlugin
implements CodeFoldingProvider,
JavaParserPlugin.HelperClient {
    protected JPopupMenu popup;
    protected Thread modelUpdateThread;
    private static final JavaCodeFoldingController JAVA_FOLDING_CONTROLLER = new JavaCodeFoldingController();
    private static final int COLLAPSE_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaCodeFoldingPlugin.COLLAPSE_ANNOTATIONS_CMD_ID");
    private static final int EXPAND_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaCodeFoldingPlugin.EXPAND_ANNOTATIONS_CMD_ID");
    private static IdeAction collapseAllAction = IdeAction.get((int)55);
    private static IdeAction collapseJavadocAction;
    private static IdeAction collapseMethodsAction;
    private static IdeAction collapseAnnotationsAction;
    private static IdeAction expandAllAction;
    private static IdeAction expandJavadocAction;
    private static IdeAction expandMethodsAction;
    private static IdeAction expandAnnotationsAction;

    protected CodeFoldingProvider createProvider() {
        return this;
    }

    protected void attach(BasicEditorPane editorPane) {
        super.attach(editorPane);
        JavaParserPlugin.attachHelperClient(editorPane, this);
    }

    protected void detach(BasicEditorPane editorPane) {
        this.interruptUpdateThread();
        JavaParserPlugin.detachHelperClient(editorPane, this);
        super.detach(editorPane);
    }

    public CodeFoldingModel createModel(BasicEditorPane editorPane) {
        SourceFile sourceFile = this.getSourceFile();
        if (sourceFile == null) {
            return null;
        }
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        JavaCodeFoldingModel model = new JavaCodeFoldingModel(document);
        JavaCodeFoldingOptions options = JavaCodeFoldingPlugin.getCodeFoldingOptions();
        TextBuffer buffer = document.getTextBuffer();
        int changeId = buffer.getChangeId();
        this.updateModelImmediate(model, sourceFile, changeId, options);
        return model;
    }

    public void insertUpdate(CodeFoldingModel model, int offset, int length) {
        this.interruptUpdateThread();
        JavaCodeFoldingModel m = (JavaCodeFoldingModel)model;
        m.insertUpdate(offset, length);
        m.reload();
    }

    public void removeUpdate(CodeFoldingModel model, int offset, int length) {
        this.interruptUpdateThread();
        JavaCodeFoldingModel m = (JavaCodeFoldingModel)model;
        m.removeUpdate(offset, length);
        m.reload();
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            IdeAction[] popupActions = new IdeAction[]{collapseJavadocAction, collapseMethodsAction, collapseAnnotationsAction, collapseAllAction, null, expandJavadocAction, expandMethodsAction, expandAnnotationsAction, expandAllAction};
            this.popup = new JPopupMenu();
            for (int i = 0; i < popupActions.length; ++i) {
                IdeAction action = popupActions[i];
                if (action != null) {
                    JMenuItem item = Ide.getMenubar().createMenuItem((ToggleAction)action);
                    this.popup.add(item);
                    continue;
                }
                this.popup.addSeparator();
            }
            JMenuItem preferencesItem = new JMenuItem(new PreferencesAction());
            this.popup.addSeparator();
            this.popup.add(preferencesItem);
        }
        CodeFoldingMargin margin = this.getMargin();
        int i = this.popup.getComponentCount();
        while (i-- > 0) {
            AbstractButton b;
            Action action;
            Component c = this.popup.getComponent(i);
            if (!(c instanceof AbstractButton) || !((action = (b = (AbstractButton)c).getAction()) instanceof IdeAction)) continue;
            JavaCodeFoldingController.update((IdeAction)action, margin);
        }
        return this.popup;
    }

    @Override
    public void notifyCompileScheduled() {
    }

    @Override
    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        int lastChangeId;
        JavaCodeFoldingModel model = (JavaCodeFoldingModel)this.getModel();
        if (model == null) {
            return;
        }
        model.readLock();
        try {
            lastChangeId = model.getLastChangeId();
        }
        finally {
            model.readUnlock();
        }
        if (changeId != lastChangeId) {
            this.updateModelAsync(model, sourceFile, changeId);
        }
    }

    private void updateModelImmediate(final JavaCodeFoldingModel model, SourceFile sourceFile, final int changeId, JavaCodeFoldingOptions options) {
        Object root;
        try {
            root = this.createFoldingTree((CodeFoldingModel)model, sourceFile, options);
        }
        catch (InterruptedException ex) {
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        Runnable doFinished = new Runnable(){

            @Override
            public void run() {
                BasicEditorPane editorPane = JavaCodeFoldingPlugin.this.getEditorPane();
                if (editorPane != null) {
                    CodeFoldingMargin margin = JavaCodeFoldingPlugin.this.getMargin();
                    int caretPosition = editorPane.getCaretPosition();
                    model.setRoot(root, changeId);
                    margin.expandEnclosingBlocks(caretPosition);
                    margin.repaint();
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(doFinished);
        } else {
            doFinished.run();
        }
    }

    private void updateModelAsync(final JavaCodeFoldingModel model, final SourceFile sourceFile, final int changeId) {
        if (this.modelUpdateThread != null) {
            return;
        }
        Runnable doUpdate = new Runnable(){

            @Override
            public void run() {
                JavaCodeFoldingPlugin.this.updateModelImmediate(model, sourceFile, changeId, null);
                JavaCodeFoldingPlugin.this.modelUpdateThread = null;
            }
        };
        this.modelUpdateThread = new Thread(doUpdate, "JavaCodeFold");
        this.modelUpdateThread.setPriority(1);
        this.modelUpdateThread.start();
    }

    private void interruptUpdateThread() {
        if (this.modelUpdateThread != null) {
            this.modelUpdateThread.interrupt();
            this.modelUpdateThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createFoldingTree(CodeFoldingModel model, SourceFile sourceFile, JavaCodeFoldingOptions options) throws InterruptedException {
        AbstractJavaFoldingBlock newRoot = this.createFoldingTree(sourceFile, options);
        model.readLock();
        try {
            AbstractJavaFoldingBlock oldRoot = (AbstractJavaFoldingBlock)((Object)model.getRoot());
            if (oldRoot != null) {
                this.reconcileFoldingState(oldRoot, newRoot);
            }
        }
        finally {
            model.readUnlock();
        }
        this.checkIfInterrupted();
        return newRoot;
    }

    protected AbstractJavaFoldingBlock createFoldingTree(SourceFile sourceFile, JavaCodeFoldingOptions options) throws InterruptedException {
        return this.createFileBlock(sourceFile, options);
    }

    protected void reconcileFoldingState(AbstractJavaFoldingBlock oldBlock, AbstractJavaFoldingBlock newBlock) throws InterruptedException {
        Object key;
        this.checkIfInterrupted();
        HashMap<Object, AbstractJavaFoldingBlock> childMap = new HashMap<Object, AbstractJavaFoldingBlock>();
        Iterator it = oldBlock.getChildren();
        while (it.hasNext()) {
            AbstractJavaFoldingBlock oldChild = (AbstractJavaFoldingBlock)((Object)it.next());
            this.checkIfInterrupted();
            key = oldChild.getId();
            childMap.put(key, oldChild);
        }
        it = newBlock.getChildren();
        while (it.hasNext()) {
            AbstractJavaFoldingBlock newChild = (AbstractJavaFoldingBlock)((Object)it.next());
            this.checkIfInterrupted();
            key = newChild.getId();
            AbstractJavaFoldingBlock oldChild = (AbstractJavaFoldingBlock)((Object)childMap.remove(key));
            if (oldChild != null) {
                boolean isExpanded = oldChild.isExpanded();
                newChild.setExpanded(isExpanded);
            }
            if (oldChild == null) continue;
            this.reconcileFoldingState(oldChild, newChild);
        }
    }

    protected void checkIfInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    protected Context getContext() {
        return CodeEditor.getContext((BasicEditorPane)this.getEditorPane());
    }

    protected Project getProject() {
        Context context = this.getContext();
        Project project = context.getProject();
        if (project == null && (project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        return project;
    }

    protected SourceFile getSourceFile() {
        Project project = this.getProject();
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        Context context = this.getContext();
        URL url = context.getNode().getURL();
        return javaManager.getSourceFile(url);
    }

    protected JavaFileBlock createFileBlock(SourceFile sourceFile, JavaCodeFoldingOptions options) throws InterruptedException {
        JavaFileBlock fileBlock = new JavaFileBlock(sourceFile);
        this.addInitialCommentBlock(sourceFile, options, (FoldingBlock)fileBlock);
        this.addSourceImportBlock(sourceFile, options, (FoldingBlock)fileBlock);
        this.addChildBlocks((SourceElement)sourceFile, options, (FoldingBlock)fileBlock);
        return fileBlock;
    }

    protected JavaImportsBlock createImportBlock(SourceFile sourceFile, JavaCodeFoldingOptions options) throws InterruptedException {
        List imports = sourceFile.getSourceImports();
        if (imports.isEmpty()) {
            return null;
        }
        int importStart = Integer.MAX_VALUE;
        int importEnd = 0;
        for (SourceImport sourceImport : imports) {
            importStart = Math.min(importStart, sourceImport.getStartOffset());
            importEnd = Math.max(importEnd, sourceImport.getEndOffset());
        }
        if (this.isValidBlock(importStart, importEnd, "import ...;")) {
            boolean isFolded = options != null ? options.getFoldImports() : false;
            return new JavaImportsBlock(importStart, importEnd, !isFolded);
        }
        return null;
    }

    protected JavaInitialCommentBlock createInitialCommentBlock(SourceFile sourceFile, JavaCodeFoldingOptions options) throws InterruptedException {
        for (Object child : sourceFile.getChildren(196608)) {
            if (child instanceof PackageSym) continue;
            if (!(child instanceof CommentSym)) break;
            CommentSym comment = (CommentSym)child;
            if (this.getCommentType(comment) == CommentType.SLASHES) continue;
            if (!this.isValidBlock(comment.getStartOffset(), comment.getEndOffset(), "/*...*/")) break;
            boolean isFolded = options != null ? options.getFoldInitialComments() : false;
            return new JavaInitialCommentBlock((SourceElement)comment, !isFolded);
        }
        return null;
    }

    private CommentType getCommentType(CommentSym comment) {
        String text = comment.getText();
        if (text != null) {
            if ((text = text.trim()).startsWith("//")) {
                return CommentType.SLASHES;
            }
            if (text.startsWith("/**")) {
                return CommentType.DOUBLE_ASTERIX;
            }
            if (text.startsWith("/*")) {
                return CommentType.SINGLE_ASTERIX;
            }
        }
        return null;
    }

    protected JavaClassBlock createClassBlock(SourceClass cls, JavaCodeFoldingOptions options) throws InterruptedException {
        boolean isFolded = cls.isAnonymous() ? (options != null ? options.getFoldAnonymousClasses() : false) : (cls.isMemberClass() ? (options != null ? options.getFoldInnerClasses() : false) : false);
        SourceClassBody classBody = cls.getSourceBody();
        if (this.isValidBlock((SourceElement)classBody, "{...}")) {
            JavaClassBlock classBlock = new JavaClassBlock(cls, !isFolded);
            this.addChildBlocks((SourceElement)classBody, options, (FoldingBlock)classBlock);
            return classBlock;
        }
        return null;
    }

    protected JavaMethodBlock createMethodBlock(SourceMethod method, JavaCodeFoldingOptions options, boolean isFolded) throws InterruptedException {
        SourceBlock block = method.getBlock();
        if (this.isValidBlock((SourceElement)block, "{...}")) {
            JavaMethodBlock methodBlock = new JavaMethodBlock(method, !isFolded);
            this.addChildBlocks((SourceElement)block, options, (FoldingBlock)methodBlock);
            return methodBlock;
        }
        return null;
    }

    protected JavaInitializerBlock createInitializerBlock(SourceClassInitializer initializer, JavaCodeFoldingOptions options, boolean isFolded) throws InterruptedException {
        SourceBlock block = initializer.getBlock();
        if (this.isValidBlock((SourceElement)block, "{...}")) {
            JavaInitializerBlock initializerBlock = new JavaInitializerBlock(initializer, !isFolded);
            this.addChildBlocks((SourceElement)block, options, (FoldingBlock)initializerBlock);
            return initializerBlock;
        }
        return null;
    }

    protected JavadocBlock createDocCommentBlock(SourceMember member, JavaCodeFoldingOptions options) throws InterruptedException {
        boolean isFolded;
        JavadocBlock javadocBlock;
        SourceDocComment docComment = member.getDocComment();
        if (docComment != null && this.isValidBlock((SourceElement)docComment, (javadocBlock = new JavadocBlock(member, !(isFolded = options != null ? options.getFoldJavadoc() : false))).getReplacementText())) {
            return javadocBlock;
        }
        return null;
    }

    protected AnnotationBlock createAnnotationBlock(SourceMember member, JavaCodeFoldingOptions options) throws InterruptedException {
        boolean isFolded;
        AnnotationBlock annotationBlock;
        List annotations = member.getSourceAnnotations();
        if (annotations != null && this.isValidBlock((annotationBlock = new AnnotationBlock(member, !(isFolded = options != null ? options.getFoldAnnotation() : false))).getStartOffset(), annotationBlock.getEndOffset(), annotationBlock.getReplacementText())) {
            return annotationBlock;
        }
        return null;
    }

    protected ParameterAnnotationBlock createParameterAnnotationBlock(SourceMethod method, JavaCodeFoldingOptions options) throws InterruptedException {
        SourceFormalParameterList fpList = method.getFormalParameterList();
        if (fpList == null) {
            return null;
        }
        for (SourceFormalParameter parameter : fpList.getSourceParameters()) {
            boolean isFolded;
            ParameterAnnotationBlock annotationBlock;
            List annotations = parameter.getSourceAnnotations();
            if (annotations == null || !this.isValidBlock((annotationBlock = new ParameterAnnotationBlock(parameter, !(isFolded = options != null ? options.getFoldAnnotation() : false))).getStartOffset(), annotationBlock.getEndOffset(), annotationBlock.getReplacementText())) continue;
            return annotationBlock;
        }
        return null;
    }

    protected void addChildBlocks(SourceElement element, JavaCodeFoldingOptions options, FoldingBlock block) throws InterruptedException {
        List children = element.getChildren();
        for (SourceElement child : children) {
            this.checkIfInterrupted();
            this.addSourceBlock(child, options, block);
        }
    }

    protected void addSourceBlock(SourceElement element, JavaCodeFoldingOptions options, FoldingBlock parent) throws InterruptedException {
        int kind = element.getSymbolKind();
        if (kind == 3) {
            SourceClass cls = (SourceClass)element;
            this.addSourceClassBlock(cls, options, parent);
        } else if (kind == 5) {
            SourceClassInitializer initializer = (SourceClassInitializer)element;
            boolean isFolded = options != null ? options.getFoldInitializers() : false;
            this.addSourceInitializerBlock(initializer, options, isFolded, parent);
        } else if (kind == 6) {
            SourceMethod constructor = (SourceMethod)element;
            boolean isFolded = options != null ? options.getFoldConstructors() : false;
            this.addSourceMethodBlock(constructor, options, isFolded, parent);
        } else if (kind == 19) {
            SourceMethod method = (SourceMethod)element;
            boolean isFolded = options != null ? options.getFoldMethods() : false;
            this.addSourceMethodBlock(method, options, isFolded, parent);
        } else if (kind == 10) {
            SourceFieldVariable field = (SourceFieldVariable)element;
            this.addSourceFieldBlock(field, options, parent);
        } else {
            this.addChildBlocks(element, options, parent);
        }
    }

    protected void addSourceImportBlock(SourceFile sourceFile, JavaCodeFoldingOptions options, FoldingBlock parent) throws InterruptedException {
        JavaImportsBlock importBlock = this.createImportBlock(sourceFile, options);
        if (importBlock != null) {
            parent.add((FoldingBlock)importBlock);
        }
    }

    protected void addInitialCommentBlock(SourceFile sourceFile, JavaCodeFoldingOptions options, FoldingBlock parent) throws InterruptedException {
        JavaInitialCommentBlock initialCommentBlock = this.createInitialCommentBlock(sourceFile, options);
        if (initialCommentBlock != null) {
            parent.add((FoldingBlock)initialCommentBlock);
        }
    }

    protected void addSourceClassBlock(SourceClass cls, JavaCodeFoldingOptions options, FoldingBlock parent) throws InterruptedException {
        this.addDocCommentBlock((SourceMember)cls, options, parent);
        this.addAnnotationBlock((SourceMember)cls, options, parent);
        JavaClassBlock classBlock = this.createClassBlock(cls, options);
        if (classBlock != null) {
            parent.add((FoldingBlock)classBlock);
        }
    }

    protected void addSourceMethodBlock(SourceMethod method, JavaCodeFoldingOptions options, boolean isFolded, FoldingBlock parent) throws InterruptedException {
        this.addDocCommentBlock((SourceMember)method, options, parent);
        this.addAnnotationBlock((SourceMember)method, options, parent);
        JavaMethodBlock methodBlock = this.createMethodBlock(method, options, isFolded);
        if (methodBlock != null) {
            parent.add((FoldingBlock)methodBlock);
        }
    }

    protected void addSourceInitializerBlock(SourceClassInitializer initializer, JavaCodeFoldingOptions options, boolean isFolded, FoldingBlock parent) throws InterruptedException {
        this.addDocCommentBlock((SourceMember)initializer, options, parent);
        JavaInitializerBlock methodBlock = this.createInitializerBlock(initializer, options, isFolded);
        if (methodBlock != null) {
            parent.add((FoldingBlock)methodBlock);
        }
    }

    protected void addSourceFieldBlock(SourceFieldVariable field, JavaCodeFoldingOptions options, FoldingBlock parent) throws InterruptedException {
        this.addDocCommentBlock((SourceMember)field, options, parent);
        this.addAnnotationBlock((SourceMember)field, options, parent);
        this.addChildBlocks((SourceElement)field, options, parent);
    }

    protected void addDocCommentBlock(SourceMember member, JavaCodeFoldingOptions options, FoldingBlock parent) throws InterruptedException {
        JavadocBlock docCommentBlock = this.createDocCommentBlock(member, options);
        if (docCommentBlock != null) {
            parent.add((FoldingBlock)docCommentBlock);
        }
    }

    protected void addAnnotationBlock(SourceMember member, JavaCodeFoldingOptions options, FoldingBlock parent) throws InterruptedException {
        AnnotationBlock block = this.createAnnotationBlock(member, options);
        if (block != null) {
            parent.add((FoldingBlock)block);
        }
    }

    protected void addParameterAnnotationBlock(SourceMethod method, JavaCodeFoldingOptions options, FoldingBlock parent) throws InterruptedException {
        ParameterAnnotationBlock block = this.createParameterAnnotationBlock(method, options);
        if (block != null) {
            parent.add((FoldingBlock)block);
        }
    }

    protected boolean isValidBlock(SourceElement sym, String replacement) throws InterruptedException {
        if (sym != null) {
            int startOffset = sym.getStartOffset();
            int endOffset = sym.getEndOffset();
            return this.isValidBlock(startOffset, endOffset, replacement);
        }
        return false;
    }

    protected boolean isValidBlock(int startOffset, int endOffset, String replacement) throws InterruptedException {
        int endLine;
        BasicEditorPane editorPane = this.getEditorPane();
        if (editorPane == null) {
            throw new InterruptedException();
        }
        int length = endOffset - startOffset;
        int replacementLength = replacement.length();
        if (length > replacementLength) {
            return true;
        }
        int startLine = editorPane.getLineFromOffset(startOffset);
        return startLine != (endLine = editorPane.getLineFromOffset(endOffset));
    }

    protected static JavaCodeFoldingOptions getCodeFoldingOptions() {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        return (JavaCodeFoldingOptions)settings.getData("JavaCodeFoldingOptions");
    }

    static {
        collapseAllAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        collapseJavadocAction = IdeAction.get((int)87);
        collapseJavadocAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        collapseMethodsAction = IdeAction.get((int)85);
        collapseMethodsAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        String commandName = JavaArb.getString(138);
        int commandMnemonic = StringUtils.getMnemonicKeyCode((String)commandName);
        collapseAnnotationsAction = IdeAction.get((int)COLLAPSE_ANNOTATIONS_CMD_ID, null, (String)commandName, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(commandMnemonic), null, null, (boolean)false);
        collapseAnnotationsAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        commandName = JavaArb.getString(139);
        commandMnemonic = StringUtils.getMnemonicKeyCode((String)commandName);
        expandAnnotationsAction = IdeAction.get((int)EXPAND_ANNOTATIONS_CMD_ID, null, (String)commandName, (String)CodeMenuConstants.CATEGORY_CODE_MENU, (Integer)new Integer(commandMnemonic), null, null, (boolean)false);
        expandAnnotationsAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        expandAllAction = IdeAction.get((int)54);
        expandAllAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        expandJavadocAction = IdeAction.get((int)86);
        expandJavadocAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
        expandMethodsAction = IdeAction.get((int)84);
        expandMethodsAction.addController((Controller)JAVA_FOLDING_CONTROLLER);
    }

    private static class PreferencesAction
    extends AbstractAction {
        public PreferencesAction() {
            String name = JavaArb.getString(140);
            this.putValue("Name", StringUtils.stripMnemonic((String)name));
            this.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)name));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] path = new String[]{CEditorArb.getString((int)4), JavaArb.getString(113), JavaArb.getString(126)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
        }
    }

    private static final class JavaCodeFoldingController
    implements Controller {
        private JavaCodeFoldingController() {
        }

        public boolean update(IdeAction action, Context context) {
            CodeFoldingMargin margin = JavaCodeFoldingController.getCodeFoldingMargin(context);
            return JavaCodeFoldingController.update(action, margin);
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (!(context.getNode() instanceof JavaSourceNode)) {
                return false;
            }
            CodeFoldingMargin margin = JavaCodeFoldingController.getCodeFoldingMargin(context);
            int cmdId = action.getCommandId();
            if (cmdId == 55) {
                JavaCodeFoldingController.setExpansion(margin, null, false);
                return true;
            }
            if (cmdId == 87) {
                JavaCodeFoldingController.setExpansion(margin, JavadocBlock.class, false);
                return true;
            }
            if (cmdId == 85) {
                JavaCodeFoldingController.setExpansion(margin, JavaMethodBlock.class, false);
                return true;
            }
            if (cmdId == COLLAPSE_ANNOTATIONS_CMD_ID) {
                JavaCodeFoldingController.setExpansion(margin, AnnotationBlock.class, false);
                return true;
            }
            if (cmdId == 54) {
                JavaCodeFoldingController.setExpansion(margin, null, true);
                return true;
            }
            if (cmdId == 86) {
                JavaCodeFoldingController.setExpansion(margin, JavadocBlock.class, true);
                return true;
            }
            if (cmdId == 84) {
                JavaCodeFoldingController.setExpansion(margin, JavaMethodBlock.class, true);
                return true;
            }
            if (cmdId == EXPAND_ANNOTATIONS_CMD_ID) {
                JavaCodeFoldingController.setExpansion(margin, AnnotationBlock.class, true);
                return true;
            }
            return false;
        }

        private static boolean update(IdeAction action, CodeFoldingMargin margin) {
            int cmdId = action.getCommandId();
            if (cmdId == 55 || cmdId == 87 || cmdId == 85 || cmdId == COLLAPSE_ANNOTATIONS_CMD_ID || cmdId == 54 || cmdId == 86 || cmdId == 84 || cmdId == EXPAND_ANNOTATIONS_CMD_ID) {
                boolean enabled = JavaCodeFoldingController.isFoldingActionEnabled(margin);
                action.setEnabled(enabled);
                return true;
            }
            return false;
        }

        private static CodeFoldingMargin getCodeFoldingMargin(Context context) {
            CodeEditor editor;
            BasicEditorPane editorPane;
            View view;
            if (context != null && (view = context.getView()) instanceof CodeEditor && (editorPane = (editor = (CodeEditor)view).getFocusedEditorPane()) != null) {
                Object value = editorPane.getProperty("code-folding-margin");
                return (CodeFoldingMargin)value;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isFoldingActionEnabled(CodeFoldingMargin margin) {
            CodeFoldingModel model;
            if (margin != null && (model = margin.getModel()) != null) {
                model.readLock();
                try {
                    Object root = model.getRoot();
                    if (root != null) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    model.readUnlock();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void setExpansion(CodeFoldingMargin margin, Class cls, boolean expanded) {
            CodeFoldingModel model = margin.getModel();
            model.readLock();
            try {
                FoldingBlock root = (FoldingBlock)model.getRoot();
                if (root != null) {
                    JavaCodeFoldingController.foldChildren(margin, cls, expanded, root);
                    margin.repaint();
                }
            }
            finally {
                model.readUnlock();
            }
        }

        private static void foldChildren(CodeFoldingMargin margin, Class cls, boolean expanded, FoldingBlock block) {
            Iterator it = block.getChildren();
            while (it.hasNext()) {
                AbstractJavaFoldingBlock child = (AbstractJavaFoldingBlock)((Object)it.next());
                if (cls == null || ((Object)((Object)child)).getClass().isAssignableFrom(cls)) {
                    margin.setExpansionState((Object)child, expanded);
                }
                JavaCodeFoldingController.foldChildren(margin, cls, expanded, (FoldingBlock)child);
            }
        }
    }

    private static enum CommentType {
        SLASHES,
        SINGLE_ASTERIX,
        DOUBLE_ASTERIX;

    }
}

