/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.folding;

import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.jdevimpl.java.folding.AbstractJavaMemberBlock;

final class JavaClassBlock
extends AbstractJavaMemberBlock {
    private Object key;
    private int anonymousClassId;
    private int classInitId;
    private int instanceInitId;

    public JavaClassBlock(SourceClass cls, boolean isExpanded) {
        super((SourceMember)cls, isExpanded);
        SourceClassBody classBody = cls.getSourceBody();
        this.setStartOffset(classBody.getStartOffset());
        this.setEndOffset(classBody.getEndOffset());
    }

    public void setUserObject(Object object) {
        this.key = null;
        super.setUserObject(object);
    }

    @Override
    protected Object getId() {
        if (this.key == null) {
            SourceClass cls = this.getClassSym();
            this.key = !cls.isAnonymous() ? cls.getName() : this.getAnonymousId();
        }
        return this.key;
    }

    protected SourceClass getClassSym() {
        return (SourceClass)this.getSym();
    }

    protected String getAnonymousId() {
        JavaClassBlock enclosingClass = this.getEnclosingClassBlock();
        if (enclosingClass != null) {
            return enclosingClass.nextAnonymousId();
        }
        return "";
    }

    protected String nextAnonymousId() {
        SourceClass cls = this.getClassSym();
        String nextId = Integer.toString(++this.anonymousClassId);
        return cls.getName() + "$" + nextId;
    }

    protected String nextClassInitializerId() {
        String nextId = Integer.toString(++this.classInitId);
        return "<clinit>" + nextId;
    }

    protected String nextInstanceInitializerId() {
        String nextId = Integer.toString(++this.instanceInitId);
        return "<init>" + nextId;
    }
}

