/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.folding;

import java.util.List;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdevimpl.java.folding.AbstractJavaFoldingBlock;
import oracle.jdevimpl.java.folding.JavaMethodBlock;

final class AnnotationBlock
extends AbstractJavaFoldingBlock {
    protected static final String REPLACEMENT_TEXT = "@annotations...";
    private Object key;

    public AnnotationBlock(SourceMember member, boolean isExpanded) {
        super((SourceElement)member, REPLACEMENT_TEXT, isExpanded);
        List annotations = member.getSourceAnnotations();
        int start = -1;
        int end = -1;
        for (SourceAnnotation annotation : annotations) {
            if (start == -1 || annotation.getStartOffset() < start) {
                start = annotation.getStartOffset();
            }
            if (end != -1 && annotation.getEndOffset() <= end) continue;
            end = annotation.getEndOffset();
        }
        if (annotations.size() == 1) {
            SourceAnnotation annotation = (SourceAnnotation)annotations.get(0);
            if (annotation.getArgumentCount() > 0) {
                this.setReplacementText("@" + annotation.getName() + "(...)");
            } else {
                this.setReplacementText("@" + annotation.getName());
            }
        }
        this.setStartOffset(start);
        this.setEndOffset(end);
    }

    public void setUserObject(Object object) {
        this.key = null;
        super.setUserObject(object);
    }

    @Override
    protected Object getId() {
        if (this.key == null) {
            SourceMember member = this.getMemberSym();
            this.key = member instanceof SourceMethod ? JavaMethodBlock.getMethodId((SourceMethod)member) : member.getName();
            this.key = "@" + this.key;
        }
        return this.key;
    }

    protected SourceMember getMemberSym() {
        return (SourceMember)this.getSym();
    }
}

