/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.JavaExplorer;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;

public final class JavaGroupOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private Shuttle shuttle_groups;
    private JList list_available;
    private JList list_selected;
    private String group_staticInstance;
    private String group_access;
    private String group_type;
    private JCheckBox checkbox_expandConstructors;
    private JCheckBox checkbox_expandMethods;
    private JCheckBox checkbox_expandFields;
    private JCheckBox checkbox_expandInnerClasses;
    private JCheckBox checkbox_expandPublic;
    private JCheckBox checkbox_expandProtected;
    private JCheckBox checkbox_expandPrivate;
    private JCheckBox checkbox_expandPackage;
    private JCheckBox checkbox_expandStatic;
    private JCheckBox checkbox_expandInstance;
    private int[] lastGroupOrder = null;

    public JavaGroupOptionsPanel() {
        this.setHelpID("f1_idedidesetjavagroups_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        JavaExplorerOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavaExplorerOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavaExplorerOptions findOptions(TraversableContext tc) {
        JavaExplorerOptions options = (JavaExplorerOptions)tc.find("JavaExplorerOptions");
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        JavaExplorerOptions options = this.findOptions(tc);
        JavaGroupOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(JavaExplorerOptions options) {
        JavaExplorer.notifyOptionsChanged();
    }

    protected static boolean isBitSet(int value, int flag) {
        return (value & flag) == flag;
    }

    void loadSettingsFrom(JavaExplorerOptions options) {
        int groupFlags = options.getExpandedGroups();
        boolean expandConstructors = JavaGroupOptionsPanel.isBitSet(groupFlags, 256);
        boolean expandMethods = JavaGroupOptionsPanel.isBitSet(groupFlags, 512);
        boolean expandFields = JavaGroupOptionsPanel.isBitSet(groupFlags, 1024);
        boolean expandInnerClasses = JavaGroupOptionsPanel.isBitSet(groupFlags, 2048);
        boolean expandPublic = JavaGroupOptionsPanel.isBitSet(groupFlags, 16);
        boolean expandProtected = JavaGroupOptionsPanel.isBitSet(groupFlags, 32);
        boolean expandPrivate = JavaGroupOptionsPanel.isBitSet(groupFlags, 64);
        boolean expandPackage = JavaGroupOptionsPanel.isBitSet(groupFlags, 128);
        boolean expandStatic = JavaGroupOptionsPanel.isBitSet(groupFlags, 1);
        boolean expandInstance = JavaGroupOptionsPanel.isBitSet(groupFlags, 2);
        int[] groups = options.getGroupOrder();
        if (!this.matchingGroups(groups, this.lastGroupOrder)) {
            DefaultListModel<String> availableModel = new DefaultListModel<String>();
            availableModel.addElement(this.group_access);
            availableModel.addElement(this.group_type);
            availableModel.addElement(this.group_staticInstance);
            DefaultListModel<String> selectedModel = new DefaultListModel<String>();
            int numGroups = groups != null ? groups.length : 0;
            block5: for (int i = 0; i < numGroups; ++i) {
                int group = groups[i];
                String groupItem = null;
                switch (group) {
                    case 3: {
                        groupItem = this.group_access;
                        break;
                    }
                    case 2: {
                        groupItem = this.group_type;
                        break;
                    }
                    case 1: {
                        groupItem = this.group_staticInstance;
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                availableModel.removeElement(groupItem);
                selectedModel.addElement(groupItem);
            }
            this.list_available.setModel(availableModel);
            this.list_selected.setModel(selectedModel);
            this.lastGroupOrder = groups;
            this.shuttle_groups.setEnabled(true);
        }
        this.checkbox_expandConstructors.setSelected(expandConstructors);
        this.checkbox_expandMethods.setSelected(expandMethods);
        this.checkbox_expandFields.setSelected(expandFields);
        this.checkbox_expandInnerClasses.setSelected(expandInnerClasses);
        this.checkbox_expandPublic.setSelected(expandPublic);
        this.checkbox_expandProtected.setSelected(expandProtected);
        this.checkbox_expandPrivate.setSelected(expandPrivate);
        this.checkbox_expandPackage.setSelected(expandPackage);
        this.checkbox_expandStatic.setSelected(expandStatic);
        this.checkbox_expandInstance.setSelected(expandInstance);
    }

    private boolean matchingGroups(int[] order1, int[] order2) {
        int size2;
        int size1 = order1 != null ? order1.length : 0;
        int n = size2 = order2 != null ? order2.length : 0;
        if (size1 != size2) {
            return false;
        }
        for (int i = 0; i < size1; ++i) {
            if (order1[i] == order2[i]) continue;
            return false;
        }
        return true;
    }

    void saveSettingsTo(JavaExplorerOptions options) throws TraversalException {
        int groupFlags = 0;
        if (this.checkbox_expandConstructors.isSelected()) {
            groupFlags |= 0x100;
        }
        if (this.checkbox_expandMethods.isSelected()) {
            groupFlags |= 0x200;
        }
        if (this.checkbox_expandFields.isSelected()) {
            groupFlags |= 0x400;
        }
        if (this.checkbox_expandInnerClasses.isSelected()) {
            groupFlags |= 0x800;
        }
        if (this.checkbox_expandPublic.isSelected()) {
            groupFlags |= 0x10;
        }
        if (this.checkbox_expandProtected.isSelected()) {
            groupFlags |= 0x20;
        }
        if (this.checkbox_expandPrivate.isSelected()) {
            groupFlags |= 0x40;
        }
        if (this.checkbox_expandPackage.isSelected()) {
            groupFlags |= 0x80;
        }
        if (this.checkbox_expandStatic.isSelected()) {
            groupFlags |= 1;
        }
        if (this.checkbox_expandInstance.isSelected()) {
            groupFlags |= 2;
        }
        ListModel listModel = this.list_selected.getModel();
        int numGroups = listModel.getSize();
        int[] groups = new int[numGroups];
        for (int i = 0; i < numGroups; ++i) {
            Object selectedGroup = listModel.getElementAt(i);
            if (selectedGroup == this.group_access) {
                groups[i] = 3;
                continue;
            }
            if (selectedGroup == this.group_staticInstance) {
                groups[i] = 1;
                continue;
            }
            if (selectedGroup == this.group_type) {
                groups[i] = 2;
                continue;
            }
            throw new IllegalStateException("unknown group: " + selectedGroup.toString());
        }
        options.setExpandedGroups(groupFlags);
        options.setGroupOrder(groups);
    }

    private void initializeComponent() {
        String expandText = JavaArb.getString(293);
        JLabel label_expand = new JLabel(expandText);
        String expandConstructorsText = JavaArb.getString(298);
        this.checkbox_expandConstructors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandConstructors, (String)expandConstructorsText);
        String expandMethodText = JavaArb.getString(299);
        this.checkbox_expandMethods = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandMethods, (String)expandMethodText);
        String expandFieldsText = JavaArb.getString(300);
        this.checkbox_expandFields = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandFields, (String)expandFieldsText);
        String expandInnerClassesText = JavaArb.getString(301);
        this.checkbox_expandInnerClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandInnerClasses, (String)expandInnerClassesText);
        String expandPublicText = JavaArb.getString(294);
        this.checkbox_expandPublic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandPublic, (String)expandPublicText);
        String expandProtectedText = JavaArb.getString(295);
        this.checkbox_expandProtected = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandProtected, (String)expandProtectedText);
        String expandPrivateText = JavaArb.getString(296);
        this.checkbox_expandPrivate = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandPrivate, (String)expandPrivateText);
        String expandPackageText = JavaArb.getString(297);
        this.checkbox_expandPackage = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandPackage, (String)expandPackageText);
        String expandStaticText = JavaArb.getString(303);
        this.checkbox_expandStatic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandStatic, (String)expandStaticText);
        String expandInstanceText = JavaArb.getString(302);
        this.checkbox_expandInstance = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandInstance, (String)expandInstanceText);
        String shuttleInfo = JavaArb.getString(287);
        JMultiLineLabel label_shuttle = new JMultiLineLabel(shuttleInfo);
        label_shuttle.setMinimumRows(2);
        this.group_access = JavaArb.getString(290);
        this.group_type = JavaArb.getString(291);
        this.group_staticInstance = JavaArb.getString(292);
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        listModel.addElement(this.group_access);
        listModel.addElement(this.group_type);
        listModel.addElement(this.group_staticInstance);
        String availableText = JavaArb.getString(288);
        JLabel label_available = new JLabel();
        this.list_available = new JList(listModel);
        ResourceUtils.resLabel((JLabel)label_available, (Component)this.list_available, (String)availableText);
        String selectedText = JavaArb.getString(289);
        JLabel label_selected = new JLabel();
        this.list_selected = new JList();
        ResourceUtils.resLabel((JLabel)label_selected, (Component)this.list_selected, (String)selectedText);
        ListPicker picker_available = new ListPicker(this.list_available);
        picker_available.setItemsSorted(true);
        ReorderableListPicker picker_selected = new ReorderableListPicker(this.list_selected);
        this.shuttle_groups = new Shuttle();
        this.shuttle_groups.setFromPicker((ItemPicker)picker_available);
        this.shuttle_groups.setToPicker((ItemPicker)picker_selected);
        this.shuttle_groups.add((Component)label_available, (Object)"FromHeader");
        this.shuttle_groups.add((Component)label_selected, (Object)"ToHeader");
        this.shuttle_groups.setNextFocusableComponent((Component)this.checkbox_expandConstructors);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets indentedInsets = new Insets(2, 30, 2, 5);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add((Component)label_shuttle, constraints);
        constraints = new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add((Component)this.shuttle_groups, constraints);
        constraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(10), constraints);
        constraints = new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_expand, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 0.2, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_expandConstructors, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 0.2, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_expandMethods, constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 0.2, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_expandFields, constraints);
        constraints = new GridBagConstraints(0, 8, 1, 1, 0.2, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.checkbox_expandInnerClasses, constraints);
        constraints = new GridBagConstraints(1, 5, 1, 1, 0.2, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_expandPublic, constraints);
        constraints = new GridBagConstraints(1, 6, 1, 1, 0.2, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_expandProtected, constraints);
        constraints = new GridBagConstraints(1, 7, 1, 1, 0.2, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_expandPrivate, constraints);
        constraints = new GridBagConstraints(1, 8, 1, 1, 0.2, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_expandPackage, constraints);
        constraints = new GridBagConstraints(2, 5, 1, 1, 0.6, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_expandInstance, constraints);
        constraints = new GridBagConstraints(2, 6, 1, 1, 0.6, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_expandStatic, constraints);
        constraints = new GridBagConstraints(2, 7, 1, 2, 0.6, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
        constraints = new GridBagConstraints(0, 9, 3, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }
}

