/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.JavaExplorer;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;

public final class JavaExplorerOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JRadioButton radio_sortNone;
    private JRadioButton radio_sortAlphabetically;
    private JRadioButton radio_sortType;
    private JRadioButton radio_sortAccess;
    private JCheckBox checkbox_expandErrors;
    private JCheckBox checkbox_expandImports;
    private JCheckBox checkbox_expandPublicClasses;
    private JCheckBox checkbox_expandPackageClasses;
    private JCheckBox checkbox_expandInnerClasses;
    private JCheckBox checkbox_showAccessIcons;

    public JavaExplorerOptionsPanel() {
        this.setHelpID("f1_idedidesetjavastructure_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        JavaExplorerOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavaExplorerOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavaExplorerOptions findOptions(TraversableContext tc) {
        JavaExplorerOptions options = (JavaExplorerOptions)tc.find("JavaExplorerOptions");
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        JavaExplorerOptions options = this.findOptions(tc);
        JavaExplorerOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(JavaExplorerOptions options) {
        JavaExplorer.notifyOptionsChanged();
    }

    protected static boolean isBitSet(int value, int flag) {
        return (value & flag) == flag;
    }

    void loadSettingsFrom(JavaExplorerOptions options) {
        int sortOrder = options.getSortOrder();
        int expandFlags = options.getExpandedFolders();
        boolean expandErrors = JavaExplorerOptionsPanel.isBitSet(expandFlags, 1);
        boolean expandImports = JavaExplorerOptionsPanel.isBitSet(expandFlags, 2);
        boolean expandPublicClasses = JavaExplorerOptionsPanel.isBitSet(expandFlags, 4);
        boolean expandPackageClasses = JavaExplorerOptionsPanel.isBitSet(expandFlags, 8);
        boolean expandInnerClasses = JavaExplorerOptionsPanel.isBitSet(expandFlags, 16);
        boolean showAccessIcons = options.getShowAccessIcons();
        this.checkbox_showAccessIcons.setSelected(showAccessIcons);
        JRadioButton radioToCheck = null;
        switch (sortOrder) {
            case 0: {
                radioToCheck = this.radio_sortNone;
                break;
            }
            case 1: {
                radioToCheck = this.radio_sortAlphabetically;
                break;
            }
            case 3: {
                radioToCheck = this.radio_sortAccess;
                break;
            }
            default: {
                radioToCheck = this.radio_sortType;
            }
        }
        radioToCheck.setSelected(true);
        this.checkbox_expandErrors.setSelected(expandErrors);
        this.checkbox_expandImports.setSelected(expandImports);
        this.checkbox_expandPublicClasses.setSelected(expandPublicClasses);
        this.checkbox_expandPackageClasses.setSelected(expandPackageClasses);
        this.checkbox_expandInnerClasses.setSelected(expandInnerClasses);
    }

    void saveSettingsTo(JavaExplorerOptions options) throws TraversalException {
        int expandFlags = 0;
        if (this.checkbox_expandErrors.isSelected()) {
            expandFlags |= 1;
        }
        if (this.checkbox_expandImports.isSelected()) {
            expandFlags |= 2;
        }
        if (this.checkbox_expandPublicClasses.isSelected()) {
            expandFlags |= 4;
        }
        if (this.checkbox_expandPackageClasses.isSelected()) {
            expandFlags |= 8;
        }
        if (this.checkbox_expandInnerClasses.isSelected()) {
            expandFlags |= 0x10;
        }
        int sortOrder = 2;
        if (this.radio_sortNone.isSelected()) {
            sortOrder = 0;
        } else if (this.radio_sortAlphabetically.isSelected()) {
            sortOrder = 1;
        } else if (this.radio_sortAccess.isSelected()) {
            sortOrder = 3;
        }
        boolean showAccessIcons = this.checkbox_showAccessIcons.isSelected();
        options.setSortOrder(sortOrder);
        options.setExpandedFolders(expandFlags);
        options.setShowAccessIcons(showAccessIcons);
    }

    private void initializeComponent() {
        String sort_text = JavaArb.getString(253);
        JLabel label_sortOrder = new JLabel(sort_text);
        String sortNoneText = JavaArb.getString(254);
        this.radio_sortNone = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_sortNone, (String)sortNoneText);
        String sortAlphaText = JavaArb.getString(255);
        this.radio_sortAlphabetically = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_sortAlphabetically, (String)sortAlphaText);
        String sortAccessText = JavaArb.getString(257);
        this.radio_sortAccess = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_sortAccess, (String)sortAccessText);
        String sortTypeText = JavaArb.getString(256);
        this.radio_sortType = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_sortType, (String)sortTypeText);
        ButtonGroup group_radios = new ButtonGroup();
        group_radios.add(this.radio_sortNone);
        group_radios.add(this.radio_sortAlphabetically);
        group_radios.add(this.radio_sortAccess);
        group_radios.add(this.radio_sortType);
        String expand_text = JavaArb.getString(258);
        JLabel label_expandFolders = new JLabel(expand_text);
        String expandErrorsText = JavaArb.getString(259);
        this.checkbox_expandErrors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandErrors, (String)expandErrorsText);
        String expandImportsText = JavaArb.getString(260);
        this.checkbox_expandImports = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandImports, (String)expandImportsText);
        String expandPublicClassesText = JavaArb.getString(261);
        this.checkbox_expandPublicClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandPublicClasses, (String)expandPublicClassesText);
        String expandPackageClassesText = JavaArb.getString(262);
        this.checkbox_expandPackageClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandPackageClasses, (String)expandPackageClassesText);
        String expandInnerClassesText = JavaArb.getString(263);
        this.checkbox_expandInnerClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandInnerClasses, (String)expandInnerClassesText);
        String showAccessIconsText = JavaArb.getString(264);
        this.checkbox_showAccessIcons = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showAccessIcons, (String)showAccessIconsText);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets indentedInsets = new Insets(2, 30, 2, 5);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        JPanel panel_sort = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_sort.add((Component)label_sortOrder, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_sort.add((Component)this.radio_sortNone, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_sort.add((Component)this.radio_sortAlphabetically, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_sort.add((Component)this.radio_sortType, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_sort.add((Component)this.radio_sortAccess, constraints);
        JPanel panel_expand = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_expand.add((Component)label_expandFolders, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_expand.add((Component)this.checkbox_expandErrors, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_expand.add((Component)this.checkbox_expandImports, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_expand.add((Component)this.checkbox_expandPublicClasses, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_expand.add((Component)this.checkbox_expandPackageClasses, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_expand.add((Component)this.checkbox_expandInnerClasses, constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0);
        this.add(panel_sort, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        this.add(Box.createVerticalStrut(10), constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, emptyInsets, 0, 0);
        this.add(panel_expand, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        this.add(Box.createVerticalStrut(8), constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_showAccessIcons, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }
}

