/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.io.PrintWriter;
import javax.swing.Icon;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.FastStringWriter;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.CodeElement;

public abstract class JavaCodeElement
extends CodeElement
implements JavaConstants {
    private static FastStringWriter sharedStringBuffer = null;
    private String symbolName;
    private ClassElement enclosingClass = null;

    public JavaCodeElement(SourceElement symbol) {
        this.setSymbolName(JavaCodeElement.getSymbolName(symbol));
        this.setDisplayText(this.getDisplayText(symbol));
        this.setIcon(this.getIcon(symbol));
        this.setStartOffset(JavaCodeElement.getStartOffset(symbol));
        this.setEndOffset(this.getEndOffset(symbol));
    }

    protected static synchronized FastStringWriter allocFastStringBuffer() {
        if (sharedStringBuffer == null) {
            return new FastStringWriter(100);
        }
        FastStringWriter buffer = sharedStringBuffer;
        sharedStringBuffer = null;
        return buffer;
    }

    protected static synchronized void freeFastStringBuffer(FastStringWriter buffer) {
        if (buffer != null && sharedStringBuffer == null) {
            buffer.getBuffer().setLength(0);
            sharedStringBuffer = buffer;
        }
    }

    protected static String format(String pattern, String param1) {
        int index = pattern.indexOf("{0}");
        if (index == -1) {
            return pattern;
        }
        FastStringWriter writer = JavaCodeElement.allocFastStringBuffer();
        FastStringBuffer buffer = writer.getBuffer();
        buffer.append(pattern);
        buffer.removeCharsAt(index, 3);
        buffer.insert(index, param1);
        String result = buffer.toString();
        JavaCodeElement.freeFastStringBuffer(writer);
        return result;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    protected void setSymbolName(String symbolName) {
        this.symbolName = symbolName;
    }

    protected static String getName(SourceHasName nameable) {
        if (nameable != null) {
            return nameable.getName();
        }
        return "";
    }

    protected static String getName(SourceName nameSymbol) {
        if (nameSymbol != null) {
            String name = nameSymbol.getValue();
            return name;
        }
        return "";
    }

    protected static void print(SourceElement symbol, PrintWriter writer) {
        if (symbol == null) {
            return;
        }
        symbol.print(writer, 0);
    }

    protected static void print(SourceElement symbol, PrintWriter writer, int argument) {
        if (symbol == null) {
            return;
        }
        symbol.print(writer, argument);
    }

    protected static boolean isBitSet(int value, int flag) {
        return (value & flag) == flag;
    }

    public static String getSymbolName(SourceElement symbol) {
        if (symbol == null) {
            return "";
        }
        if (symbol instanceof SourceTypeReference) {
            SourceTypeReference typeSymbol = (SourceTypeReference)symbol;
            FastStringWriter buffer = JavaCodeElement.allocFastStringBuffer();
            JavaCodeElement.print((SourceElement)typeSymbol, (PrintWriter)buffer);
            String typeName = buffer.toString();
            JavaCodeElement.freeFastStringBuffer(buffer);
            return typeName;
        }
        if (symbol instanceof SourceHasName) {
            SourceHasName nameable = (SourceHasName)symbol;
            return JavaCodeElement.getName(nameable);
        }
        if (symbol instanceof SourceName) {
            SourceName nameSymbol = (SourceName)symbol;
            return JavaCodeElement.getName(nameSymbol);
        }
        return "";
    }

    protected String getDisplayText(SourceElement symbol) {
        String symbolName = JavaCodeElement.getSymbolName(symbol);
        if (symbolName != null) {
            return symbolName;
        }
        throw new IllegalStateException("unnameable: " + symbol.toString());
    }

    protected abstract String getTooltipText(SourceElement var1);

    protected abstract Icon getIcon(SourceElement var1);

    static int getStartOffset(SourceElement symbol) {
        SourceHasName nameable;
        SourceName nameSymbol;
        if (symbol == null) {
            return -1;
        }
        if (symbol instanceof SourceHasName && (nameSymbol = (nameable = (SourceHasName)symbol).getNameElement()) != null) {
            symbol = nameSymbol;
        }
        return symbol.getStartOffset();
    }

    protected int getEndOffset(SourceElement symbol) {
        SourceHasName nameable;
        SourceName nameSymbol;
        if (symbol == null) {
            return -1;
        }
        if (symbol instanceof SourceHasName && (nameSymbol = (nameable = (SourceHasName)symbol).getNameElement()) != null) {
            symbol = nameSymbol;
        }
        return symbol.getEndOffset();
    }

    public ClassElement getEnclosingClass() {
        return this.enclosingClass;
    }

    void setEnclosingClass(ClassElement classElement) {
        this.enclosingClass = classElement;
    }

    @Override
    public boolean mayHaveChildren() {
        return false;
    }
}

