/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.jdevimpl.java.explorer.FolderElement;
import oracle.jdevimpl.java.explorer.LeafElement;

public class ExpansionTracker
implements TreeExpansionListener {
    private List collapsedList = new ArrayList();
    private List expandedList = new ArrayList();
    private JTree tree;
    private boolean isTracking = false;

    public ExpansionTracker(JTree tree) {
        this.tree = tree;
    }

    public void startTracking() {
        if (!this.isTracking) {
            this.tree.addTreeExpansionListener(this);
            this.isTracking = true;
        }
    }

    public void stopTracking() {
        if (this.isTracking) {
            this.tree.removeTreeExpansionListener(this);
            this.isTracking = false;
        }
    }

    protected void handleExpansionChange(TreeExpansionEvent event, boolean expanded) {
        Element data;
        TreePath treePath = event.getPath();
        if (treePath.getPathCount() == 1) {
            return;
        }
        TNode lastNode = (TNode)treePath.getLastPathComponent();
        if (lastNode != null && (data = lastNode.getData()) instanceof FolderElement) {
            FolderElement folder = (FolderElement)data;
            boolean wantedExpansion = folder.getExpandedDefault();
            if (wantedExpansion) {
                if (expanded) {
                    this.removeRepresentationFrom(treePath, this.collapsedList);
                } else {
                    this.addRepresentationTo(treePath, this.collapsedList);
                }
            } else if (expanded) {
                this.addRepresentationTo(treePath, this.expandedList);
                this.removeRepresentationFrom(treePath, this.collapsedList);
            } else {
                this.removeRepresentationFrom(treePath, this.expandedList);
                this.addRepresentationTo(treePath, this.collapsedList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExpansionState() {
        ExpansionTracker expansionTracker = this;
        synchronized (expansionTracker) {
            this.collapsedList = new ArrayList();
            this.expandedList = new ArrayList();
        }
    }

    public Object getExpansionState() {
        return new List[]{this.collapsedList, this.expandedList};
    }

    public void restoreExpansion(Object expansionState) {
        if (expansionState instanceof List[]) {
            List[] expansionLists = (List[])expansionState;
            List toExpandList = expansionLists[1];
            List toCollapseList = expansionLists[0];
            this.restoreState(true, toExpandList);
            this.restoreState(false, toCollapseList);
        }
    }

    private void restoreState(boolean expand, List list) {
        int size = list != null ? list.size() : 0;
        for (int i = 0; i < size; ++i) {
            String[] ourPath = (String[])list.get(i);
            TreePath matchingPath = this.locateMatchingPath(ourPath);
            if (matchingPath == null) continue;
            if (expand) {
                this.tree.expandPath(matchingPath);
                continue;
            }
            this.tree.collapsePath(matchingPath);
        }
    }

    private TreePath locateMatchingPath(String[] savedPath) {
        TNode currentNode = (TNode)this.tree.getModel().getRoot();
        for (String savedLabel : savedPath) {
            TNode childNode;
            block3: {
                int childCount = currentNode.getChildCount();
                for (int j = 0; j < childCount; ++j) {
                    childNode = (TNode)currentNode.getChildAt(j);
                    LeafElement childElement = (LeafElement)childNode.getData();
                    if (!childElement.getShortLabel().equals(savedLabel)) {
                        continue;
                    }
                    break block3;
                }
                return null;
            }
            currentNode = childNode;
        }
        return new TreePath(currentNode.getPath());
    }

    private void addRepresentationTo(TreePath treePath, List list) {
        String[] representation = this.getRepresentationFor(treePath);
        list.add(representation);
    }

    private void removeRepresentationFrom(TreePath treePath, List list) {
        String[] representation = this.getRepresentationFor(treePath);
        int length = representation.length;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String[] check = (String[])list.get(i);
            if (check.length != length) continue;
            boolean matches = true;
            for (int j = 0; j < length; ++j) {
                if (representation[j].equals(check[j])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            list.remove(i);
            break;
        }
    }

    private String[] getRepresentationFor(TreePath treePath) {
        Object[] path = treePath.getPath();
        int numObjects = path.length;
        String[] ourPath = new String[numObjects - 1];
        for (int i = 1; i < numObjects; ++i) {
            TNode node = (TNode)path[i];
            ourPath[i - 1] = ((LeafElement)node.getData()).getShortLabel();
        }
        return ourPath;
    }

    public void expandDefaultExpansion() {
        TNode rootNode = (TNode)this.tree.getModel().getRoot();
        this.expandDefaultExpansion(rootNode);
    }

    protected boolean expandDefaultExpansion(TNode treeNode) {
        boolean result = false;
        int numChildren = treeNode.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            TreePath path;
            TNode childNode = (TNode)treeNode.getChildAt(i);
            boolean childExpanded = this.expandDefaultExpansion(childNode);
            Element data = childNode.getData();
            if (data == null || !(data instanceof FolderElement)) continue;
            FolderElement folder = (FolderElement)data;
            boolean expandedDefault = folder.getExpandedDefault();
            if (!childExpanded) {
                if (!expandedDefault) continue;
                path = new TreePath(childNode.getPath());
                this.tree.expandPath(path);
                result = true;
                continue;
            }
            if (!expandedDefault) {
                path = new TreePath(childNode.getPath());
                this.tree.collapsePath(path);
            }
            result = true;
        }
        return result;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.handleExpansionChange(event, true);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.handleExpansionChange(event, false);
    }
}

