/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.util.FastStringWriter;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.AccessComparator;
import oracle.jdevimpl.java.explorer.ConstructorElement;
import oracle.jdevimpl.java.explorer.ElementTypeComparator;
import oracle.jdevimpl.java.explorer.ExtendsElement;
import oracle.jdevimpl.java.explorer.FieldElement;
import oracle.jdevimpl.java.explorer.FolderElement;
import oracle.jdevimpl.java.explorer.GroupFolder;
import oracle.jdevimpl.java.explorer.ImplementsElement;
import oracle.jdevimpl.java.explorer.JavaCodeElement;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.LeafElement;
import oracle.jdevimpl.java.explorer.LeafElementComparator;
import oracle.jdevimpl.java.explorer.MethodElement;
import oracle.jdevimpl.java.explorer.ModifierElement;
import oracle.jdevimpl.java.explorer.PeekProvider;

public class ClassElement
extends ModifierElement
implements PeekProvider {
    private String packageName = null;
    private int peekStartOffset;
    private int peekEndOffset;

    public ClassElement(SourceClass classSymbol, JavaExplorerOptions options) {
        super((SourceHasModifiers)classSymbol, options);
        LeafElement[] childElements = this.buildChildren(classSymbol, options);
        this.setChildren(childElements);
        if (classSymbol.isMemberClass()) {
            int expansionOptions = options.getExpandedFolders();
            boolean expandedByDefault = (expansionOptions & 0x10) != 0;
            this.setExpandedDefault(expandedByDefault);
        } else {
            int modifiers = this.getModifiers();
            boolean isPublic = Modifier.isPublic(modifiers);
            int expansionOptions = options.getExpandedFolders();
            int flag = isPublic ? 4 : 8;
            boolean expandedByDefault = (expansionOptions & flag) != 0;
            this.setExpandedDefault(expandedByDefault);
        }
        this.peekStartOffset = classSymbol.getStartOffset();
        this.peekEndOffset = classSymbol.getEndOffset();
    }

    public String getPackageName() {
        ClassElement outerClass = this.getEnclosingClass();
        if (outerClass != null) {
            return outerClass.getPackageName();
        }
        return this.packageName;
    }

    protected void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    protected LeafElement[] buildChildren(SourceClass classSymbol, JavaExplorerOptions options) {
        int showOptions = options.getShowFilter();
        boolean showExtendsImplements = ClassElement.isBitSet(showOptions, 8);
        boolean showConstructors = ClassElement.isBitSet(showOptions, 32);
        boolean showMethods = ClassElement.isBitSet(showOptions, 128);
        boolean showFields = ClassElement.isBitSet(showOptions, 64);
        boolean showInnerClasses = ClassElement.isBitSet(showOptions, 256);
        int hideOptions = options.getHideFilter();
        boolean hidePublic = ClassElement.isBitSet(hideOptions, 1);
        boolean hideProtected = ClassElement.isBitSet(hideOptions, 2);
        boolean hidePrivate = ClassElement.isBitSet(hideOptions, 4);
        boolean hidePackage = ClassElement.isBitSet(hideOptions, 8);
        boolean hideFinal = ClassElement.isBitSet(hideOptions, 16);
        boolean hideInstance = ClassElement.isBitSet(hideOptions, 32);
        boolean hideStatic = ClassElement.isBitSet(hideOptions, 64);
        ArrayList<ModifierElement> childList = new ArrayList<ModifierElement>();
        try {
            block11: for (SourceMember sourceMember : classSymbol.getSourceMembers()) {
                if (sourceMember == null || sourceMember instanceof SourceHasName && ClassElement.getName((SourceHasName)sourceMember).equals("")) continue;
                int modifiers = ClassElement.getModifiers((SourceHasModifiers)sourceMember);
                if (hidePublic && Modifier.isPublic(modifiers) || hideProtected && Modifier.isProtected(modifiers) || hidePrivate && Modifier.isPrivate(modifiers) || hideFinal && Modifier.isFinal(modifiers) || hideStatic && Modifier.isStatic(modifiers) || hidePackage && !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers) || hideInstance && !Modifier.isStatic(modifiers)) continue;
                int memberType = sourceMember.getSymbolKind();
                try {
                    switch (memberType) {
                        case 6: {
                            if (!showConstructors) break;
                            childList.add(new ConstructorElement((SourceMethod)sourceMember, options));
                            break;
                        }
                        case 19: {
                            if (!showMethods) break;
                            childList.add(new MethodElement((SourceMethod)sourceMember, options));
                            break;
                        }
                        case 7: {
                            if (!showFields) break;
                            childList.add(new FieldElement((SourceMemberVariable)((SourceEnumConstant)sourceMember), options));
                            break;
                        }
                        case 9: {
                            if (!showFields) break;
                            for (SourceFieldVariable variableSymbol : ((SourceFieldDeclaration)sourceMember).getVariables()) {
                                if (variableSymbol == null || ClassElement.getName((SourceHasName)variableSymbol).equals("")) continue;
                                childList.add(new FieldElement((SourceMemberVariable)variableSymbol, options));
                            }
                            continue block11;
                        }
                        case 3: {
                            if (!showInnerClasses) break;
                            childList.add(new ClassElement((SourceClass)sourceMember, options));
                            break;
                        }
                    }
                }
                catch (RuntimeException e) {}
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        for (Object e : childList) {
            if (!(e instanceof JavaCodeElement)) continue;
            ((JavaCodeElement)e).setEnclosingClass(this);
        }
        Comparator comparator = ClassElement.getSorter(options);
        if (comparator != null) {
            Collections.sort(childList, comparator);
        }
        List groupedList = this.buildGroups(childList, options);
        ArrayList<JavaCodeElement> baseList = new ArrayList<JavaCodeElement>();
        if (showExtendsImplements) {
            if (classSymbol.isClass()) {
                SourceTypeReference baseClass = classSymbol.getSourceSuperclass();
                if (baseClass != null) {
                    ExtendsElement extendsElement = new ExtendsElement(baseClass);
                    extendsElement.setEnclosingClass(this);
                    baseList.add(extendsElement);
                }
                for (SourceTypeReference nameSymbol : classSymbol.getSourceInterfaces()) {
                    if (nameSymbol == null) continue;
                    ImplementsElement implementsElement = new ImplementsElement(nameSymbol);
                    implementsElement.setEnclosingClass(this);
                    baseList.add(implementsElement);
                }
            } else {
                for (SourceTypeReference nameSymbol : classSymbol.getSourceInterfaces()) {
                    if (nameSymbol == null) continue;
                    ExtendsElement extendsElement = new ExtendsElement(nameSymbol);
                    extendsElement.setEnclosingClass(this);
                    baseList.add(extendsElement);
                }
            }
            if (options.getSortOrder() != 0) {
                Collections.sort(baseList, new LeafElementComparator());
            }
        }
        baseList.addAll(groupedList);
        int numChildren = baseList.size();
        return baseList.toArray(new LeafElement[numChildren]);
    }

    private List buildGroups(List childList, JavaExplorerOptions options) {
        return this.buildGroups(childList, options, options.getGroupOrder(), 0);
    }

    private List buildGroups(List childList, JavaExplorerOptions options, int[] groups, int groupIndex) {
        int numGroups;
        int n = numGroups = groups != null ? groups.length : 0;
        if (numGroups == 0 || groupIndex >= numGroups) {
            return childList;
        }
        int group = groups[groupIndex];
        int nextGroupIndex = groupIndex + 1;
        List groupedList = childList;
        switch (group) {
            case 1: {
                groupedList = this.buildStaticInstanceGroups(childList, options);
                break;
            }
            case 2: {
                groupedList = this.buildTypeGroups(childList, options);
                break;
            }
            case 3: {
                groupedList = this.buildAccessGroups(childList, options);
                break;
            }
            default: {
                return this.buildGroups(childList, options, groups, nextGroupIndex);
            }
        }
        int numChildGroups = groupedList.size();
        for (int i = 0; i < numChildGroups; ++i) {
            FolderElement childGroup = (FolderElement)groupedList.get(i);
            LeafElement[] children = childGroup.getChildrenArray();
            List<LeafElement> childrenList = Arrays.asList(children);
            List groupedChildrenList = this.buildGroups(childrenList, options, groups, nextGroupIndex);
            int numGroupedChildren = groupedChildrenList.size();
            LeafElement[] newChildren = groupedChildrenList.toArray(new LeafElement[numGroupedChildren]);
            childGroup.setChildren(newChildren);
        }
        return groupedList;
    }

    private List buildStaticInstanceGroups(List childList, JavaExplorerOptions options) {
        ArrayList<ModifierElement> staticList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> instanceList = new ArrayList<ModifierElement>();
        int numChildren = childList.size();
        for (int i = 0; i < numChildren; ++i) {
            ModifierElement child = (ModifierElement)childList.get(i);
            int modifiers = child.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                staticList.add(child);
                continue;
            }
            instanceList.add(child);
        }
        GroupFolder staticGroup = this.buildGroupFolder(75, staticList, options, 1);
        GroupFolder instanceGroup = this.buildGroupFolder(76, instanceList, options, 2);
        staticList.clear();
        this.addIfNotNull(instanceGroup, staticList);
        this.addIfNotNull(staticGroup, staticList);
        return staticList;
    }

    private List buildTypeGroups(List childList, JavaExplorerOptions options) {
        ArrayList<ModifierElement> constructorList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> methodList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> fieldList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> classList = new ArrayList<ModifierElement>();
        int numChildren = childList.size();
        for (int i = 0; i < numChildren; ++i) {
            ModifierElement child = (ModifierElement)childList.get(i);
            if (child instanceof ConstructorElement) {
                constructorList.add(child);
                continue;
            }
            if (child instanceof MethodElement) {
                methodList.add(child);
                continue;
            }
            if (child instanceof FieldElement) {
                fieldList.add(child);
                continue;
            }
            if (!(child instanceof ClassElement)) continue;
            classList.add(child);
        }
        GroupFolder constructorGroup = this.buildGroupFolder(77, constructorList, options, 256);
        GroupFolder methodGroup = this.buildGroupFolder(78, methodList, options, 512);
        GroupFolder fieldGroup = this.buildGroupFolder(79, fieldList, options, 1024);
        GroupFolder classGroup = this.buildGroupFolder(80, classList, options, 2048);
        constructorList.clear();
        this.addIfNotNull(constructorGroup, constructorList);
        this.addIfNotNull(methodGroup, constructorList);
        this.addIfNotNull(fieldGroup, constructorList);
        this.addIfNotNull(classGroup, constructorList);
        return constructorList;
    }

    private List buildAccessGroups(List childList, JavaExplorerOptions options) {
        ArrayList<ModifierElement> publicList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> protectedList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> privateList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> packageList = new ArrayList<ModifierElement>();
        int numChildren = childList.size();
        for (int i = 0; i < numChildren; ++i) {
            ModifierElement child = (ModifierElement)childList.get(i);
            int modifiers = child.getModifiers();
            if (Modifier.isPublic(modifiers)) {
                publicList.add(child);
                continue;
            }
            if (Modifier.isProtected(modifiers)) {
                protectedList.add(child);
                continue;
            }
            if (Modifier.isPrivate(modifiers)) {
                privateList.add(child);
                continue;
            }
            packageList.add(child);
        }
        GroupFolder publicGroup = this.buildGroupFolder(81, publicList, options, 16);
        GroupFolder protectedGroup = this.buildGroupFolder(82, protectedList, options, 32);
        GroupFolder privateGroup = this.buildGroupFolder(83, privateList, options, 64);
        GroupFolder packageGroup = this.buildGroupFolder(84, packageList, options, 128);
        packageList.clear();
        this.addIfNotNull(publicGroup, packageList);
        this.addIfNotNull(protectedGroup, packageList);
        this.addIfNotNull(packageGroup, packageList);
        this.addIfNotNull(privateGroup, packageList);
        return packageList;
    }

    private void addIfNotNull(Object object, List list) {
        if (object != null) {
            list.add(object);
        }
    }

    private GroupFolder buildGroupFolder(int nameIndex, List childList, JavaExplorerOptions options, int groupFlag) {
        int numChildren = childList.size();
        if (numChildren == 0) {
            return null;
        }
        LeafElement[] children = childList.toArray(new LeafElement[numChildren]);
        boolean expandedDefault = ClassElement.isBitSet(options.getExpandedGroups(), groupFlag);
        String name = JavaArb.getString(nameIndex);
        GroupFolder folder = new GroupFolder(name, name, OracleIcons.getIcon((String)"folder.png"), children, expandedDefault);
        return folder;
    }

    private static Comparator getSorter(JavaExplorerOptions options) {
        int sortOrder = options.getSortOrder();
        switch (sortOrder) {
            case 0: {
                return null;
            }
            case 1: {
                return new LeafElementComparator();
            }
            case 3: {
                return new AccessComparator();
            }
        }
        return new ElementTypeComparator();
    }

    @Override
    protected String getDisplayText(SourceElement symbol) {
        FastStringWriter buffer = ClassElement.allocFastStringBuffer();
        symbol.print((PrintWriter)buffer, 1);
        String result = buffer.toString();
        ClassElement.freeFastStringBuffer(buffer);
        return result;
    }

    @Override
    protected String getTooltipText(SourceElement symbol) {
        FastStringWriter buffer = ClassElement.allocFastStringBuffer();
        symbol.print((PrintWriter)buffer, 2);
        String result = buffer.toString();
        ClassElement.freeFastStringBuffer(buffer);
        return result;
    }

    @Override
    protected Icon getIcon(SourceElement symbol) {
        SourceClass classSymbol = (SourceClass)symbol;
        return OracleIcons.getIcon((String)(classSymbol.isClass() ? "class.png" : "interface.png"));
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public int getPeekStartOffset() {
        return this.peekStartOffset;
    }

    @Override
    public int getPeekEndOffset() {
        return this.peekEndOffset;
    }
}

