/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controls.ToggleAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;

public class NavigationEntry {
    private NavigationType _navigationType;
    private String _tooltip;
    private Project _project;
    private URL _goToUrl;
    private int _goToOffset;

    public NavigationEntry(NavigationType navigationType, URL goToUrl, int goToOffset, String tooltip) {
        this._navigationType = navigationType;
        this._tooltip = tooltip;
        this._goToUrl = goToUrl;
        this._goToOffset = goToOffset;
    }

    public NavigationEntry(NavigationType navigationType, String tooltip, Project project, SourceElement destinationElement) {
        this._navigationType = navigationType;
        this._tooltip = tooltip;
        this._project = project;
        if (destinationElement != null) {
            SourceHasName sourceHasName;
            SourceName nameElement;
            SourceFile owningSourceFile = destinationElement.getOwningSourceFile();
            this._goToUrl = owningSourceFile.getURL();
            this._goToOffset = destinationElement.getStartOffset();
            if (destinationElement instanceof SourceHasName && (nameElement = (sourceHasName = (SourceHasName)destinationElement).getNameElement()) != null) {
                this._goToOffset = nameElement.getStartOffset();
            }
        } else {
            this._goToUrl = null;
            this._goToOffset = -1;
        }
    }

    public NavigationType getNavigationType() {
        return this._navigationType;
    }

    public String getTooltip() {
        return this._tooltip;
    }

    public URL getGoToUrl() {
        return this._goToUrl;
    }

    public int getGoToOffset() {
        return this._goToOffset;
    }

    public String toString() {
        return this._tooltip + " -> " + String.valueOf(this._goToUrl) + ":" + this._goToOffset;
    }

    public Icon getIcon() {
        switch (this._navigationType) {
            case EXTENDING_CLASS: {
                return JavaArb.getIcon(32);
            }
            case EXTENDS_CLASS: {
                return JavaArb.getIcon(31);
            }
            case OVERRIDDEN_METHOD: {
                return JavaArb.getIcon(32);
            }
            case OVERRIDES_METHOD: {
                return JavaArb.getIcon(31);
            }
        }
        return null;
    }

    public void navigate() {
        NavigationManager navigator = NavigationManager.getNavigationManager();
        Node destNode = NodeFactory.find((URL)this._goToUrl);
        if (destNode != null) {
            try {
                Context context = Context.newIdeContext((Node)destNode);
                context.setProject(this._project);
                Project definingProject = JavaManager.getDefiningProject((Context)context, (URL)this._goToUrl);
                if (definingProject != null) {
                    context.setProject(definingProject);
                }
                OffsetNavigationPoint point = new OffsetNavigationPoint(context, this._goToOffset, 0);
                if (navigator != null) {
                    navigator.navigateTo((NavigationPoint)point);
                } else {
                    point.navigate();
                }
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    public ToggleAction createGotoSourceAction() {
        ToggleAction action = new ToggleAction(this.getTooltip(), this.getIcon()){

            public void actionPerformed(ActionEvent e) {
                NavigationEntry.this.navigate();
            }
        };
        return action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NavigationEntry) {
            NavigationEntry that = (NavigationEntry)o;
            if (this._navigationType == that._navigationType && this._tooltip.equals(that._tooltip) && this._goToOffset == that._goToOffset && ModelUtil.areEqual((Object)this._goToUrl, (Object)that._goToUrl)) {
                return true;
            }
        }
        return false;
    }

    public static enum NavigationType {
        OVERRIDES_METHOD,
        EXTENDS_CLASS,
        OVERRIDDEN_METHOD,
        EXTENDING_CLASS;

    }
}

