/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorViewSelectionSetter;
import oracle.ide.ceditor.CursorListener;
import oracle.ide.ceditor.ViewSelectionHelper;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaParserPlugin;

public class JavaViewSelectionHelper
implements ViewSelectionHelper,
CursorListener,
JavaParserPlugin.HelperClient {
    private CodeEditorViewSelectionSetter selectionSetter;
    private CodeEditor editor;
    private SourceFile sourceFile;

    public void attach(CodeEditor codeEditor, CodeEditorViewSelectionSetter codeEditorSetter) {
        this.selectionSetter = codeEditorSetter;
        this.editor = codeEditor;
        codeEditor.addCursorListener((CursorListener)this, true);
        JavaParserPlugin.attachHelperClient(codeEditor.getFocusedEditorPane(), this);
    }

    public void detach(CodeEditor codeEditor) {
        codeEditor.removeCursorListener((CursorListener)this);
        this.sourceFile = null;
    }

    void updateSelection() {
        if (this.sourceFile == null) {
            return;
        }
        int offset = this.editor.getCaretPosition();
        SourceElement element = this.sourceFile.getElementContaining(offset, offset);
        SourceElementElement seElem = new SourceElementElement(element);
        Element[] currentSel = this.editor.getSelection();
        if (currentSel == null || element == null || currentSel.length != 1 || !element.equals(currentSel[0].getData())) {
            this.selectionSetter.setSelection(new Element[]{seElem});
        }
    }

    public void cursorUpdate(CodeEditor codeEditor) {
        this.updateSelection();
    }

    @Override
    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    @Override
    public void notifyCompileScheduled() {
        this.sourceFile = null;
    }

    CodeEditor getCodeEditor() {
        return this.editor;
    }

    @Override
    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        this.sourceFile = sourceFile;
        this.updateSelection();
    }

    private class SourceElementElement
    implements Element {
        private SourceElement sourceElement;

        SourceElementElement(SourceElement sourceElement) {
            this.sourceElement = sourceElement;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return null;
        }

        public Attributes getAttributes() {
            return DefaultAttributes.EMPTY_ATTRIBUTES;
        }

        public Object getData() {
            return this.sourceElement;
        }

        public String getShortLabel() {
            return this.getBasicDisplayableText();
        }

        public String getLongLabel() {
            return this.getBasicDisplayableText();
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return null;
        }

        private String getBasicDisplayableText() {
            if (this.sourceElement == null || this.sourceElement.getClass() == null) {
                return "";
            }
            String s = this.sourceElement.getClass().getName();
            int i = s.indexOf("Sym");
            if (i > 0) {
                s = s.substring(0, i);
            }
            return s;
        }

        public String toString() {
            return "Element containing " + this.sourceElement.toString();
        }
    }
}

