/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.resource.BundleHelper;

final class JavaSmartJoin {
    JavaSmartJoin() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean smartJoin(BasicEditorPane editor) {
        editor.makeEditable();
        if (!editor.isEditable()) {
            return false;
        }
        boolean success = false;
        BundleHelper resources = EditorProperties.getEditorBundle();
        String editName = resources.getString("UNDO_JOIN_LINE");
        EditDescriptor editDescriptor = new EditDescriptor(editName);
        editor.beginEdit(editDescriptor);
        try {
            LineMap lineMap = JavaSmartJoin.getDocument(editor).getLineMap();
            int line = lineMap.getLineFromOffset(editor.getSelectionStart());
            int lastLine = lineMap.getLineFromOffset(editor.getSelectionEnd());
            int lines = lastLine - line;
            if (lineMap.getLineFromOffset(editor.getSelectionStart()) != lineMap.getLineFromOffset(editor.getSelectionEnd())) {
                editor.setSelectionEnd(editor.getSelectionStart());
            }
            do {
                success = false;
                if (line >= lineMap.getLineCount() - 1) {
                    boolean bl = false;
                    return bl;
                }
                int token = JavaSmartJoin.getTokenForOffset(editor, lineMap.getLineEndOffset(line) - 1);
                if (token == 26 || token == 25) {
                    success = JavaSmartJoin.joinMultiComments(editor, line);
                } else if (token == 24) {
                    success = JavaSmartJoin.joinSingleComments(editor, line);
                }
                if (success) continue;
                success = JavaSmartJoin.stripWSJoin(editor, line);
            } while (--lines > 0);
        }
        catch (BadLocationException e) {
        }
        finally {
            editor.endEdit();
        }
        return success;
    }

    private static BasicDocument getDocument(BasicEditorPane editor) {
        return (BasicDocument)editor.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getTokenForOffset(BasicEditorPane editor, int offset) {
        TextBuffer textBuffer = JavaSmartJoin.getDocument(editor).getTextBuffer();
        textBuffer.readLock();
        int token = -1;
        try {
            JavaLexer lexer = new JavaLexer();
            lexer.setSkipComments(false);
            lexer.setRecognizeSQLJ(true);
            LexerToken lexerToken = lexer.createLexerToken();
            lexer.setTextBuffer((ReadTextBuffer)textBuffer);
            int tokenOffset = 0;
            do {
                lexer.setPosition(tokenOffset);
                token = lexer.lex(lexerToken);
                if (offset >= lexerToken.getStartOffset() && offset <= lexerToken.getEndOffset()) {
                    break;
                }
                if (offset < lexerToken.getStartOffset()) {
                    token = 5;
                    break;
                }
                tokenOffset = lexerToken.getEndOffset() + 1;
            } while (token != 0);
        }
        finally {
            textBuffer.readUnlock();
        }
        return token;
    }

    private static boolean joinMultiComments(BasicEditorPane editor, int line) throws BadLocationException {
        String beforeStar;
        String trimmedBeforeStart;
        BasicDocument document = JavaSmartJoin.getDocument(editor);
        LineMap lineMap = document.getLineMap();
        int lineEnd = lineMap.getLineEndOffset(line);
        int nextLineStart = lineMap.getLineStartOffset(line + 1);
        int nextLineEnd = lineMap.getLineEndOffset(line + 1);
        String text = document.getText(nextLineStart, nextLineEnd - nextLineStart);
        document.remove(lineEnd - 1, nextLineEnd - lineEnd);
        int starIndex = text.indexOf("*");
        boolean stripFromStar = true;
        if (starIndex > 0 && (trimmedBeforeStart = (beforeStar = text.substring(0, starIndex)).trim()).length() > 0 && trimmedBeforeStart.charAt(0) != '/') {
            stripFromStar = false;
            text = " " + text.trim() + " ";
        }
        if (starIndex != -1 && stripFromStar) {
            text = text.charAt(starIndex + 1) == '/' ? " " + text.substring(starIndex) : text.substring(starIndex + 1);
        }
        document.insertString(lineEnd - 1, text.substring(0, text.length() - 1), null);
        return true;
    }

    private static boolean joinSingleComments(BasicEditorPane editor, int line) throws BadLocationException {
        BasicDocument document = JavaSmartJoin.getDocument(editor);
        LineMap lineMap = document.getLineMap();
        int lineEnd = lineMap.getLineEndOffset(line);
        int nextLineEnd = lineMap.getLineEndOffset(line + 1);
        String text = document.getText(lineEnd + 1, nextLineEnd - lineEnd - 1);
        document.remove(lineEnd - 1, nextLineEnd - lineEnd);
        String insertText = text.trim();
        if (insertText.length() > 1 && "//".equals(insertText.substring(0, 2))) {
            insertText = insertText.substring(2);
        } else if (insertText.length() > 0) {
            insertText = ' ' + insertText;
        }
        if (insertText.length() > 0) {
            document.insertString(lineEnd - 1, insertText, null);
        }
        return true;
    }

    private static boolean stripWSJoin(BasicEditorPane editor, int line) throws BadLocationException {
        BasicDocument document = JavaSmartJoin.getDocument(editor);
        LineMap lineMap = document.getLineMap();
        int lineEnd = lineMap.getLineEndOffset(line);
        int nextLineEnd = lineMap.getLineEndOffset(line + 1);
        String text = document.getText(lineEnd, nextLineEnd - lineEnd);
        document.remove(lineEnd - 1, nextLineEnd - lineEnd);
        String insertText = text.trim();
        if (insertText.length() > 0 && text.charAt(0) == ' ' && document.getText(lineEnd - 2, 1).trim().length() > 0) {
            insertText = ' ' + insertText;
        }
        document.insertString(lineEnd - 1, insertText, null);
        return true;
    }
}

